/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.net.URI;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementType;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.IManagedFile;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

final class ElementData {
    private final ElementType<?> type;
    private final URI uri;
    private final IFile file;
    private IManagedFile<?, ?> managedFile;

    private static URI computeElementURI(ElementType<?> elementType, IFile file) {
        return DTRTvCommonUtil.getPlatformResourceURI((IResource)file);
    }

    public static IFile computeElementFile(ElementType<?> elementType, URI uri) {
        return DTRTvCommonUtil.getFile((URI)uri);
    }

    ElementData(ElementType<?> elementType, IFile file) {
        assert (elementType != null);
        assert (file != null);
        this.type = elementType;
        this.file = file;
        this.uri = ElementData.computeElementURI(elementType, file);
    }

    public ElementType<?> getType() {
        return this.type;
    }

    public URI getURI() {
        return this.uri;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setManagedFile(IManagedFile<?, ?> managedFile) {
        this.managedFile = managedFile;
    }

    public <E> IManagedFile<E, ?> getManagedFile() {
        return this.managedFile;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElementData other = (ElementData)obj;
        return this.type == other.type && this.uri.equals(other.uri);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DTRTElementData [type=").append(this.type).append(", uri=").append(this.uri).append("]");
        return builder.toString();
    }
}

