/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore;

import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.model.objects.CtrlAttrs;
import oracle.adfdt.model.objects.CtrlList;
import oracle.adfdt.model.objects.CtrlValue;
import oracle.adfdt.model.objects.IteratorBinding;
import oracle.adfdt.model.objects.VariablesIterator;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.StructureDefinition;
import oracle.binding.metaimpl.BaseValueObjectDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ExecutablePackage;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlAttrs;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlList;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlValue;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.impl.UnresolvedDtrtNamedDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.meta.DecoratingObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.meta.MetaPackage;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class ImplicitTypeConverter {
    public Object convert(EStructuralFeature feature, EStructuralFeature actualFeature, DecoratingObject baseObj, Object value) {
        if (feature.getEType().isInstance(value)) {
            return value;
        }
        if (value instanceof Number) {
            if (feature.getEType() instanceof EEnum) {
                int intValue = ((Number)value).intValue();
                EEnum eType = (EEnum)feature.getEType();
                EEnumLiteral eEnumLiteral = eType.getEEnumLiteral(intValue);
                if (eEnumLiteral != null) {
                    return eEnumLiteral.getInstance();
                }
                return null;
            }
        } else if (value instanceof Enumerator) {
            if (feature.getEType() == EcorePackage.Literals.EINT) {
                return ((Enumerator)value).getValue();
            }
            if (feature.getEType() == EcorePackage.Literals.ESTRING) {
                return ((Enumerator)value).getLiteral();
            }
        } else if (value instanceof String) {
            if (feature.getEType() == MetaPackage.Literals.IDEFINITION && baseObj instanceof ICtrlAttrs) {
                if (actualFeature == ExecutablePackage.Literals.ICTRL_VALUE__FIRST_ATTRIBUTE) {
                    return this.convertStringForFirstAttribute(baseObj, value);
                }
            } else {
                if (baseObj instanceof ICtrlList && feature == ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING) {
                    CtrlList list = (CtrlList)baseObj.getDecoratedObject();
                    return this.getListIteratorBinding(list);
                }
                if (feature.getEType() instanceof EEnum) {
                    EEnum eType = (EEnum)feature.getEType();
                    EEnumLiteral eEnumLiteral = eType.getEEnumLiteral((String)value);
                    if (eEnumLiteral != null) {
                        return eEnumLiteral.getInstance();
                    }
                    return null;
                }
            }
        } else if (value instanceof String[] && (feature.getEType() == MetaPackage.Literals.IDEFINITION || feature.getEType() == MetaPackage.Literals.INAMED_DEFINITION) && baseObj instanceof ICtrlValue) {
            CtrlList list;
            IteratorBinding listIteratorBinding;
            if (actualFeature == ExecutablePackage.Literals.ICTRL_VALUE__ATTR_NAMES) {
                CtrlValue attr = (CtrlValue)baseObj.getDecoratedObject();
                IteratorBinding iterator = attr.getIteratorBinding();
                if (iterator != null) {
                    return this.calcDefinitions(iterator, (String[])value);
                }
                return null;
            }
            if (baseObj instanceof ICtrlList && (actualFeature == ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES || actualFeature == ExecutablePackage.Literals.ICTRL_LIST__LIST_DISPLAY_ATTR_NAMES) && (listIteratorBinding = this.getListIteratorBinding(list = (CtrlList)baseObj.getDecoratedObject())) != null) {
                return this.calcDefinitions(listIteratorBinding, (String[])value);
            }
            return null;
        }
        if (value == null) {
            EEnum eType;
            Object defaultValue;
            if (feature.getEType() instanceof EEnum && (defaultValue = (eType = (EEnum)feature.getEType()).getDefaultValue()) != null) {
                return defaultValue;
            }
            return null;
        }
        throw new IllegalArgumentException(String.format("Feature=%s, actualFeature=%s, baseObj=%s, value=%s", feature.getName(), actualFeature.getName(), baseObj instanceof IBaseObject ? ((IBaseObject)baseObj).getId() : "unknown", value.toString()));
    }

    private Object convertStringForFirstAttribute(DecoratingObject baseObj, Object value) {
        CtrlAttrs attr = (CtrlAttrs)baseObj.getDecoratedObject();
        IteratorBinding iterator = attr.getIteratorBinding();
        if (iterator instanceof VariablesIterator) {
            return this.getDefinitionForVariableIterator((VariablesIterator)iterator, value);
        }
        if (iterator != null) {
            StructureDefinition sDef = null;
            try {
                sDef = iterator.getDefinition();
            }
            catch (RuntimeException runtimeException) {}
            if (sDef != null) {
                DefinitionContainer defContainer = sDef.getAttributeDefinitions();
                return defContainer.find((String)value);
            }
        }
        return null;
    }

    private Definition getDefinitionForVariableIterator(VariablesIterator iterator, Object value) {
        ArrayList variableNames = iterator.getVariableNames();
        for (String variableName : variableNames) {
            if (!value.equals(variableName)) continue;
            return new BaseValueObjectDefinition(variableName, null, null, null);
        }
        return null;
    }

    private IteratorBinding getListIteratorBinding(CtrlList ctrlList) {
        String listIteratorName = ctrlList.getListIteratorBindingName();
        if (listIteratorName != null) {
            return ctrlList.getBindingContainer().findIteratorBinding(listIteratorName);
        }
        return null;
    }

    private List<Definition> calcDefinitions(IteratorBinding iterator, String[] values) {
        ArrayList<Definition> defs = new ArrayList<Definition>();
        if (iterator instanceof VariablesIterator) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                Definition definition = this.getDefinitionForVariableIterator((VariablesIterator)iterator, value);
                if (definition != null) {
                    defs.add(definition);
                }
                ++n2;
            }
        } else {
            StructureDefinition sDef = null;
            try {
                sDef = iterator.getDefinition();
            }
            catch (RuntimeException runtimeException) {}
            if (sDef != null) {
                DefinitionContainer defContainer = sDef.getAttributeDefinitions();
                String[] stringArray = values;
                int n = values.length;
                int n3 = 0;
                while (n3 < n) {
                    String attrName = stringArray[n3];
                    Definition def = defContainer.find(attrName);
                    if (def != null) {
                        defs.add(def);
                    } else {
                        defs.add((Definition)new UnresolvedDtrtNamedDefinition(iterator, attrName));
                    }
                    ++n3;
                }
            } else {
                String[] stringArray = values;
                int n = values.length;
                int n4 = 0;
                while (n4 < n) {
                    String attrName = stringArray[n4];
                    defs.add((Definition)new UnresolvedDtrtNamedDefinition(iterator, attrName));
                    ++n4;
                }
            }
        }
        return defs;
    }
}

