/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExceptionHandler {
    public static final ExceptionHandler INSTANCE = new ExceptionHandler();

    public <T> T rethrow(Throwable exception) throws Error, RuntimeException {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        throw new RuntimeException(exception);
    }

    public Throwable determineCause(Throwable e) {
        if (e instanceof InvocationTargetException) {
            return this.handleInvocationTargetException((InvocationTargetException)e);
        }
        return e;
    }

    protected Throwable handleInvocationTargetException(InvocationTargetException e) {
        return e.getCause();
    }

    public IStatus createStatus(Throwable cause) {
        String message = Messages.ExceptionHandler_UnknownError;
        if (cause instanceof NumberFormatException) {
            message = String.format(Messages.ExceptionHandler_ANumericValueWasExpected, cause.getLocalizedMessage());
        }
        return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", message, cause);
    }
}

