/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore;

import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.model.objects.BaseObject;
import oracle.adfdt.model.objects.CtrlHier;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.EMFObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.IAdaptingList;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.meta.DecoratingObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;

public class DtrtAdaptationStrategy<ADAPTORTYPE extends IBaseObject, ADAPTEDTYPE extends BaseObject> {
    private static final EMFObjectTranslator translator = EMFObjectTranslator.INSTANCE;

    public void initializeList(EObject owner, IAdaptingList<ADAPTORTYPE> list, EStructuralFeature feature) {
        Object initialValue = owner.eGet(feature);
        if (initialValue != null) {
            for (BaseObject source : (List)initialValue) {
                this.addAdaptedObject(owner, list, source);
            }
        }
    }

    public boolean didAdd(EObject owner, IAdaptingList<ADAPTORTYPE> list, ADAPTORTYPE value, int offset) {
        return true;
    }

    public boolean didRemove(EObject owner, IAdaptingList<ADAPTORTYPE> list, ADAPTORTYPE value, int offset) {
        return true;
    }

    public void didClear(EObject owner, IAdaptingList<ADAPTORTYPE> list, int size, Object[] oldObjects) {
    }

    public void doClear(EObject owner, IAdaptingList<ADAPTORTYPE> list) {
    }

    public void addAdaptedObject(EObject owner, IAdaptingList<ADAPTORTYPE> list, ADAPTEDTYPE source) {
        list.add(this.create(owner, source));
    }

    public void applyChanges(EObject owner, int featureId, List<ADAPTORTYPE> fromList) {
        Object dtrtList;
        EStructuralFeature eStructuralFeature = owner.eClass().getEStructuralFeature(featureId);
        if (eStructuralFeature != null && (dtrtList = this.toDtrtList(fromList, eStructuralFeature)) instanceof ArrayList) {
            Object decoratedObject;
            if (owner instanceof DecoratingObject && (decoratedObject = ((DecoratingObject)owner).getDecoratedObject()) instanceof CtrlHier) {
                ((CtrlHier)decoratedObject).removeChildNodes();
            }
            owner.eSet(eStructuralFeature, dtrtList);
        }
    }

    private Object toDtrtList(List<ADAPTORTYPE> list, EStructuralFeature eStructuralFeature) {
        try {
            Class clazz = eStructuralFeature.getEType().getInstanceClass();
            List dtrtList = (List)clazz.newInstance();
            for (IBaseObject item : list) {
                BaseObject decoratedObject = (BaseObject)item.getDecoratedObject();
                dtrtList.add(decoratedObject);
            }
            return dtrtList;
        }
        catch (InstantiationException e) {
            DTRTvBundle.log(e);
        }
        catch (IllegalAccessException e) {
            DTRTvBundle.log(e);
        }
        return null;
    }

    protected ADAPTORTYPE create(EObject owner, ADAPTEDTYPE source) {
        EObject adaptor = translator.create(owner, source);
        if (adaptor == null) {
            throw new AssertionError((Object)("Unable to adapt type:" + source));
        }
        if (adaptor instanceof DecoratingObject) {
            ((DecoratingObject)adaptor).setDecoratedObject(source);
        }
        if (owner instanceof EStoreEObjectImpl && adaptor instanceof EStoreEObjectImpl) {
            ((EStoreEObjectImpl)adaptor).eSetStore(((EStoreEObjectImpl)owner).eStore());
        }
        return (ADAPTORTYPE)((IBaseObject)adaptor);
    }

    protected static abstract class AddMethodRunnable<T> {
        public static final int NO_OFFSET = -1;

        protected AddMethodRunnable() {
        }

        public abstract void add(int var1, T var2);

        public boolean add(T value) {
            this.add(-1, value);
            return true;
        }
    }
}

