/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind;

import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.BinderResult;
import oracle.adfdt.view.common.binding.creator.v2.PatternOptions;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.IInternalWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.WidgetImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.NamespaceUtils;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class BindHelper
implements BindCommand.IBindCommandHelper {
    BindHelper() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void assertExecution(BindCommand bindCommand) throws Exception {
        IInternalWidget widget = bindCommand.getWidget();
        DTRTUtil.assertTrue((boolean)(widget instanceof WidgetImpl), (String)"Can only edit or bind to data control objects.");
        DTRTUtil.assertTrue((widget.getNodeToBind() != null ? 1 : 0) != 0, (String)"The node to bind of a binding command cannot be null.");
    }

    @Override
    public boolean assertUndo(BindCommand bindCommand) throws Exception {
        return true;
    }

    @Override
    public boolean assertRedo(BindCommand bindCommand) throws Exception {
        return true;
    }

    @Override
    public void afterUndo(BindCommand bindCommand, IProgressMonitor monitor) throws Exception {
    }

    @Override
    public void afterRedo(BindCommand bindCommand, IProgressMonitor monitor) throws Exception {
    }

    private Node getNodeToBind(BindCommand bindCommand) {
        IInternalWidget widget = bindCommand.getWidget();
        return widget != null ? widget.getNodeToBind() : null;
    }

    @Override
    public Document getBoundDocument(BindCommand bindCommand) {
        Node nodeToBind = this.getNodeToBind(bindCommand);
        return nodeToBind != null ? nodeToBind.getOwnerDocument() : null;
    }

    @Override
    public Object prepareBind(BindCommand bindCommand, IPageDefinition.IBoundSource boundSource) throws Exception {
        return bindCommand.getWidgetAndOptionsMapper();
    }

    @Override
    public boolean bind(BindCommand bindCommand, IProject project, Object preparedData, IProgressMonitor monitor) throws Exception {
        Pair pair = (Pair)preparedData;
        return this.bind(bindCommand, project, (Widget<PatternOptions>)((Widget)pair.getFirst()), (IOptionsMapper)pair.getSecond());
    }

    private boolean bind(BindCommand bindCommand, IProject project, Widget<PatternOptions> widget, IOptionsMapper optionsMapper) throws Exception {
        if (widget != null) {
            Object actualOptions;
            Node nodeToBind = this.getNodeToBind(bindCommand);
            BinderParams params = widget.createBaseBinderParams(nodeToBind.getParentNode(), nodeToBind);
            if (optionsMapper != null && (actualOptions = optionsMapper.getPatternOptions()) instanceof PatternOptions) {
                params.setOptions((PatternOptions)actualOptions);
            }
            int[] region = bindCommand.computeRegion(nodeToBind);
            if (BinderResult.OK.equals(widget.bind(params))) {
                if (optionsMapper != null) {
                    optionsMapper.postProcess(nodeToBind);
                }
                NamespaceUtils.ensureNamespacesSet((IProject)project, (Document)nodeToBind.getOwnerDocument(), (Node)nodeToBind, (boolean)false);
                this.formatNode(bindCommand, nodeToBind);
                bindCommand.setUndoChangeRegion(region);
                bindCommand.setExecuteChangeRegion(bindCommand.computeRegion(nodeToBind));
                return true;
            }
        }
        return false;
    }

    private void formatNode(BindCommand bindCommand, Node node) {
        if (node != null) {
            Node childNode = node.getFirstChild();
            while (childNode != null && childNode.getNodeType() == 3) {
                node.removeChild(childNode);
                childNode = node.getFirstChild();
            }
        }
        bindCommand.formatNode(node);
    }
}

