/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind;

import java.util.Collections;
import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.PatternOptions;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandRunnable;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.IBindCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IWidget;
import oracle.eclipse.tools.adf.dtrt.ui.command.IUIProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.SSEUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.UndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.CreateBindingHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.WebApplication;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.IInternalWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.WidgetImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.IOptionsMapperProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder.DocumentRecorder;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.BindWizard;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.ADFTagIdGenerationUtil;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class BindCommand
extends UndoableRunnableCommand
implements IBindCommand {
    private IInternalWidget widget;
    private IBindCommand.IBindCommandParticipant participant;
    private Document document;
    private DocumentRecorder documentRecorder;
    private Object recordedData;
    private int[] executeChangeRegion;
    private int[] undoChangeRegion;
    private IBindCommandHelper helper;

    public BindCommand(IWebPageContext context) {
        super((IOEPEExecutableContext)context);
        this.setUndoInterruptedExecution(true);
    }

    @Override
    public void dispose() {
        this.widget = null;
        this.participant = null;
        this.recordedData = null;
        if (this.helper != null) {
            this.helper.dispose();
            this.helper = null;
        }
        if (this.documentRecorder != null) {
            if (this.document != null) {
                this.documentRecorder.abortRecording(this.document);
            } else {
                this.documentRecorder.resetRecording();
            }
            this.documentRecorder = null;
        }
        this.document = null;
        super.dispose();
    }

    private IBindCommandHelper getBindCommandHelper() {
        if (this.helper == null && this.widget != null) {
            this.helper = this.widget.getBindOperationType() == BindOperationType.CREATE ? new CreateBindingHelper() : new BindHelper();
        }
        return this.helper;
    }

    public IWebPageContext getCommandStack() {
        return (IWebPageContext)super.getCommandStack();
    }

    public String getLabel() {
        String label = DTRTUtil.getLabel((IDescribable)this.getWidget());
        return label != null ? NLS.bind((String)this.getLabelMessage(), (Object)label) : null;
    }

    private String getLabelMessage() {
        switch (this.getWidget().getBindOperationType()) {
            case CREATE: {
                return Messages.createBinding;
            }
            case EDIT: {
                return Messages.editBinding;
            }
        }
        return Messages.bind;
    }

    public BindCommand clone() {
        return new BindCommand(this.getCommandStack()).setWidget(this.getWidget()).setParticipant(this.getParticipant());
    }

    public List<? extends IObject> getAffectedObjects() {
        return super.getAffectedObjects();
    }

    public BindCommand setWidget(IWidget widget) {
        this.checkExecuted();
        this.widget = (IInternalWidget)widget;
        return this;
    }

    public IInternalWidget getWidget() {
        return this.widget;
    }

    public BindCommand setParticipant(IBindCommand.IBindCommandParticipant participant) {
        this.checkExecuted();
        this.participant = participant;
        return this;
    }

    public IBindCommand.IBindCommandParticipant getParticipant() {
        return this.participant;
    }

    public int[] getChangeRegion() {
        return this.getLastOperation() != ICommand.CommandOperation.UNDO ? this.executeChangeRegion : this.undoChangeRegion;
    }

    protected void assertExecution() throws Exception {
        DTRTUtil.assertTrue((DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack()) != null ? 1 : 0) != 0, (String)"Invalid context.");
        DTRTUtil.assertTrue((this.getWidget() != null ? 1 : 0) != 0, (String)"The widget of a create binding command cannot be null.");
        DTRTUtil.assertTrue((this.getWidget() instanceof WidgetImpl || this.getWidget() instanceof TaskFlowWidget ? 1 : 0) != 0, (String)("Unknown widget type - " + this.getWidget()));
        IBindCommandHelper helper = this.getBindCommandHelper();
        DTRTUtil.assertTrue((helper != null ? 1 : 0) != 0, (String)"Unknown widget.");
        if (helper != null) {
            helper.assertExecution(this);
        }
        this.document = this.getBindCommandHelper().getBoundDocument(this);
        DTRTUtil.assertTrue((this.document != null ? 1 : 0) != 0, (String)"The node to bind must belong to a document.");
        this.documentRecorder = DocumentRecorder.createDocumentRecorder((Document)this.document);
        DTRTUtil.assertTrue((this.documentRecorder != null ? 1 : 0) != 0, (String)"Unknown document type: %s", (Object[])new Object[]{this.document});
        if (this.getExecutionRunnable() == null) {
            this.setExecutionRunnable("command", (Runnable)new ICommandRunnable(){

                public void run() {
                    throw new IllegalStateException("Should not be invoked");
                }

                public void dispose() {
                }

                public boolean isDisposed() {
                    return BindCommand.this.isDisposed();
                }

                public List<? extends IObject> run(ICommandStack commandStack, ICommand.CommandOperation operation, IProgressMonitor monitor) throws Exception {
                    return Collections.singletonList(BindCommand.this.bind(monitor));
                }
            });
        }
    }

    private IPageDefinition bind(IProgressMonitor monitor) throws Exception {
        assert (this.document != null);
        assert (this.documentRecorder != null);
        assert (!this.documentRecorder.isRecording());
        assert (this.recordedData == null);
        IWebPageContext webPageContext = this.getCommandStack();
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)webPageContext);
        IPageDefinition.IBoundSource boundSource = manager.getBoundSource();
        assert (boundSource != null);
        Object preparedData = this.getBindCommandHelper().prepareBind(this, boundSource);
        try {
            manager.setWebPageDocument(this.document);
            this.documentRecorder.beginRecording(this.document);
            if (this.getBindCommandHelper().bind(this, manager.getProject(), preparedData, monitor)) {
                this.recordedData = this.documentRecorder.endRecording(this.document);
            }
        }
        finally {
            this.documentRecorder.abortRecording(this.document);
            manager.setWebPageDocument(null);
        }
        IPageDefinition pageDefinition = webPageContext.getPageDefinition();
        assert (pageDefinition != null);
        WebApplication.configureForADFBindings(manager, true);
        return pageDefinition;
    }

    Pair<Widget<PatternOptions>, IOptionsMapper> getWidgetAndOptionsMapper() throws Exception {
        IOptionsMapper optionsMapper = null;
        if (this.getParticipant() instanceof IOptionsMapperProvider) {
            optionsMapper = ((IOptionsMapperProvider)this.getParticipant()).getOptionsMapper();
        }
        if (optionsMapper == null) {
            optionsMapper = WidgetImpl.createOptionsMapper((WidgetImpl)this.widget, this);
        }
        if (optionsMapper != null && optionsMapper.hasOptions() && !this.handleOptionsMapperModel(this.getCommandStack(), optionsMapper, this.getParticipant())) {
            throw new IllegalStateException("The binding command participant must provide a shell for this type of options mapper");
        }
        IObjectTranslator translator = OEPEContextImpl.getTranslator((IOEPEContext)this.getCommandStack());
        Widget dtrtWidget = (Widget)translator.toADFObject((IObject)this.widget);
        return new Pair((Object)dtrtWidget, (Object)optionsMapper);
    }

    void formatNode(Node node) {
        if (node instanceof IDOMElement && ADFTagIdGenerationUtil.isAutoGenerateIds()) {
            ADFTagIdGenerationUtil.createIds((IDOMElement)((IDOMElement)node), (Document)node.getOwnerDocument());
        }
        try {
            new FormatProcessorXML().formatNode(node);
        }
        catch (Exception exception) {}
    }

    int[] computeRegion(Node node) {
        return node instanceof IDOMNode ? SSEUtil.computeRegion((IDOMNode)((IDOMNode)node)) : null;
    }

    @Override
    protected void assertUndo() throws Exception {
        DTRTUtil.assertTrue((this.recordedData != null ? 1 : 0) != 0, (String)"There is no information to undo the changes made to the bounded document.");
        if (this.getBindCommandHelper().assertUndo(this)) {
            super.assertUndo();
        }
    }

    protected void afterUndo(IProgressMonitor monitor) throws Exception {
        this.getBindCommandHelper().afterUndo(this, monitor);
        this.applyRecordedData();
    }

    @Override
    protected void assertRedo() throws Exception {
        DTRTUtil.assertTrue((this.recordedData != null ? 1 : 0) != 0, (String)"There is no information to redo the changes made to the bounded document.");
        if (this.getBindCommandHelper().assertRedo(this)) {
            super.assertRedo();
        }
    }

    protected void afterRedo(IProgressMonitor monitor) throws Exception {
        this.getBindCommandHelper().afterRedo(this, monitor);
        this.applyRecordedData();
    }

    private void applyRecordedData() {
        if (this.recordedData != null) {
            assert (this.document != null);
            assert (this.documentRecorder != null);
            this.recordedData = this.documentRecorder.apply(this.document, this.recordedData);
        }
    }

    private boolean handleOptionsMapperModel(IWebPageContext webPageContext, IOptionsMapper optionsMapper, IBindCommand.IBindCommandParticipant participant) throws Exception {
        if (participant instanceof IUIProvider) {
            BindWizard wizard = new BindWizard(optionsMapper);
            BindWizardDialog dialog = new BindWizardDialog(((IUIProvider)participant).getShell(), (IWizard)wizard);
            wizard.setWindowTitle(NLS.bind((String)Messages.bind, (Object)optionsMapper.getComponentName()));
            int result = dialog.open();
            if (1 == result) {
                throw new InterruptedException("User cancelled");
            }
            return true;
        }
        if (participant instanceof IOptionsMapperProvider) {
            return ((IOptionsMapperProvider)participant).handleOptionsMapperModel(webPageContext, optionsMapper);
        }
        return false;
    }

    void setExecuteChangeRegion(int[] executeChangeRegion) {
        this.executeChangeRegion = executeChangeRegion;
    }

    void setUndoChangeRegion(int[] undoChangeRegion) {
        this.undoChangeRegion = undoChangeRegion;
    }

    private static class BindWizardDialog
    extends WizardDialog {
        public BindWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        protected void initializeBounds() {
            this.getShell().setMinimumSize(500, 500);
            super.initializeBounds();
        }
    }

    static interface IBindCommandHelper {
        public void dispose();

        public void assertExecution(BindCommand var1) throws Exception;

        public boolean assertUndo(BindCommand var1) throws Exception;

        public boolean assertRedo(BindCommand var1) throws Exception;

        public void afterUndo(BindCommand var1, IProgressMonitor var2) throws Exception;

        public void afterRedo(BindCommand var1, IProgressMonitor var2) throws Exception;

        public Document getBoundDocument(BindCommand var1);

        public Object prepareBind(BindCommand var1, IPageDefinition.IBoundSource var2) throws Exception;

        public boolean bind(BindCommand var1, IProject var2, Object var3, IProgressMonitor var4) throws Exception;
    }
}

