/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.command;

import java.util.Collections;
import java.util.List;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateTaskFlowActivityPageDefinitionCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.WebApplication;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.BoundSourceUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.ContextCommandImpl;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateTaskFlowActivityPageDefinitionCommand
extends ContextCommandImpl
implements ICreateTaskFlowActivityPageDefinitionCommand {
    private Object activity;
    private IPageDefinition pageDefinition;

    public CreateTaskFlowActivityPageDefinitionCommand(ITaskFlowContext context) {
        super((IOEPEExecutableContext)context);
    }

    public void dispose() {
        this.pageDefinition = null;
        this.activity = null;
        super.dispose();
    }

    public String getLabel() {
        return Messages.createPageDefinition;
    }

    public List<? extends IObject> getAffectedObjects() {
        return this.getLastOperation() != ICommand.CommandOperation.UNDO && this.pageDefinition != null ? Collections.singletonList(this.pageDefinition) : Collections.emptyList();
    }

    public CreateTaskFlowActivityPageDefinitionCommand setActivity(Object activity) throws IllegalStateException {
        this.checkExecuted();
        this.activity = activity;
        return this;
    }

    public Object getActivity() {
        return this.activity;
    }

    public CreateTaskFlowActivityPageDefinitionCommand clone() {
        return new CreateTaskFlowActivityPageDefinitionCommand((ITaskFlowContext)this.getCommandStack()).setActivity(this.activity);
    }

    protected void assertExecution() throws Exception {
        DTRTUtil.assertTrue((this.getActivity() != null ? 1 : 0) != 0, (String)"The activity attribute cannot be null.");
        super.assertExecution();
        ITaskFlowContext taskFlowContext = (ITaskFlowContext)this.getCommandStack();
        DTRTUtil.assertTrue((boolean)taskFlowContext.isValidBoundSourceActivity(this.activity), (String)"The command's activity is not valid.");
        DTRTUtil.assertTrue((DTRTvContextUtil.getManager((IOEPEContext)taskFlowContext) != null ? 1 : 0) != 0, (String)"Invalid context.");
        IPageDefinition pageDefinition = taskFlowContext.getPageDefinition(this.activity);
        DTRTUtil.assertTrue((pageDefinition == null ? 1 : 0) != 0, (String)"The page definition exists and cannot be created again - %s", (Object[])new Object[]{DTRTvContextUtil.getManager((IOEPEContext)taskFlowContext).getBoundSource()});
        DTRTUtil.assertTrue((taskFlowContext.getAccessibleFile((IObject)pageDefinition) == null ? 1 : 0) != 0, (String)"PageDefinition file exists and cannot be created for '%s'", (Object[])new Object[]{DTRTvContextUtil.getManager((IOEPEContext)taskFlowContext).getBoundSource()});
    }

    protected void doExecute(IProgressMonitor monitor) throws Exception {
        ITaskFlowContext context = (ITaskFlowContext)this.getCommandStack();
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)context);
        manager.setBoundSource(BoundSourceUtil.createTaskFlowBoundSource((ITaskFlowContext.ITaskFlowProxy)context.getTaskFlow(), (Object)this.activity));
        PageDefinition adfPageDefinition = manager.getPageDefinition(true);
        if (adfPageDefinition != null) {
            this.pageDefinition = context.getPageDefinition(this.activity);
        }
        WebApplication.configureForADFBindings(DTRTvContextUtil.getManager((IOEPEContext)context), true);
    }

    protected void assertUndo() throws Exception {
        throw new IllegalStateException("Page definition creation cannot be undone");
    }

    protected void doUndo(IProgressMonitor monitor) throws Exception {
        this.assertUndo();
    }
}

