/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.validator.CompositeFeatureValidationStatusProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.util.ExecutableValidator;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;

public class EditorValidationStore
extends ValidationStatusProvider {
    private final EValidator emfValidator;
    private final WritableValue curStatusValue;
    private final EObject eObject;
    private final Map<Object, Object> context;
    private final Map<EStructuralFeature, WritableValue> perFeatureCache = LazyMap.decorate(new HashMap(), (Factory)new WritableFactory());
    private final Map<EStructuralFeature, FeatureValidationStatusProvider> featureValidationProviders = new HashMap<EStructuralFeature, FeatureValidationStatusProvider>();
    private IObservableList targets;
    private IObservableList models;
    private IValueChangeListener modelChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            EditorValidationStore.this.validate();
        }
    };

    public EditorValidationStore(EValidator emfValidator, EObject eObject, Map<Object, Object> context, Realm realm) {
        this.emfValidator = emfValidator;
        this.eObject = eObject;
        this.context = context;
        this.curStatusValue = new WritableValue(realm);
    }

    public ValidationStatusProvider getValidationStatus(EStructuralFeature feature) {
        return this.getOrCreateValidationStatus(feature);
    }

    private FeatureValidationStatusProvider getOrCreateValidationStatus(EStructuralFeature feature) {
        FeatureValidationStatusProvider featureValidationStatusProvider = this.featureValidationProviders.get(feature);
        if (featureValidationStatusProvider == null) {
            WritableValue object = this.perFeatureCache.get(feature);
            featureValidationStatusProvider = new FeatureValidationStatusProvider(feature, object);
            this.featureValidationProviders.put(feature, featureValidationStatusProvider);
        }
        return featureValidationStatusProvider;
    }

    public ValidationStatusProvider getValidationStatus(Collection<? extends EStructuralFeature> features) {
        HashMap<EStructuralFeature, FeatureValidationStatusProvider> providers = new HashMap<EStructuralFeature, FeatureValidationStatusProvider>();
        for (EStructuralFeature eStructuralFeature : features) {
            providers.put(eStructuralFeature, this.getOrCreateValidationStatus(eStructuralFeature));
        }
        return new CompositeFeatureValidationStatusProvider(features, this.featureValidationProviders);
    }

    public IStatus validate() {
        BasicDiagnostic diagnostic = new BasicDiagnostic("oracle.eclipse.tools.adf.dtrt.v110101", 0, "Multistatus", null);
        if (!this.emfValidator.validate(this.eObject, (DiagnosticChain)diagnostic, this.context)) {
            HashMap<EStructuralFeature, BasicDiagnostic> newDiags = new HashMap<EStructuralFeature, BasicDiagnostic>();
            for (Diagnostic diagnostic2 : diagnostic.getChildren()) {
                Object data;
                if (diagnostic2.getData().isEmpty() || !((data = diagnostic2.getData().get(0)) instanceof ExecutableValidator.ErrorDescriptor)) continue;
                ExecutableValidator.ErrorDescriptor errorDesc = (ExecutableValidator.ErrorDescriptor)data;
                BasicDiagnostic byFeature = (BasicDiagnostic)newDiags.get(errorDesc.getFeature());
                if (byFeature == null) {
                    byFeature = new BasicDiagnostic("oracle.eclipse.tools.adf.dtrt.v110101", 0, "This diag is a container", null);
                    newDiags.put(errorDesc.getFeature(), byFeature);
                }
                byFeature.add(diagnostic2);
            }
            for (Map.Entry entry : this.perFeatureCache.entrySet()) {
                if (newDiags.containsKey(entry.getKey())) {
                    this.perFeatureCache.get(entry.getKey()).setValue(newDiags.get(entry.getKey()));
                    continue;
                }
                this.perFeatureCache.get(entry.getKey()).setValue((Object)Diagnostic.OK_INSTANCE);
            }
            this.curStatusValue.setValue((Object)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
        } else {
            for (Map.Entry<EStructuralFeature, WritableValue> change : this.perFeatureCache.entrySet()) {
                change.getValue().setValue((Object)Diagnostic.OK_INSTANCE);
            }
            this.curStatusValue.setValue((Object)Status.OK_STATUS);
        }
        return (IStatus)this.curStatusValue.getValue();
    }

    public void dispose() {
        super.dispose();
        if (this.models != null) {
            this.models.clear();
            this.models = null;
        }
        if (this.targets != null) {
            this.targets.clear();
            this.targets = null;
        }
        if (this.featureValidationProviders != null) {
            for (Map.Entry<EStructuralFeature, FeatureValidationStatusProvider> entry : this.featureValidationProviders.entrySet()) {
                entry.getValue().dispose();
            }
        }
        if (this.perFeatureCache != null) {
            for (Map.Entry<EStructuralFeature, FeatureValidationStatusProvider> entry : this.perFeatureCache.entrySet()) {
                ((WritableValue)entry.getValue()).dispose();
            }
            this.perFeatureCache.clear();
        }
        if (this.context != null) {
            this.context.clear();
        }
    }

    public IObservableValue getValidationStatus() {
        return Observables.unmodifiableObservableValue((IObservableValue)this.curStatusValue);
    }

    public IObservableList getTargets() {
        if (this.targets == null) {
            this.targets = new WritableList();
        }
        return this.targets;
    }

    public IObservableList getModels() {
        if (this.models == null) {
            this.models = new WritableList();
            this.models.addListChangeListener(new IListChangeListener(){

                public void handleListChange(ListChangeEvent event) {
                    ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
                    int n = listDiffEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ListDiffEntry diffEntry = listDiffEntryArray[n2];
                        Object element = diffEntry.getElement();
                        if (element instanceof EObjectObservableValue && ExecutableValidator.getFeaturesToValidate(EditorValidationStore.this.context).contains(((EObjectObservableValue)element).getValueType())) {
                            if (diffEntry.isAddition()) {
                                ((IObservableValue)element).addValueChangeListener(EditorValidationStore.this.modelChangeListener);
                            } else {
                                ((IObservableValue)element).removeValueChangeListener(EditorValidationStore.this.modelChangeListener);
                            }
                        }
                        ++n2;
                    }
                }
            });
        }
        return this.models;
    }

    static class FeatureValidationStatusProvider
    extends ValidationStatusProvider {
        private final WritableValue diagnostic;
        private WritableList models;
        private WritableList targets;
        private DecoratingObservableValue validationStatusObservable;

        public FeatureValidationStatusProvider(EStructuralFeature feature, WritableValue diagnostic) {
            this.diagnostic = diagnostic;
        }

        public IObservableValue getValidationStatus() {
            if (this.validationStatusObservable == null) {
                this.validationStatusObservable = new DecoratingObservableValue((IObservableValue)this.diagnostic, false){

                    public Object getValue() {
                        this.getterCalled();
                        BasicDiagnostic diag = (BasicDiagnostic)super.getValue();
                        if (diag == null) {
                            return Status.OK_STATUS;
                        }
                        return BasicDiagnostic.toIStatus((Diagnostic)diag);
                    }

                    public synchronized void addValueChangeListener(IValueChangeListener listener) {
                        ((IObservableValue)this.getDecorated()).addValueChangeListener(listener);
                    }

                    public synchronized void removeValueChangeListener(IValueChangeListener listener) {
                        if (!this.isDisposed()) {
                            ((IObservableValue)this.getDecorated()).removeValueChangeListener(listener);
                        }
                    }

                    public void setValue(Object value) {
                        throw new UnsupportedOperationException("Not settable");
                    }

                    public Object getValueType() {
                        return IStatus.class;
                    }
                };
            }
            return this.validationStatusObservable;
        }

        public IObservableList getTargets() {
            if (this.targets == null) {
                this.targets = new WritableList();
            }
            return this.targets;
        }

        public IObservableList getModels() {
            if (this.models == null) {
                this.models = new WritableList();
            }
            return this.models;
        }

        public void dispose() {
            if (this.validationStatusObservable != null) {
                this.validationStatusObservable.dispose();
                this.validationStatusObservable = null;
            }
            if (this.targets != null) {
                this.targets.clear();
                this.targets = null;
            }
            if (this.models != null) {
                this.models.clear();
                this.models = null;
            }
            super.dispose();
        }
    }

    private static class WritableFactory
    implements Factory {
        private WritableFactory() {
        }

        public Object create() {
            return new WritableValue(Realm.getDefault(), null, BasicDiagnostic.class);
        }
    }
}

