/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ADFTypeResolver;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class DataControlObjectLookup {
    private IObservableValue iterator;
    private IPageDefinitionContext context;

    public DataControlObjectLookup(IObservableValue iterator, IPageDefinitionContext context) {
        this.iterator = iterator;
        this.context = context;
    }

    public List<IDataControlObject> getAttributeChildren() {
        IDataControlObject dataControlObject;
        ArrayList<IDataControlObject> attributes = new ArrayList<IDataControlObject>();
        IExecutable iterator = this.getIterator();
        if (iterator != null && (dataControlObject = iterator.getDataControlObject()) != null) {
            for (IDataControlObject child : dataControlObject.getChildren()) {
                if (!ADFTypeResolver.INSTANCE.isSimpleTypeAttribute(child)) continue;
                attributes.add(child);
            }
        }
        return attributes;
    }

    private IExecutable getIterator() {
        String listIteratorName = (String)this.iterator.getValue();
        IExecutable listIterator = (IExecutable)DTRTObjectUtil.find((Collection)this.context.getPageDefinition().getExecutables(), (String)listIteratorName);
        return listIterator;
    }

    public IDataControlObject findChild(String id) {
        if (id == null) {
            return null;
        }
        IExecutable iterator = this.getIterator();
        if (iterator != null) {
            IDataControlObject dataControlObject = iterator.getDataControlObject();
            for (IDataControlObject child : dataControlObject.getChildren()) {
                if (!ADFTypeResolver.INSTANCE.isAttribute(child) || !id.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }
}

