/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.binding.ErrorTolerantEObjectObservableValue;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.validator.EditorValidationStore;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.DtrtBoundEStoreEObjectImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariablesIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.util.ExecutableValidator;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.DataControlJavaTypeResolver;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.IControlDecorationUpdateFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.EnhancedFormWidgetAdapter;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.PopupControlDecorationUpdater;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.PropertyEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TextControlDecorationUpdater;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.converter.DataControlLabelConverter;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.converter.StatusConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FormsWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractEditor<T extends IBaseObject>
extends BasicObjectEditor {
    private static final boolean isDebugMode = Platform.isRunning() && Platform.inDebugMode();
    protected final EnhancedFormWidgetAdapter widgetAdapter;
    protected final ExecutableValidator validator = ExecutableValidator.INSTANCE;
    protected FormToolkit toolkit;
    private ObservablesManager obsManager = new ObservablesManager();
    private boolean isFirstRefresh = true;
    private DataBindingContext dataBindingContext;
    private List<EStructuralFeature> featuresToValidate = new ArrayList<EStructuralFeature>(2);
    private EditorValidationStore validationStore;
    private Composite editorComposite;
    private IOEPEExecutableContext.IExecutableContextListener commandStackListener;
    private MultiValidator multiValidator;
    private IPageDefinitionContext editorContext;

    public AbstractEditor(T eObj, IPageDefinitionContext editorContext) {
        super(eObj);
        this.widgetAdapter = EnhancedFormWidgetAdapter.INSTANCE;
        this.editorContext = editorContext;
    }

    public IPageDefinitionContext getContext() {
        return this.editorContext;
    }

    protected void updateModelToTarget() {
        this.dataBindingContext.updateTargets();
    }

    protected void redrawUI() {
        if (!this.editorComposite.isDisposed()) {
            SWTObservables.getRealm((Display)this.editorComposite.getDisplay()).exec(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractEditor.this.editorComposite.isDisposed() && !AbstractEditor.this.editorComposite.getParent().isDisposed()) {
                        AbstractEditor.this.editorComposite.getParent().layout(true, true);
                        Rectangle bounds = AbstractEditor.this.editorComposite.getBounds();
                        AbstractEditor.this.editorComposite.getParent().redraw(bounds.x, bounds.y, bounds.height, bounds.width, true);
                    }
                }
            });
        }
    }

    public void dispose() {
        T model = this.getModel();
        if (this.commandStackListener != null) {
            this.getContext().removeListener((IOEPEContext.IContextListener)this.commandStackListener);
            this.commandStackListener = null;
        }
        if (this.obsManager != null) {
            this.obsManager.dispose();
            this.obsManager = null;
        }
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
            this.dataBindingContext = null;
        }
        if (this.multiValidator != null) {
            this.multiValidator.dispose();
            this.multiValidator = null;
        }
        if (this.validationStore != null) {
            this.validationStore.dispose();
            this.validationStore = null;
        }
        if (this.featuresToValidate != null) {
            this.featuresToValidate.clear();
            this.featuresToValidate = null;
        }
        this.editorContext = null;
        this.toolkit = null;
        super.dispose();
        if (isDebugMode && model instanceof DtrtBoundEStoreEObjectImpl) {
            ((DtrtBoundEStoreEObjectImpl)((Object)model)).dumpListeners();
        }
    }

    protected final Composite doCreateControl(IManagedForm managedForm, FormToolkit toolkit, Composite composite) {
        this.toolkit = toolkit;
        this.editorComposite = toolkit.createComposite(composite);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        this.editorComposite.setLayout((Layout)gl);
        this.addControls(managedForm, toolkit, this.editorComposite);
        return this.editorComposite;
    }

    public void refresh() {
        if (this.isFirstRefresh) {
            this.dataBindingContext = new DataBindingContext();
            this.validationStore = new EditorValidationStore((EValidator)this.validator, (EObject)this.getModel(), ExecutableValidator.createFeatureOnlyValidationContext(this.featuresToValidate, new DataControlJavaTypeResolver((IOEPEContext)this.getContext())), this.dataBindingContext.getValidationRealm());
            this.bindControls(this.dataBindingContext, this.getModel());
            this.validationStore.validate();
            this.commandStackListener = new ExecutableContextAdapter(){

                public void handleCommandOperation(IOEPEExecutableContext context, ICommand command) {
                    if (!AbstractEditor.this.isDisposed()) {
                        AbstractEditor.this.refreshUI(command);
                    }
                }
            };
            this.getContext().addListener((IOEPEContext.IContextListener)this.commandStackListener);
            this.isFirstRefresh = false;
        } else {
            this.validationStore.validate();
            this.dataBindingContext.updateTargets();
        }
    }

    protected void refreshUI(ICommand command) {
        EnumSet<IBaseObject.CachedProperty> propertyChanges = EnumSet.allOf(IBaseObject.CachedProperty.class);
        propertyChanges.remove((Object)IBaseObject.CachedProperty.PARENT);
        this.getModel().handlePropertyChange(propertyChanges.toArray());
        this.validationStore.validate();
        this.updateModelToTarget();
        this.redrawUI();
    }

    protected void addValidationFeature(EStructuralFeature feature) {
        if (!this.featuresToValidate.contains(feature)) {
            this.featuresToValidate.add(feature);
        }
    }

    protected EditorValidationStore getValidationStore() {
        return this.validationStore;
    }

    public abstract void bindControls(DataBindingContext var1, Object var2);

    public T getModel() {
        return (T)((IBaseObject)this.getObject());
    }

    protected PropertyEditorFactory.TextPropertyEditorFactory createLabeledTextEditorFactory(FormToolkit toolkit, Composite parent, String label) {
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)parent, (String)label);
        return PropertyEditorFactory.createText((EnhancedFormWidgetAdapter)this.widgetAdapter).defaults();
    }

    protected PropertyEditorFactory.TextPropertyEditorFactory createLabeledReadonlyTextEditorFactory(FormToolkit toolkit, Composite editorComposite, String label) {
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)editorComposite, (String)label);
        return PropertyEditorFactory.createText((EnhancedFormWidgetAdapter)this.widgetAdapter).defaults().style(8);
    }

    protected PropertyEditorFactory.FormTextPropertyEditorFactory createFormTextEditorFactory(FormToolkit toolkit, Composite editorComposite, String label) {
        return this.createFormTextEditorFactory(toolkit, editorComposite, label, null, 0);
    }

    protected PropertyEditorFactory.FormTextPropertyEditorFactory createFormTextEditorFactory(FormToolkit toolkit, Composite editorComposite, String label, DialogCreationStrategy dialogStrategy) {
        return this.createFormTextEditorFactory(toolkit, editorComposite, label, dialogStrategy, 0);
    }

    protected PropertyEditorFactory.FormTextPropertyEditorFactory createFormTextEditorFactory(FormToolkit toolkit, Composite editorComposite, String label, DialogCreationStrategy dialogStrategy, int indentLabelInPixels) {
        Label secLabel = DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)editorComposite, (String)label);
        GridDataFactory.swtDefaults().indent(indentLabelInPixels, 0).applyTo((Control)secLabel);
        PropertyEditorFactory.FormTextPropertyEditorFactory factory = PropertyEditorFactory.createFormText((FormToolkit)toolkit).defaults();
        if (dialogStrategy != null) {
            factory.addDialogCreationStrategy(dialogStrategy);
        }
        return factory;
    }

    protected PropertyEditorFactory.CheckPropertyEditorFactory createLabeledCheckBoxPropertyEditorFactory(FormToolkit toolkit, Composite editorComposite, String label) {
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)editorComposite, (String)label);
        return PropertyEditorFactory.createCheck((FormsWidgetAdapter)this.widgetAdapter).defaults();
    }

    protected PropertyEditorFactory.TablePropertyEditorFactory createTablePropertyEditorFactory(FormToolkit toolkit, Composite composite) {
        return PropertyEditorFactory.createTable((FormToolkit)toolkit).defaults();
    }

    protected PropertyEditorFactory.TreeDrivenTablePropertyEditorFactory createTreeDrivenTablePropertyEditorFactory(FormToolkit toolkit, Composite composite) {
        return PropertyEditorFactory.createTreeDrivenTablePropertyEditorFactory((FormToolkit)toolkit).defaults();
    }

    protected PropertyEditorFactory.ComboPropertyEditorFactory createLabeledStaticComboPropertyEditorFactory(Composite parent, List<? extends Object> items, ILabelProvider labelProvider, String label) {
        DTRTUIUtil.createSectionLabel((FormToolkit)this.toolkit, (Composite)parent, (String)label);
        return PropertyEditorFactory.createCombo((WidgetAdapter)this.widgetAdapter).defaults().items((IObservableList)new WritableList(items, Object.class)).labelProvider(labelProvider);
    }

    protected PropertyEditorFactory.ComboPropertyEditorFactory createLabeledDynamicComboPropertyEditorFactory(Composite parent, List<? extends Object> items, ILabelProvider labelProvider, String label) {
        DTRTUIUtil.createSectionLabel((FormToolkit)this.toolkit, (Composite)parent, (String)label);
        return PropertyEditorFactory.createCombo((WidgetAdapter)this.widgetAdapter).defaults().items((IObservableList)new WritableList(items, Object.class)).labelProvider(labelProvider);
    }

    protected Binding bind(DataBindingContext context, PropertyEditor propertyEditor, EStructuralFeature feature, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        return this.bind(context, propertyEditor, this.getModel(), feature, targetToModel, modelToTarget);
    }

    protected Binding bind(DataBindingContext context, PropertyEditor propertyEditor, T model, EStructuralFeature feature, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        return this.bind(context, propertyEditor, model, feature, targetToModel, modelToTarget, this.createTextControlValidationDecorator(context, propertyEditor), Collections.singletonList(feature));
    }

    protected IControlDecorationUpdateFactory createTextControlValidationDecorator(final DataBindingContext context, final PropertyEditor propertyEditor) {
        return new IControlDecorationUpdateFactory(){

            public ControlDecorationUpdater create(ValidationStatusProvider validationStatus) {
                Control bindingControl = propertyEditor.getBindingControl();
                if (bindingControl instanceof Text) {
                    return new TextControlDecorationUpdater(context, AbstractEditor.this.toolkit, (Text)bindingControl, validationStatus.getValidationStatus());
                }
                return new ControlDecorationUpdater();
            }
        };
    }

    protected Binding bind(DataBindingContext context, PropertyEditor propertyEditor, EStructuralFeature feature, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget, IControlDecorationUpdateFactory decorationUpdateFactory) {
        return this.bind(context, propertyEditor, this.getModel(), feature, targetToModel, modelToTarget, decorationUpdateFactory, Collections.singletonList(feature));
    }

    protected Binding bind(final DataBindingContext context, final PropertyEditor propertyEditor, T model, EStructuralFeature feature, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget, List<? extends EStructuralFeature> validationFeatures) {
        return this.bind(context, propertyEditor, model, feature, targetToModel, modelToTarget, new IControlDecorationUpdateFactory(){

            public ControlDecorationUpdater create(ValidationStatusProvider binding) {
                return new PopupControlDecorationUpdater(context, AbstractEditor.this.toolkit, propertyEditor.getControl(), binding.getValidationStatus());
            }
        }, validationFeatures);
    }

    protected Binding bind(DataBindingContext context, PropertyEditor propertyEditor, T model, EStructuralFeature feature, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget, IControlDecorationUpdateFactory decorationUpdateFactory, List<? extends EStructuralFeature> validationFeatures) {
        ErrorTolerantEObjectObservableValue modelObservableValue = new ErrorTolerantEObjectObservableValue((IOEPEExecutableContext)this.getContext(), (IBaseObject)model, feature);
        this.manageObservable((IObservable)modelObservableValue);
        IObservableValue targetObservable = propertyEditor.getObservableValue(16);
        Binding bindValue = context.bindValue(targetObservable, (IObservableValue)modelObservableValue, targetToModel, modelToTarget);
        modelObservableValue.setValidationStatusObservable(bindValue.getValidationStatus());
        this.addBindingToValidationProvider(modelObservableValue, targetObservable);
        this.addControlDecorator(validationFeatures, decorationUpdateFactory, targetObservable, bindValue);
        return bindValue;
    }

    protected void manageObservable(IObservable observableValue) {
        this.obsManager.addObservable(observableValue);
    }

    protected void addControlDecorator(List<? extends EStructuralFeature> features, IControlDecorationUpdateFactory decorationUpdateFactory, IObservableValue targetObservable) {
        this.addControlDecorator(features, decorationUpdateFactory, targetObservable, null);
    }

    protected void addControlDecorator(List<? extends EStructuralFeature> features, IControlDecorationUpdateFactory decorationUpdateFactory, final IObservableValue targetObservable, Binding bindValue) {
        ValidationStatusProvider validationStatus = null;
        validationStatus = features.size() == 1 ? this.validationStore.getValidationStatus(features.get(0)) : this.validationStore.getValidationStatus(features);
        validationStatus.getTargets().add((Object)targetObservable);
        if (bindValue != null) {
            WritableList list = new WritableList();
            list.add((Object)validationStatus);
            list.add((Object)bindValue);
            final AggregateValidationStatus aggregate = new AggregateValidationStatus((IObservableCollection)list, 2);
            this.multiValidator = new MultiValidator(){

                protected IStatus validate() {
                    return (IStatus)aggregate.getValue();
                }

                public IObservableList getTargets() {
                    WritableList list = new WritableList();
                    list.addAll((Collection)super.getTargets());
                    list.add((Object)targetObservable);
                    return list;
                }
            };
            this.multiValidator.getValidationStatus();
            validationStatus = this.multiValidator;
        }
        ControlDecorationSupport.create((ValidationStatusProvider)validationStatus, (int)16512, (Composite)this.editorComposite.getParent(), (ControlDecorationUpdater)decorationUpdateFactory.create(validationStatus));
    }

    protected void addBindingToValidationProvider(ErrorTolerantEObjectObservableValue modelObservableValue, IObservableValue targetObservable) {
        this.validationStore.getModels().add((Object)modelObservableValue);
        this.validationStore.getTargets().add((Object)targetObservable);
    }

    protected Binding bind(DataBindingContext context, PropertyEditor propertyEditor, EStructuralFeature feature) {
        return this.bind(context, propertyEditor, feature, new UpdateValueStrategy(), new UpdateValueStrategy());
    }

    protected void bindDataControlPropertyEditor(DataBindingContext context, PropertyEditor propertyEditor, EStructuralFeature feature) {
        this.bind(context, propertyEditor, feature, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new DataControlLabelConverter()));
    }

    protected PropertyEditorFactory.TextDialogPropertyEditorFactory createReadOnlyLabeledTextEditorWithDialogButtonFactory(FormToolkit toolkit, Composite editorComposite, String label, DialogCreationStrategy dialogCreationStrategy) {
        PropertyEditorFactory.TextDialogPropertyEditorFactory factory = PropertyEditorFactory.createTextDialog((EnhancedFormWidgetAdapter)this.widgetAdapter).defaults();
        factory.mustEditWithDialog(dialogCreationStrategy != null);
        if (dialogCreationStrategy != null) {
            factory.addCreationStrategy(dialogCreationStrategy);
        }
        return factory;
    }

    protected void bindEnablementToValidFeature(DataBindingContext context, PropertyEditor propEditor, EStructuralFeature feature) {
        ISWTObservableValue observeEnabled = SWTObservables.observeEnabled((Control)propEditor.getControl());
        context.bindValue((IObservableValue)observeEnabled, this.getValidationStore().getValidationStatus(feature).getValidationStatus(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter(StatusConverter.statusToEnableBoolean()));
    }

    protected void bindEnablementToValidFeature(DataBindingContext context, PropertyEditor propEditor, Collection<EStructuralFeature> features) {
        this.bindEnablementToValidFeature(context, propEditor.getControl(), features);
    }

    protected void bindEnablementToValidFeature(DataBindingContext context, Control control, Collection<EStructuralFeature> features) {
        ISWTObservableValue observeEnabled = SWTObservables.observeEnabled((Control)control);
        context.bindValue((IObservableValue)observeEnabled, this.getValidationStore().getValidationStatus(features).getValidationStatus(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter(StatusConverter.statusToEnableBoolean()));
    }

    protected List<Object> getBindRoots() {
        return new ArrayList<Object>(DTRTObjectUtil.getDataControls((IDataControlProvider)this.getContext()));
    }

    protected void maybeAddVariableIteratorToBindRoots(List<Object> bindRoots) {
        IVariablesIterator variablesIterator;
        IPageDefinition pageDefinition = this.getContext().getPageDefinition();
        if (pageDefinition instanceof PageDefinition && (variablesIterator = ((PageDefinition)pageDefinition).getVariablesIterator()) != null) {
            bindRoots.add(variablesIterator);
        }
    }
}

