/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ValidationPreferencesHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;

public final class StructureObjectValidator
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final int STRUCTURE_OBJECT_ISSUE = 200;
    public static final int CUSTOMIZATION_ISSUE = 201;
    public static final int LOV_ISSUE = 202;
    public static final StructureObjectValidator INSTANCE = new StructureObjectValidator();
    private boolean reduceErrorsToWarnings;
    private ValidationPreferencesHelper preferenceStore;

    private StructureObjectValidator() {
        this.reset();
        this.getValidationPreferencesHelper().getValidationPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void reset() {
        this.reduceErrorsToWarnings = this.getValidationPreferencesHelper().isReduceErrorsToWarnings();
    }

    public IStatus validate(IDataControlObject dataControlObject) {
        return dataControlObject != null ? this.validate(dataControlObject.getStructureObject()) : Status.OK_STATUS;
    }

    public IStatus validate(IStructureObject structureObject) {
        if (structureObject != null) {
            IStatus status = this.basicValidate(structureObject);
            if (!status.isOK()) {
                return status;
            }
            MultiStatus multiStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.v110101", 0, NLS.bind((String)Messages.structureObjectBeingValidated, (Object)structureObject.getId()), null);
            this.validate(multiStatus, structureObject);
            if (!multiStatus.isOK()) {
                return multiStatus;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus basicValidate(IStructureObject structureObject) {
        if (structureObject.isDisposed()) {
            return this.createErrorStatus(200, Messages.structureObjectIsDisposed, new String[0]);
        }
        if (DTRTUtil.isEmpty((String)structureObject.getId())) {
            return this.createErrorStatus(200, Messages.structureObjectEmptyId, new String[0]);
        }
        return Status.OK_STATUS;
    }

    private void validate(MultiStatus multiStatus, IStructureObject structureObject) {
        assert (multiStatus != null);
        String id = structureObject.getId();
        assert (!DTRTUtil.isEmpty((String)id));
        this.validate(multiStatus, structureObject.getURI() != null, 200, Messages.structureObjectNullURI, id);
        this.validate(multiStatus, !DTRTUtil.isEmpty((String)DTRTUtil.getLabel((IDescribable)structureObject)), 200, Messages.structureObjectEmptyLabel, id);
        this.validate(multiStatus, !DTRTUtil.isEmpty((String)DTRTUtil.getLabel((IDescriptor)structureObject.getTypeDescriptor())), 200, Messages.structureObjectEmptyType, id);
        if (!structureObject.canCustomize()) {
            this.validate(multiStatus, !structureObject.isCustomized(), 200, Messages.structureObjectCannotBeCustomizedButIs, id);
        }
        if (structureObject instanceof IStructureChild) {
            IStructureChild structureChild = (IStructureChild)structureObject;
            this.validate(multiStatus, structureChild.getKind() != null, 200, Messages.structureChildNullKind, id);
            this.validate(multiStatus, DTRTObjectUtil.getStructure((IStructureObject)structureChild) != null, 200, Messages.structureChildNotInStructure, id);
        }
    }

    private void validate(MultiStatus multiStatus, boolean condition, int code, String message, String ... nlsBindings) {
        if (!condition) {
            multiStatus.add(this.createErrorStatus(code, message, nlsBindings));
        }
    }

    private IStatus createErrorStatus(int code, String message, String ... nlsBindings) {
        return new Status(this.reduceErrorsToWarnings ? 2 : 4, "oracle.eclipse.tools.adf.dtrt.v110101", code, NLS.bind((String)message, (Object[])nlsBindings), null);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.reset();
    }

    private ValidationPreferencesHelper getValidationPreferencesHelper() {
        if (this.preferenceStore == null) {
            this.preferenceStore = ValidationPreferencesHelper.createValidationPreferencesHelper();
        }
        return this.preferenceStore;
    }

    private static class Messages
    extends NLS {
        public static String structureObjectBeingValidated;
        public static String structureObjectIsDisposed;
        public static String structureObjectEmptyId;
        public static String structureObjectNullURI;
        public static String structureObjectEmptyLabel;
        public static String structureObjectEmptyType;
        public static String structureObjectCannotBeCustomizedButIs;
        public static String structureChildNullKind;
        public static String structureChildNotInStructure;

        static {
            NLS.initializeMessages((String)StructureObjectValidator.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

