/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.VariableDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;

public final class NamedDefinitionKey {
    private int hashCode = -1;
    private final NamedDefinition namedDefinition;
    private int numberOfNamedDefinitionParents = -1;

    public static String computeNonEncodedURISegment(NamedDefinition namedDefinition) {
        if (namedDefinition != null) {
            String key = "NamedDefinitionKey.getNonEncodedURISegment(NamedDefinition)";
            Object value = namedDefinition.getProperty(key);
            if (value instanceof String) {
                return (String)value;
            }
            StringBuilder sb = new StringBuilder("nd");
            sb.append(namedDefinition.getDefinitionType());
            sb.append(namedDefinition.getName());
            sb.append(NamedDefinitionKey.getTypeSpecificIdentifier(namedDefinition));
            String segment = sb.toString();
            namedDefinition.getProperties().put(key, segment);
            return segment;
        }
        return null;
    }

    private static int shallowHashCode(NamedDefinition namedDefinition) {
        if (namedDefinition != null) {
            int result = 1;
            result = 31 * result + namedDefinition.getDefinitionType();
            result = 31 * result + (namedDefinition.getName() == null ? 0 : namedDefinition.getName().hashCode());
            String signature = NamedDefinitionKey.getTypeSpecificIdentifier(namedDefinition);
            result = 31 * result + (signature == null ? 0 : signature.hashCode());
            return result;
        }
        return 0;
    }

    static boolean shallowEquals(NamedDefinition namedDefinition1, NamedDefinition namedDefinition2) {
        if (namedDefinition1 != namedDefinition2) {
            if (namedDefinition1 == null || namedDefinition2 == null) {
                return false;
            }
            if (namedDefinition1.getDefinitionType() != namedDefinition2.getDefinitionType()) {
                return false;
            }
            if (!DTRTUtil.equals((Object)namedDefinition1.getName(), (Object)namedDefinition2.getName())) {
                return false;
            }
            if (!DTRTUtil.equals((Object)NamedDefinitionKey.getTypeSpecificIdentifier(namedDefinition1), (Object)NamedDefinitionKey.getTypeSpecificIdentifier(namedDefinition2))) {
                return false;
            }
        }
        return true;
    }

    private static String getTypeSpecificIdentifier(NamedDefinition namedDefinition) {
        return namedDefinition instanceof OperationDefinition ? DTRTvUtil.getSignature((OperationDefinition)namedDefinition) : (namedDefinition instanceof VariableDefinition ? ((VariableDefinition)namedDefinition).getJavaTypeString() : "none");
    }

    public NamedDefinitionKey(NamedDefinition namedDefinition) {
        if (namedDefinition == null) {
            throw new IllegalArgumentException("namedDefinition cannot be null");
        }
        this.namedDefinition = namedDefinition;
    }

    public int getNumberOfNamedDefinitionParents() {
        return this.numberOfNamedDefinitionParents == -1 ? (this.numberOfNamedDefinitionParents = this.countNamedDefinitionParents(this.namedDefinition)) : this.numberOfNamedDefinitionParents;
    }

    private int countNamedDefinitionParents(NamedDefinition namedDefinition) {
        int counter = 0;
        Definition parent = namedDefinition.getDefinitionParent();
        while (parent instanceof NamedDefinition) {
            ++counter;
            parent = ((NamedDefinition)parent).getDefinitionParent();
        }
        return counter;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            String key = "NamedDefinitionKey.hashCode()";
            Object value = this.namedDefinition.getProperty(key);
            if (value instanceof Integer) {
                this.hashCode = (Integer)value;
            } else {
                int result = 1;
                result = 37 * result + this.getNumberOfNamedDefinitionParents();
                int i = this.getNumberOfNamedDefinitionParents();
                while (i >= 0) {
                    NamedDefinition nd = this.namedDefinition;
                    result = 37 * result + NamedDefinitionKey.shallowHashCode(nd);
                    nd = (NamedDefinition)nd.getDefinitionParent();
                    --i;
                }
                this.namedDefinition.getProperties().put(key, result);
                this.hashCode = result;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedDefinitionKey namedDefinitionKey = (NamedDefinitionKey)obj;
        if (this.namedDefinition != namedDefinitionKey.namedDefinition) {
            if (this.getNumberOfNamedDefinitionParents() != namedDefinitionKey.getNumberOfNamedDefinitionParents()) {
                return false;
            }
            if (this.hashCode != -1 && namedDefinitionKey.hashCode != 1 && this.hashCode != namedDefinitionKey.hashCode) {
                return false;
            }
            NamedDefinition nd1 = this.namedDefinition;
            NamedDefinition nd2 = namedDefinitionKey.namedDefinition;
            int i = this.getNumberOfNamedDefinitionParents();
            while (i >= 0) {
                if (!NamedDefinitionKey.shallowEquals(nd1, nd2)) {
                    return false;
                }
                nd1 = (NamedDefinition)nd1.getDefinitionParent();
                nd2 = (NamedDefinition)nd2.getDefinitionParent();
                --i;
            }
        }
        return true;
    }
}

