/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;

abstract class BaseStructureObject
extends BaseDescribable
implements IStructureObject {
    private static final String URI_SCHEME = "structure";
    private static final String URI_PREFIX = "structure://";
    private static final int DISPOSED_HASH_CODE = -130;
    private int hashCode = -1;
    private java.net.URI uri;

    BaseStructureObject() {
    }

    public static boolean isStructureObjectURI(java.net.URI uri) {
        return uri != null && URI_SCHEME.equals(uri.getScheme()) && !uri.isOpaque() && uri.getAuthority() != null;
    }

    public void dispose() {
        this.hashCode = -130;
        this.uri = null;
        super.dispose();
    }

    public final boolean isDisposed() {
        return this.hashCode == -130;
    }

    public StructureProvider getStructureProvider() {
        return StructureUtil.getStructureProvider(this);
    }

    public final boolean canCustomize() {
        return false;
    }

    public final boolean isCustomized() {
        return false;
    }

    public final boolean isCustomizationFile(IFile file) {
        return false;
    }

    public final java.net.URI getURI() {
        if (this.uri == null && !this.isDisposed()) {
            java.net.URI uri;
            String uriSegment = this.computeNonEncodedURISegment();
            if (uriSegment == null) {
                throw new IllegalStateException("The uri segment cannot be null for " + (Object)((Object)this));
            }
            uriSegment = URI.encodeSegment((String)uriSegment, (boolean)false);
            if (this.getParent() == null) {
                uri = java.net.URI.create(URI_PREFIX + uriSegment);
            } else {
                java.net.URI parentURI = this.getParent().getURI();
                if (parentURI == null) {
                    throw new IllegalStateException("The uri cannot be null for " + this.getParent());
                }
                uri = java.net.URI.create(String.valueOf(parentURI.toString()) + '/' + uriSegment);
            }
            this.uri = uri;
        }
        return this.uri;
    }

    protected abstract String computeNonEncodedURISegment();

    protected final BaseDescriptor createDescriptor() {
        return StructureUtil.getDescriptor(this.computeLabel(), this.computeToolTipText(), this.computeImageData());
    }

    protected abstract String computeLabel();

    protected abstract String computeToolTipText();

    protected abstract ImageManager.IImageData computeImageData();

    public final boolean isDeleted() {
        return this.isDisposed();
    }

    public final int hashCode() {
        if (this.isDisposed()) {
            return super.objectHashCode();
        }
        if (this.hashCode == -1) {
            int result = 1;
            result = 31 * result + (this.getURI() == null ? 0 : this.getURI().hashCode());
            this.hashCode = result == -130 ? result + 200 : result;
        }
        return this.hashCode;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.isDisposed() || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BaseStructureObject other = (BaseStructureObject)((Object)obj);
        return DTRTUtil.equals((Object)this.getURI(), (Object)other.getURI());
    }

    public final int compareTo(IObject object) {
        if (object == null) {
            return -1;
        }
        if (object == this) {
            return 0;
        }
        if (object instanceof BaseStructureObject) {
            int objectCategory = ((BaseStructureObject)object).getCompareCategory();
            if (this.getCompareCategory() != objectCategory) {
                return objectCategory - this.getCompareCategory();
            }
        }
        return this.compareToSameCategoryObject(object);
    }

    protected int getCompareCategory() {
        return 0;
    }

    protected int compareToSameCategoryObject(IObject object) {
        int compare = DTRTUtil.compare((Object)DTRTUtil.getLabel((IDescribable)this), (Object)DTRTUtil.getLabel((IDescribable)object));
        if (compare == 0) {
            IStructureObject parent1 = this.getParent();
            IObject parent2 = object.getParent();
            compare = parent1 instanceof BaseStructureObject ? ((BaseStructureObject)parent1).compareTo(parent2) : (parent1 == null ? (parent2 == null ? 0 : -1) : (parent2 == null ? 1 : DTRTUtil.compare((Object)DTRTUtil.getLabel((IDescribable)parent1), (Object)DTRTUtil.getLabel((IDescribable)parent2))));
        }
        return compare;
    }

    public Object getAdapter(Class adapter) {
        if (!this.isDisposed() && adapter == ImageManager.IImageData.class) {
            return this.getDescriptor().getImageData();
        }
        return null;
    }
}

