/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import oracle.adfdt.model.log.LogUtil;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.BeanAccessorAttribute;
import oracle.adfdt.model.objects.BeanMethodParameter;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.adfdt.model.objects.ConstructorMethod;
import oracle.adfdt.model.objects.GenericAttr;
import oracle.adfdt.model.objects.Method;
import oracle.adfdt.transaction.SimpleTransactionManager;
import oracle.adfdt.transaction.Task;
import oracle.adfdt.transaction.TransactionManager;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.OperationReturnDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.BeanManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.Project;
import org.w3c.dom.Element;

final class StructureDefinitionBuilder {
    private StructureDefinition _definition;
    private BeanStructure _bean;
    private Project _project;
    private String _className;
    private Set _attributeNames;
    private HashMap _processedClasses;
    private ArrayList _creatableClasses;

    public StructureDefinitionBuilder(StructureDefinition definition, Project project) {
        this._processedClasses = project._processedClasses;
        this._creatableClasses = project._creatableClasses;
        this._definition = definition;
        this._project = project;
        if (this._definition != null) {
            this._className = this._definition.getFullName();
        }
    }

    public void addCompletedClass(String sClass) {
        this._processedClasses.put(sClass, sClass);
    }

    protected void addCreatableClass(String aclass) {
        this._creatableClasses.add(aclass);
    }

    public ArrayList getCreatableClasses() {
        return this._creatableClasses;
    }

    public boolean hasClassBeenCompleted(String sClass) {
        return this._processedClasses.get(sClass) != null;
    }

    public void clearCompletedClasses() {
        this._processedClasses.clear();
        this._creatableClasses.clear();
    }

    public String getClassName() {
        return this._className;
    }

    protected void removeUnusedAttributes() {
        ArrayList attributes = this._bean.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            GenericAttr attr = (GenericAttr)attributes.get(i);
            if (this._definition.getAttributeDefinitions().find(attr.getName()) == null) {
                attr.removeFromParent();
            }
            ++i;
        }
    }

    protected void removeUnusedAccessors() {
        ArrayList attributes = this._bean.getAccesors();
        int i = 0;
        while (i < attributes.size()) {
            BeanAccessorAttribute attr = (BeanAccessorAttribute)attributes.get(i);
            if (this._definition.getAccessorDefinitions().find(attr.getId()) == null) {
                attr.removeFromParent();
            }
            ++i;
        }
    }

    protected ArrayList getConstructors() {
        ArrayList<OperationDefinition> list = new ArrayList<OperationDefinition>();
        DefinitionContainer operations = this._definition.getConstructorOperationDefinitions();
        for (OperationDefinition operation : operations) {
            list.add(operation);
        }
        return list;
    }

    protected ArrayList getOperationsWithName(String sName) {
        ArrayList<OperationDefinition> list = new ArrayList<OperationDefinition>();
        DefinitionContainer operations = this._definition.getOperationDefinitions();
        for (OperationDefinition operation : operations) {
            if (!operation.getName().equals(sName)) continue;
            list.add(operation);
        }
        return list;
    }

    protected void removeUnusedMethods() {
        this._bean.removeBuiltInOperations();
        ArrayList methods = this._bean.getMethodAccessors();
        int i = 0;
        while (i < methods.size()) {
            Method method = (Method)methods.get(i);
            OperationDefinition operation = (OperationDefinition)this._definition.getOperationDefinitions().find(method.getId());
            if (operation == null) {
                method.removeFromParent();
            } else {
                ArrayList operations = this.getOperationsWithName(method.getId());
                boolean bFoundMatch = false;
                int nOperation = 0;
                while (nOperation < operations.size()) {
                    if (method.representsOperation((OperationDefinition)operations.get(nOperation))) {
                        bFoundMatch = true;
                        break;
                    }
                    ++nOperation;
                }
                if (!bFoundMatch) {
                    method.removeFromParent();
                }
            }
            ++i;
        }
    }

    protected void removeUnusedConstuctors() {
        ArrayList methods = this._bean.getConstructors();
        int i = 0;
        while (i < methods.size()) {
            ConstructorMethod method = (ConstructorMethod)methods.get(i);
            OperationDefinition operation = (OperationDefinition)this._definition.getConstructorOperationDefinitions().find(method.getId());
            if (operation == null) {
                method.removeFromParent();
            } else {
                ArrayList operations = this.getConstructors();
                boolean bFoundMatch = false;
                int nOperation = 0;
                while (nOperation < operations.size()) {
                    if (method.representsOperation((OperationDefinition)operations.get(nOperation))) {
                        bFoundMatch = true;
                        break;
                    }
                    ++nOperation;
                }
                if (!bFoundMatch) {
                    method.removeFromParent();
                }
            }
            ++i;
        }
    }

    protected void buildAtributes() {
        for (AttributeDefinition attrDef : this._definition.getAttributeDefinitions()) {
            GenericAttr attribute = this._bean.findAttribute(attrDef.getName());
            if (attribute == null) {
                attribute = this._bean.createAttribute();
                this._bean.addAttribute(attribute);
                attribute.setName(attrDef.getName());
                attribute.setFieldName(attrDef.getName());
                attribute.setPrimaryKey(attrDef.isKey());
            }
            if (attrDef.isReadOnly()) {
                attribute.setUpdateableFlag((byte)0);
            } else {
                attribute.setUpdateableFlag((byte)2);
            }
            Object val = attrDef.getProperty("IsNotNull");
            if (val != null && val instanceof Boolean) {
                attribute.setNotNull(((Boolean)val).booleanValue());
                attrDef.getProperties().remove("IsNotNull");
            }
            StructureDefinitionBuilder.transferAttributeProperties((NamedDefinition)attrDef, attribute);
            attribute.setType(attrDef.getJavaTypeString());
            attribute.setFieldType(attrDef.getSourceTypeString());
            StructureDefinitionBuilder.transferAttributeProperties((NamedDefinition)attrDef, attribute);
        }
    }

    private String generateXmlIfNecessary(StructureDefinition structure) {
        try {
            if (structure != null) {
                StructureDefinitionBuilder builder = new StructureDefinitionBuilder(structure, this._project);
                builder.build();
                return builder.getClassName();
            }
        }
        catch (Exception e) {
            LogUtil.getLogger().info((Throwable)e);
        }
        return null;
    }

    protected void buildBuiltInOperations() {
        for (OperationDefinition operationDef : this._definition.getOperationDefinitions()) {
            if (operationDef.getOperationId() == 999) continue;
            this._bean.addBuiltinOperation(operationDef);
        }
    }

    protected void buildConstructors() {
        String sHideFromCreators;
        Iterator iter = this._definition.getConstructorOperationDefinitions().iterator();
        if (iter.hasNext() && ((sHideFromCreators = (String)this._definition.getProperty("__HIDE_FROM_CREATORS_LIST__")) == null || sHideFromCreators.equals(""))) {
            this.addCreatableClass(this.getClassName());
        }
        while (iter.hasNext()) {
            OperationDefinition operationDef = (OperationDefinition)iter.next();
            if (operationDef.getOperationId() != 999) continue;
            ConstructorMethod method = this._bean.createConstructorMethod();
            method.initializeUsingDefinition(operationDef);
            for (ParameterDefinition paramDef : operationDef.getOperationParameters()) {
                if (!paramDef.isAccessor()) continue;
                this.generateXmlIfNecessary(((AccessorDefinition)paramDef).getStructure());
            }
            ConstructorMethod searchMethod = this._bean.findConstructorMethod(method);
            if (searchMethod == null) {
                this._bean.addConstructorMethod(method);
                continue;
            }
            Iterator paramIter = operationDef.getOperationParameters().iterator();
            int nParamIndex = 0;
            ArrayList params = searchMethod.getParameters();
            while (paramIter.hasNext()) {
                ParameterDefinition paramDef = (ParameterDefinition)paramIter.next();
                BeanMethodParameter beanParam = (BeanMethodParameter)params.get(nParamIndex++);
                try {
                    beanParam.setId(paramDef.getName());
                }
                catch (PropertyVetoException e) {
                    LogUtil.getLogger().fine((Throwable)e);
                }
            }
        }
    }

    protected void buildMethods() {
        for (OperationDefinition operationDef : this._definition.getOperationDefinitions()) {
            StructureDefinition strDef;
            AccessorDefinition returnAccessorDef;
            OperationReturnDefinition returnDef;
            AccessorDefinition returnType;
            if (operationDef.getOperationId() != 999) continue;
            Method method = this._bean.createMethod();
            method.initializeUsingDefinition(operationDef);
            if (operationDef.getOperationReturnType() != null && operationDef.getOperationReturnType().isAccessor() && !(returnType = (AccessorDefinition)operationDef.getOperationReturnType()).isScalarCollection() && !returnType.isScalarCollection()) {
                String sFullName = this.generateXmlIfNecessary(returnType.getStructure());
                method.setBeanClass(sFullName, false);
            }
            if ((returnDef = operationDef.getOperationReturnType()) != null) {
                method.setReturnNodeName(returnDef.getName());
                method.setReturnType(returnDef.getJavaTypeString());
            }
            if (returnDef != null && returnDef.isAccessor() && (returnAccessorDef = (AccessorDefinition)returnDef).isCollection() && (strDef = returnAccessorDef.getCollectionStructure()) != null) {
                if (!returnAccessorDef.isScalarCollection()) {
                    this.generateXmlIfNecessary(strDef);
                }
                if (returnAccessorDef.getCollectionStructure() != null) {
                    this.generateXmlIfNecessary(returnAccessorDef.getCollectionStructure());
                }
                method.setCollectionBeanClass(strDef.getFullName(), false);
            }
            for (ParameterDefinition paramDef : operationDef.getOperationParameters()) {
                if (!paramDef.isAccessor()) continue;
                this.generateXmlIfNecessary(((AccessorDefinition)paramDef).getStructure());
            }
            Method searchMethod = this._bean.findMethodAccessor(method);
            if (searchMethod == null) {
                this._bean.addMethodAccessor(method);
                continue;
            }
            if (method.getBeanClass() != null) {
                searchMethod.setBeanClass(method.getBeanClass(), false);
            }
            if (method.getCollectionBeanClass() != null) {
                searchMethod.setCollectionBeanClass(method.getCollectionBeanClass());
            }
            searchMethod.setReturnType(method.getReturnType());
            Iterator paramIter = operationDef.getOperationParameters().iterator();
            int nParamIndex = 0;
            ArrayList params = searchMethod.getParameters();
            while (paramIter.hasNext()) {
                ParameterDefinition paramDef = (ParameterDefinition)paramIter.next();
                BeanMethodParameter beanParam = (BeanMethodParameter)params.get(nParamIndex++);
                try {
                    beanParam.setId(paramDef.getName());
                }
                catch (PropertyVetoException e) {
                    LogUtil.getLogger().fine((Throwable)e);
                }
            }
        }
    }

    protected void buildAccessors() throws Exception {
        Iterator iter = this._definition.getAccessorDefinitions().iterator();
        Set attributeNames = this.getAttributeNames();
        attributeNames.clear();
        int accCount = 0;
        while (iter.hasNext()) {
            BeanAccessorAttribute searchAttribute;
            BeanStructure attributeBean;
            AccessorDefinition attrDef = (AccessorDefinition)iter.next();
            BeanAccessorAttribute attribute = null;
            attribute = this._bean.createAccessor();
            try {
                String accName = attrDef.getName();
                if (this._definition.getName().equals(accName)) {
                    attribute.setId(String.valueOf(this._definition.getName()) + accCount);
                    attribute.setAccessorSourceName(accName);
                } else {
                    attribute.setId(accName);
                    attribute.setAccessorName(attrDef.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            attribute.seIsCollection(attrDef.isCollection());
            attribute.setFieldType(attrDef.getJavaTypeString());
            StructureDefinitionBuilder.transferAccessorProperties((NamedDefinition)attrDef, attribute);
            if (attrDef.getProperty("RemoveMethod") != null) {
                attribute.setRemoveMethod((String)attrDef.getProperty("RemoveMethod"));
            }
            if (attrDef.getProperty("AddMethod") != null) {
                attribute.setAddMethod((String)attrDef.getProperty("AddMethod"));
            }
            if (attrDef.isScalarCollection()) {
                AttributeDefinition def = (AttributeDefinition)attrDef.getStructure().getAttributeDefinitions().iterator().next();
                GenericAttr attr = null;
                attr = attribute.getElementAttribute();
                if (attr == null) {
                    attr = attribute.createCollectionElementAttribute();
                    String elementName = attr.getName();
                    attr.setName(elementName);
                    attribute.appendChild((BaseElementObject)attr);
                }
                attr.setType(def.getJavaTypeString());
                attr.setFieldType(def.getJavaTypeString());
                if (attrDef.getCollectionStructure() != null) {
                    this.generateXmlIfNecessary(attrDef.getCollectionStructure());
                }
            } else {
                GenericAttr attr = attribute.getElementAttribute();
                if (attr != null) {
                    attr.removeFromParent();
                }
                String sClass = this.generateXmlIfNecessary(attrDef.getStructure());
                attribute.setBeanClass(sClass);
                if (attrDef.getCollectionStructure() != null) {
                    this.generateXmlIfNecessary(attrDef.getCollectionStructure());
                }
            }
            if (attrDef.getCollectionStructure() != null) {
                attribute.setCollectionBeanClass(attrDef.getCollectionStructure().getFullName());
            }
            if ((attributeBean = attribute.getBeanDefinition()) != null) {
                attributeBean.setBeanClass(attribute.getBeanClass());
            }
            if ((searchAttribute = this._bean.findAccessor(attribute.getId())) == null) {
                this._bean.addAccessor(attribute);
            } else {
                if (attribute.getBeanClass() != null) {
                    searchAttribute.setBeanClass(attribute.getBeanClass());
                }
                if (attribute.getCollectionBeanClass() != null) {
                    searchAttribute.setCollectionBeanClass(attribute.getCollectionBeanClass());
                }
                searchAttribute.seIsCollection(attribute.isCollection());
            }
            ++accCount;
        }
    }

    protected void removeUnusedElements() {
        this.removeUnusedAttributes();
        this.removeUnusedAccessors();
        this.removeUnusedMethods();
        this.removeUnusedConstuctors();
    }

    public void build() throws Exception {
        if (this._className == null || this._definition == null || this.hasClassBeenCompleted(this._className)) {
            return;
        }
        this.addCompletedClass(this._className);
        this._bean = BeanManager.findOrCreateBean(this._project, this._className);
        this._bean.getTransactionManager();
        final Element originalElement = this._bean.getElement();
        final Element cloneelement = (Element)this._bean.getElement().cloneNode(true);
        this._bean.initializeFromElement((TransactionManager)new SimpleTransactionManager(), cloneelement);
        Task task = new Task(){

            public void runHandlingExceptions() throws Exception {
                StructureDefinitionBuilder.this._bean.setId(StructureDefinitionBuilder.this._definition.getName());
                StructureDefinitionBuilder.this._bean.setBeanClass(StructureDefinitionBuilder.this._className);
                StructureDefinitionBuilder.this._bean.setIsJavaBased(false);
                String sBeanBased = (String)StructureDefinitionBuilder.this._definition.getProperty("IsBeanBased");
                if (sBeanBased != null) {
                    StructureDefinitionBuilder.this._bean.setIsJavaBased(sBeanBased.equals("true"));
                }
                StructureDefinitionBuilder.this.removeUnusedElements();
                StructureDefinitionBuilder.this.buildAtributes();
                StructureDefinitionBuilder.this.buildAccessors();
                StructureDefinitionBuilder.this.buildMethods();
                StructureDefinitionBuilder.this.buildBuiltInOperations();
                StructureDefinitionBuilder.this.buildConstructors();
            }
        };
        this._bean.getTransactionManager().runTaskUnderTransaction("initbean", task);
        Task task2 = new Task(){

            public void runHandlingExceptions() throws Exception {
                StructureDefinitionBuilder.this._bean.getDocument().replaceChild(cloneelement, originalElement);
            }
        };
        this._bean.getTransactionManager().runTaskUnderTransaction("replacebean", task2);
    }

    private Set getAttributeNames() {
        if (this._attributeNames == null) {
            this._attributeNames = new HashSet();
        }
        return this._attributeNames;
    }

    public static void transferAttributeProperties(NamedDefinition definition, GenericAttr destination) {
        Hashtable properties = definition.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (String sName : properties.keySet()) {
            Object obj;
            if (sName.startsWith("_") || (obj = properties.get(sName)) == null) continue;
            destination.addUIHint(sName, obj.toString());
        }
    }

    public static void transferAccessorProperties(NamedDefinition definition, BeanAccessorAttribute destination) {
        Hashtable properties = definition.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (String sName : properties.keySet()) {
            Object obj;
            if (sName.startsWith("_") || (obj = properties.get(sName)) == null) continue;
            destination.addUIHint(sName, obj.toString());
        }
    }
}

