/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.adfdt.model.log.LogUtil;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.Project;

final class CreatableTypesHelper {
    private StructureDefinition _definition;
    private String _className;
    private Project _project;
    private HashMap _processedClasses;
    private ArrayList _creatableClasses;

    public CreatableTypesHelper(StructureDefinition definition, Project project) {
        this._project = project;
        this._processedClasses = project._processedClasses;
        this._creatableClasses = project._creatableClasses;
        this._definition = definition;
        if (this._definition != null) {
            this._className = this._definition.getFullName();
        }
    }

    public ArrayList getCreatableClasses() {
        return this._creatableClasses;
    }

    private void addCompletedClass(String sClass) {
        this._processedClasses.put(sClass, sClass);
    }

    private void addCreatableClass(String aclass) {
        this._creatableClasses.add(aclass);
    }

    public boolean hasClassBeenCompleted(String sClass) {
        return this._processedClasses.get(sClass) != null;
    }

    public void clearCompletedClasses() {
        this._processedClasses.clear();
        this._creatableClasses.clear();
    }

    public String getClassName() {
        return this._className;
    }

    public void find() throws Exception {
        if (this._className == null || this._definition == null || this.hasClassBeenCompleted(this._className)) {
            return;
        }
        this.addCompletedClass(this._className);
        this.findInAtributes();
        this.findInAccessors();
        this.findInMethods();
        this.findInBuiltInOperations();
        this.findInConstructors();
    }

    private void findInAtributes() {
    }

    private void findInAccessors() throws Exception {
        for (AccessorDefinition accDef : this._definition.getAccessorDefinitions()) {
            if (accDef.getStructure() == null) continue;
            this.findInStructureDefinition(accDef.getStructure());
        }
    }

    private void findInMethods() {
        for (OperationDefinition operationDef : this._definition.getOperationDefinitions()) {
            AccessorDefinition returnType;
            if (operationDef.getOperationId() != 999) continue;
            if (operationDef.getOperationReturnType() != null && operationDef.getOperationReturnType().isAccessor() && !(returnType = (AccessorDefinition)operationDef.getOperationReturnType()).isScalarCollection()) {
                this.findInStructureDefinition(returnType.getStructure());
            }
            for (ParameterDefinition paramDef : operationDef.getOperationParameters()) {
                if (!paramDef.isAccessor()) continue;
                this.findInStructureDefinition(((AccessorDefinition)paramDef).getStructure());
            }
        }
    }

    private void findInBuiltInOperations() {
    }

    private void findInConstructors() {
        String sHideFromCreators;
        Iterator iter = this._definition.getConstructorOperationDefinitions().iterator();
        if (iter.hasNext() && ((sHideFromCreators = (String)this._definition.getProperty("__HIDE_FROM_CREATORS_LIST__")) == null || sHideFromCreators.equals(""))) {
            this.addCreatableClass(this.getClassName());
        }
        while (iter.hasNext()) {
            OperationDefinition operationDef = (OperationDefinition)iter.next();
            if (operationDef.getOperationId() != 999) continue;
            for (ParameterDefinition paramDef : operationDef.getOperationParameters()) {
                if (!paramDef.isAccessor()) continue;
                this.findInStructureDefinition(((AccessorDefinition)paramDef).getStructure());
            }
        }
    }

    public String findInStructureDefinition(StructureDefinition structDef) {
        try {
            if (structDef != null) {
                CreatableTypesHelper creatableTypes = new CreatableTypesHelper(structDef, this._project);
                creatableTypes.find();
                return creatableTypes.getClassName();
            }
        }
        catch (Exception e) {
            LogUtil.getLogger().info((Throwable)e);
        }
        return null;
    }

    public List findCreatableClasses(StructureDefinition definition) {
        try {
            CreatableTypesHelper creatableTypes = new CreatableTypesHelper(definition, this._project);
            this.clearCompletedClasses();
            creatableTypes.find();
            return creatableTypes.getCreatableClasses();
        }
        catch (Exception ex) {
            LogUtil.getLogger().throwing("oracle.adfdtinternal.model.ide.adapter.bean.CreatableTypesHelper", "findCreatableClasses", (Throwable)ex);
            return null;
        }
    }
}

