/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaClass;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;

final class ClassEngine
implements JavaClass {
    private Project project;
    private String typeName;

    public ClassEngine(Project project, String className) {
        this.project = project;
        this.typeName = className;
    }

    public String getClassName() {
        return this.typeName;
    }

    public JavaClass getJavaClass() {
        return this;
    }

    public JavaManager getJavaManager() {
        return this.project;
    }

    public MethodInfo[] getConstructorMethods(Set<?> ignoreClasses, boolean useCache) {
        try {
            return this.project.getConstructorInfos(this.typeName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MethodInfo[] getMethods(boolean publicOnly, Set<?> ignoreClasses, boolean useCache) {
        MethodInfo[] methodInfos;
        try {
            methodInfos = this.project.getMethodInfos(this.typeName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ignoreClasses == null) {
            ignoreClasses = Collections.emptySet();
        }
        if (methodInfos.length > 0 && (publicOnly || !ignoreClasses.isEmpty())) {
            ArrayList<MethodInfo> list = new ArrayList<MethodInfo>(methodInfos.length);
            MethodInfo[] methodInfoArray = methodInfos;
            int n = methodInfos.length;
            int n2 = 0;
            while (n2 < n) {
                MethodInfo methodInfo = methodInfoArray[n2];
                if (!(publicOnly && !Modifier.isPublic(methodInfo.modifiers) || ignoreClasses.contains(methodInfo.declaringClassName))) {
                    list.add(methodInfo);
                }
                ++n2;
            }
            methodInfos = list.toArray(new MethodInfo[list.size()]);
        }
        return methodInfos;
    }

    @Override
    public boolean isInterface() {
        return this.project.isInterface(this.typeName);
    }

    @Override
    public Object getTypeParameter(String name) {
        return this.project.getTypeParameter(this.typeName, name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClassEngine other = (ClassEngine)obj;
        return this.project == other.project && DTRTUtil.equals((Object)this.typeName, (Object)other.typeName);
    }
}

