/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.adapter.DTContext;
import oracle.adf.model.adapter.bean.annotation.AccessModeType;
import oracle.adf.model.adapter.bean.annotation.Properties;
import oracle.adf.model.adapter.bean.annotation.Property;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adf.model.adapter.dataformat.MethodDef;
import oracle.adf.model.adapter.dataformat.MethodReturnDef;
import oracle.adf.model.adapter.dataformat.ParamDef;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.generic.BeanUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adfinternal.model.adapter.bean.BeanDCUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanMethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.ClassEngine;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.EngineUtils;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.FieldInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaClass;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodEngine;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;
import oracle.javatools.util.ModelUtil;

abstract class AbstractBeanDataControlProvider {
    private boolean _generateCollectionOperations = true;
    private Set _ignoredClasses = new HashSet();
    private static final String ACCESSOR_ADD_METHOD = "AddMethod";
    private static final String ACCESSOR_REMOVE_METHOD = "RemoveMethod";
    private static final String RETURN_VALUE = "returnValue";
    private ADFLogger mLogger = DTContext.getInstance().getLogger();

    AbstractBeanDataControlProvider() {
    }

    public void setGenerateCollectionOperations(boolean bSet) {
        this._generateCollectionOperations = bSet;
    }

    public boolean generateCollectionOperations() {
        return this._generateCollectionOperations;
    }

    protected boolean ignoredMethod(MethodInfo mi) {
        return false;
    }

    protected void setIgnoredClass(String className) {
        if (!this._ignoredClasses.contains(className)) {
            this._ignoredClasses.add(className);
        }
    }

    protected Set getIgnoredClasses() {
        return this._ignoredClasses;
    }

    protected boolean createStructure(boolean subStructure) {
        return true;
    }

    protected void addUpdateableCollectionOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildUpdateableCollectionOperations());
        }
    }

    protected void addReadOnlyCollectionOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildReadOnlyCollectionOperations());
        }
    }

    protected void addUpdateableCollectionOperations(MethodReturnDef returnDef) {
        if (this.generateCollectionOperations()) {
            returnDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildUpdateableCollectionOperations());
        }
    }

    protected void addReadOnlyCollectionOperations(MethodReturnDef returnDef) {
        if (this.generateCollectionOperations()) {
            returnDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildReadOnlyCollectionOperations());
        }
    }

    protected void addSingleValueUpdateableOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildSingleValueUpdateableOperations());
        }
    }

    protected void addSingleValueReadOnlyOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildSingleValueReadOnlyOperations());
        }
    }

    protected void addSingleValueReadOnlyOperations(MethodReturnDef returnDef) {
        if (this.generateCollectionOperations()) {
            returnDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildSingleValueReadOnlyOperations());
        }
    }

    protected void addTransactionalOperations(StructureDef rootDCDef) {
        if (this.generateCollectionOperations()) {
            BeanDCUtils.addTransactionalOperations((StructureDef)rootDCDef);
        }
    }

    protected StructureDef createStructureDef(Project project, String className) {
        return new StructureDef(className);
    }

    public StructureDefinition buildStructure(Project project, String className) {
        return this.buildStructure(project, new ClassEngine(project, className));
    }

    public StructureDefinition buildStructure(Project project, ClassEngine classEngine) {
        HashMap<String, ClassEngine> classNameToClassEngineMap = new HashMap<String, ClassEngine>();
        String className = classEngine.getClassName();
        classNameToClassEngineMap.put(className, classEngine);
        StructureDef dcDef = this.findOrCreateStructureDef(project, className, new HashMap(), classNameToClassEngineMap, true);
        return dcDef;
    }

    private StructureDef findOrCreateStructureDef(Project project, String className, Map classNameToStructureDefMap, Map classNameToClassEngineMap, boolean createStructure) {
        StructureDef dcDef = null;
        if (this.createStructure(createStructure)) {
            dcDef = (StructureDef)classNameToStructureDefMap.get(className);
        }
        if (dcDef == null) {
            dcDef = this.createStructureDef(project, className);
            dcDef.getProperties().put("IsBeanBased", "true");
            classNameToStructureDefMap.put(className, dcDef);
            if (EngineUtils.isComplex(className)) {
                ClassEngine engine = this.findOrCreateClassEngine(project, className, classNameToClassEngineMap);
                JavaClass javaClass = engine.getJavaClass();
                if (javaClass == null) {
                    this.mLogger.severe("ClassNotFound: " + engine.getClassName());
                }
                if (javaClass == null || javaClass.isInterface()) {
                    dcDef.getProperties().put("__HIDE_FROM_CREATORS_LIST__", "true");
                }
                if (this.createStructure(createStructure)) {
                    this.addDefs(project, dcDef, engine, classNameToStructureDefMap, classNameToClassEngineMap);
                }
            }
        }
        return dcDef;
    }

    private ClassEngine findOrCreateClassEngine(Project project, String className, Map classNameToClassEngineMap) {
        ClassEngine classEngine = (ClassEngine)classNameToClassEngineMap.get(className);
        if (classEngine == null) {
            classEngine = new ClassEngine(project, className);
            classNameToClassEngineMap.put(className, classEngine);
        }
        return classEngine;
    }

    /*
     * WARNING - void declaration
     */
    private void addDefs(Project project, StructureDef dcDef, ClassEngine classEngine, Map classNameToStructureDefMap, Map classNameToClassEngineMap) {
        void var13_14;
        if (this.isSkippedClass(classEngine)) {
            return;
        }
        ArrayList<Object> nonGetterMethods = new ArrayList<Object>();
        ArrayList<FieldInfo> getterFields = new ArrayList<FieldInfo>();
        MethodInfo[] mis = classEngine.getMethods(false, this.getIgnoredClasses(), true);
        HashMap attrDefMap = new HashMap();
        JavaManager javaMgr = classEngine.getJavaManager();
        JavaClass javaClass = classEngine.getJavaClass();
        boolean isInterface = javaClass.isInterface();
        boolean bl = false;
        while (var13_14 < mis.length) {
            MethodInfo mi = mis[var13_14];
            if ((isInterface || Modifier.isPublic(mi.modifiers)) && (mi.declaringClassName == null || this.shouldHaveMetaData(mi.declaringClassName)) && !mi.getName().equals("main")) {
                BeanMethodInfo bmi = new BeanMethodInfo(mi);
                if (bmi.isGetter()) {
                    getterFields.add(bmi.getField());
                    this.addStructureDef(project, classEngine, dcDef, attrDefMap, javaMgr, bmi, classNameToStructureDefMap, classNameToClassEngineMap, getterFields);
                } else if (!this.ignoredMethod(mi)) {
                    nonGetterMethods.add(mi);
                }
            }
            ++var13_14;
        }
        for (MethodInfo methodInfo : nonGetterMethods) {
            this.addStructureDef(project, classEngine, dcDef, attrDefMap, javaMgr, new BeanMethodInfo(methodInfo), classNameToStructureDefMap, classNameToClassEngineMap, getterFields);
        }
        MethodInfo[] methodInfoArray = classEngine.getConstructorMethods(this.getIgnoredClasses(), true);
        int i2 = 0;
        while (i2 < methodInfoArray.length) {
            MethodInfo mi = methodInfoArray[i2];
            this.addConstructorsToStructureDef(project, dcDef, classEngine, javaMgr, mi, classNameToStructureDefMap, classNameToClassEngineMap);
            ++i2;
        }
    }

    private void addStructureDef(Project project, ClassEngine classEngine, StructureDef dcDef, Map attrDefMap, JavaManager javaMgr, BeanMethodInfo bmi, Map classNameToStructureDefMap, Map classNameToClassEngineMap, List<FieldInfo> getterFields) {
        AttributeDef attrDef;
        boolean isSetter;
        FieldInfo fi = null;
        boolean isGetter = bmi.isGetter();
        if (isGetter) {
            fi = bmi.getField();
        }
        if (isSetter = bmi.isSetter()) {
            FieldInfo setterFi = bmi.getField();
            for (FieldInfo getterFi : getterFields) {
                if (!ModelUtil.areEqual((Object)getterFi.name, (Object)setterFi.name) || !ModelUtil.areEqual((Object)getterFi.type, (Object)setterFi.type)) continue;
                fi = getterFi;
                break;
            }
            if (fi == null) {
                isSetter = false;
            }
        }
        String memberType = fi != null ? fi.type : bmi.type;
        MemberTypeHelper accessorType = new MemberTypeHelper(javaMgr, classEngine.getJavaClass(), memberType);
        if (isGetter) {
            if (accessorType.isArrayOrCollectionOrComplex()) {
                AccessorDef accessorDef;
                if (accessorType.isComplex) {
                    if (accessorType.isGeneric()) {
                        accessorDef = new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.memberType);
                    } else if (!accessorType.isGeneric && this.shouldHaveMetaData(accessorType.elemType)) {
                        StructureDef structureDef = this.findOrCreateStructureDef(project, accessorType.elemType, classNameToStructureDefMap, classNameToClassEngineMap, false);
                        accessorDef = new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.isArrayOrCollection());
                        accessorDef.setStructure((StructureDefinition)structureDef);
                    } else {
                        String elementName = "element";
                        accessorDef = new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.memberType, elementName, accessorType.elemType);
                    }
                } else {
                    accessorDef = accessorType.elemType != null ? new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.memberType, accessorType.elemType) : new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.memberType);
                }
                if (accessorType.isArrayOrCollection()) {
                    if (accessorType.elemType != null) {
                        this.addAccessMode(accessorDef, bmi);
                        String methodName = this.getAddMethodName(classEngine.getClassName(), accessorType.elemShortType);
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(accessorType.elemType);
                        if (methodName != null && MethodEngine.findMethod(classEngine, methodName, params) != null) {
                            accessorDef.addProperty(ACCESSOR_ADD_METHOD, (Object)methodName);
                        }
                        if ((methodName = this.getRemoveMethodName(classEngine.getClassName(), accessorType.elemShortType)) != null && MethodEngine.findMethod(classEngine, methodName, params) != null) {
                            accessorDef.addProperty(ACCESSOR_REMOVE_METHOD, (Object)methodName);
                        }
                    }
                    this.addUpdateableCollectionOperations(accessorDef);
                } else {
                    this.addSingleValueUpdateableOperations(accessorDef);
                }
                dcDef.addAccessor((AccessorDefinition)accessorDef);
                attrDef = accessorDef;
            } else {
                attrDef = new AttributeDef(fi.name, (StructureDefinition)dcDef, accessorType.elemType, true, bmi.isAnnotatedId());
                dcDef.addAttribute((AttributeDefinition)attrDef);
            }
            this.addProperties(attrDef, bmi);
            attrDefMap.put(fi.name, attrDef);
        } else if (isSetter) {
            attrDef = (AttributeDef)attrDefMap.get(fi.name);
            attrDef.setReadOnly(false);
        }
        if (fi == null) {
            MethodReturnDef methReturnDef;
            MethodDef methDef = new MethodDef(bmi.name, (StructureDefinition)dcDef, this.nullIfVoid(bmi.type));
            memberType = bmi.type;
            MemberTypeHelper returnType = new MemberTypeHelper(javaMgr, classEngine.getJavaClass(), memberType);
            if (returnType.isComplex) {
                if (returnType.isGeneric()) {
                    methReturnDef = new MethodReturnDef(RETURN_VALUE, returnType.memberType, (OperationDefinition)methDef, true);
                } else if (!returnType.isGeneric && this.shouldHaveMetaData(returnType.elemType)) {
                    StructureDef returnDef = this.findOrCreateStructureDef(project, returnType.elemType, classNameToStructureDefMap, classNameToClassEngineMap, false);
                    methReturnDef = new MethodReturnDef(returnType.elemShortType, (StructureDefinition)returnDef, (OperationDefinition)methDef, returnType.isArrayOrCollection());
                } else {
                    methReturnDef = new MethodReturnDef(returnType.elemShortType, (OperationDefinition)methDef, returnType.memberType, "element", returnType.elemType);
                }
                if (returnType.isArrayOrCollection()) {
                    this.addUpdateableCollectionOperations(methReturnDef);
                } else {
                    this.addSingleValueReadOnlyOperations(methReturnDef);
                }
                methDef.setReturnType(methReturnDef);
            } else if (returnType.isArrayOrCollection()) {
                methReturnDef = returnType.elemType != null ? new MethodReturnDef(returnType.elemShortType, (OperationDefinition)methDef, returnType.memberType, returnType.elemType) : new MethodReturnDef(RETURN_VALUE, returnType.memberType, (OperationDefinition)methDef, true);
                methDef.setReturnType(methReturnDef);
                this.addUpdateableCollectionOperations(methReturnDef);
            }
            if (bmi.parameters != null) {
                for (List param : bmi.parameters) {
                    ParamDef paramDef;
                    String pType = (String)param.get(0);
                    String pName = (String)param.get(1);
                    MemberTypeHelper paramTypeHelper = new MemberTypeHelper(javaMgr, classEngine.getJavaClass(), pType);
                    if (paramTypeHelper.isComplex() && !paramTypeHelper.isGeneric(paramTypeHelper.getType()) && !paramTypeHelper.isGeneric && this.shouldHaveMetaData(paramTypeHelper.getType())) {
                        StructureDef structDef = this.findOrCreateStructureDef(project, paramTypeHelper.getType(), classNameToStructureDefMap, classNameToClassEngineMap, false);
                        paramDef = new ParamDef(pName, (StructureDefinition)structDef, (OperationDefinition)methDef, paramTypeHelper.isArrayOrCollection(), false);
                    } else {
                        paramDef = new ParamDef(pName, paramTypeHelper.getType(), (OperationDefinition)methDef, paramTypeHelper.isArrayOrCollection());
                    }
                    methDef.addParameter((ParameterDefinition)paramDef);
                }
            }
            dcDef.addMethod((OperationDefinition)methDef);
        }
    }

    protected String getAddMethodName(String className, String accName) {
        return "add" + accName;
    }

    protected String getRemoveMethodName(String className, String accName) {
        return "remove" + accName;
    }

    private void addConstructorsToStructureDef(Project project, StructureDef dcDef, ClassEngine classEngine, JavaManager javaMgr, MethodInfo mi, Map classNameToStructureDefMap, Map classNameToClassEngineMap) {
        MethodDef methDef = new MethodDef(mi.name, (StructureDefinition)dcDef, true);
        methDef.setReturnType((StructureDefinition)dcDef);
        if (mi.parameters != null) {
            for (List param : mi.parameters) {
                ParamDef paramDef;
                String pType = (String)param.get(0);
                String pName = (String)param.get(1);
                MemberTypeHelper paramTypeHelper = new MemberTypeHelper(javaMgr, classEngine.getJavaClass(), pType);
                if (paramTypeHelper.isComplex() && !paramTypeHelper.isGeneric(paramTypeHelper.getType()) && !paramTypeHelper.isGeneric && this.shouldHaveMetaData(paramTypeHelper.getType())) {
                    StructureDef structDef = this.findOrCreateStructureDef(project, paramTypeHelper.getType(), classNameToStructureDefMap, classNameToClassEngineMap, false);
                    paramDef = new ParamDef(pName, (StructureDefinition)structDef, (OperationDefinition)methDef, paramTypeHelper.isArrayOrCollection(), false);
                } else {
                    paramDef = new ParamDef(pName, paramTypeHelper.getType(), (OperationDefinition)methDef, paramTypeHelper.isArrayOrCollection());
                }
                methDef.addParameter((ParameterDefinition)paramDef);
            }
        }
        dcDef.addConstructorMethod((OperationDefinition)methDef);
    }

    private void addAccessMode(AccessorDef accDef, BeanMethodInfo mi) {
        AccessModeType type = mi.getAccessModeType();
        if (type != AccessModeType.NO_PAGING) {
            String value = type == AccessModeType.RANGE_PAGING ? String.valueOf(2) : String.valueOf(0);
            accDef.setProperty("AccessMode", (Object)value);
        }
    }

    private void addProperties(AttributeDef attrDef, BeanMethodInfo mi) {
        if (mi == null) {
            return;
        }
        Property property = mi.getAnnotatedProperty();
        if (property != null) {
            attrDef.addProperty(property.name(), (Object)property.value());
        }
        Properties props = mi.getAnnotatedProperties();
        if (attrDef != null && mi != null && props != null) {
            int i = 0;
            while (i < props.value().length) {
                Property p = props.value()[i];
                attrDef.addProperty(p.name(), (Object)p.value());
                ++i;
            }
        }
    }

    private String nullIfVoid(String type) {
        return "java.lang.Void".equals(type) ? null : type;
    }

    private boolean isSkippedClass(ClassEngine classEngine) {
        String className = null;
        return classEngine == null || (className = classEngine.getClassName()) == null || className.length() <= 1 || className.startsWith("oracle.toplink") || !this.shouldHaveMetaData(className) || this.getIgnoredClasses().contains(className) || classEngine.getJavaClass() == null;
    }

    private boolean shouldHaveMetaData(String type) {
        return !BeanUtils.skipMetaData((String)type) && !this.getIgnoredClasses().contains(type);
    }

    class MemberTypeHelper {
        boolean isCollection;
        boolean isArray;
        boolean isComplex;
        boolean isGeneric;
        String elemType;
        String elemShortType;
        String memberType;
        private String _type;
        private JavaManager _javaMgr;
        private JavaClass _javaClass;

        public MemberTypeHelper(JavaManager javaMgr, JavaClass javaClass, String type) {
            this._javaMgr = javaMgr;
            this._javaClass = javaClass;
            this._type = type;
            this.isCollection = EngineUtils.isCollection(javaMgr, type);
            this.isArray = EngineUtils.isArray(type);
            this.elemType = this.getElemType();
            this.elemShortType = EngineUtils.getShortName(this.elemType);
            this.memberType = this.getMemberType(type, this.isCollection, this.isArray);
            this.isComplex = EngineUtils.isComplex(this.elemType);
            if (this.isComplex) {
                this.isGeneric = javaMgr.getClass(this.elemType) == null || this.elemType.indexOf(60) > 0;
            }
        }

        public boolean isArrayOrCollection() {
            return this.isCollection || this.isArray;
        }

        public boolean isArrayOrCollectionOrComplex() {
            return this.isArray || this.isCollection || this.isComplex;
        }

        public boolean isComplex() {
            return this.isComplex && !this.isArray;
        }

        public String getElemType() {
            String elemType = this._type;
            if (this.isCollection) {
                elemType = EngineUtils.getGenericCollectionType(this._type);
            } else if (this.isArray) {
                int index = this._type.indexOf(91);
                elemType = this._type.substring(0, index).trim();
            }
            return elemType;
        }

        public String getType() {
            int index;
            String type = this._type;
            if (this.isCollection && (index = type.indexOf(60)) > 0) {
                type = type.substring(0, index);
            }
            return type;
        }

        public boolean isGeneric() {
            return this.isGeneric(this.elemType);
        }

        public boolean isGeneric(String type) {
            return type != null && type.length() > 0 && (type.startsWith("?") || this._javaClass.getTypeParameter(type) != null);
        }

        private String getMemberType(String memberType, boolean isCollection, boolean isArray) {
            int index;
            if (isCollection && (index = memberType.indexOf(60)) > 0) {
                memberType = memberType.substring(0, index).trim();
            }
            return memberType;
        }
    }
}

