/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adfdt.model.ModelDesignTimeContext;
import oracle.adfdt.model.objects.CreatableType;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.builder.CreatableTypeFolder;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.builder.DataControlChildListFolder;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.DataControl;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ExecutableFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IDataControlStructureObject;
import org.eclipse.osgi.util.NLS;

public final class DataControlObjectTreeBuilder {
    public static final int FOLDER_DEFAULT_COMPARE_CATEGORY = 100;
    private static final Set<String> INLINE_IMPLICIT_OPERATION_IDS;
    private DataControlChildListFolder operationFolder;
    private DataControlChildListFolder constructorFolder;
    private DataControlChildListFolder parameterFolder;
    private DataControlChildListFolder namedCriteriaFolder;
    private List<CreatableType> creatableTypes;
    private Map<IStructure, List<IStructureChild>> structureConstructorAttributeMap;
    private boolean constructorStructure;

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("Commit");
        set.add("Rollback");
        INLINE_IMPLICIT_OPERATION_IDS = Collections.unmodifiableSet(set);
    }

    public static ObjectList<IDataControlChild> build(DataControl parent) {
        IStructure structure;
        if (parent != null && (structure = parent.getStructureObject()) != null) {
            DataControlObjectTreeBuilder builder = new DataControlObjectTreeBuilder();
            ArrayList creatableTypes = parent.getDecoratedObject().getCreatableTypes();
            if (!creatableTypes.isEmpty()) {
                ModelDesignTimeContext modelDesignTimeContext = parent.getDecoratedObject().getDesigntimeContext();
                for (CreatableType creatableType : creatableTypes) {
                    if (creatableType.getDesigntimeContext() == null) {
                        creatableType.setDesigntimeContext(modelDesignTimeContext);
                    }
                    builder.getCreatableTypes().add(creatableType);
                }
            }
            List<IDataControlChild> list = builder.computeDataControlChildren((IDataControlObject)parent, structure);
            builder.reset();
            return !list.isEmpty() ? new ObjectList(list) : new ObjectList(0);
        }
        return new ObjectList(0);
    }

    public static ObjectList<IDataControlChild> build(IDataControlStructureObject parent) {
        IStructureChild structureChild;
        if (parent != null && (structureChild = parent.getStructureObject()) != null) {
            DataControlObjectTreeBuilder builder = new DataControlObjectTreeBuilder();
            List<IDataControlChild> list = builder.computeDataControlChildren((IDataControlObject)parent, structureChild);
            builder.reset();
            return !list.isEmpty() ? new ObjectList(list) : new ObjectList(0);
        }
        return new ObjectList(0);
    }

    public void reset() {
        if (this.structureConstructorAttributeMap != null) {
            this.structureConstructorAttributeMap.clear();
            this.structureConstructorAttributeMap = null;
        }
        if (this.creatableTypes != null) {
            this.creatableTypes.clear();
            this.creatableTypes = null;
        }
        this.operationFolder = null;
        this.constructorFolder = null;
        this.parameterFolder = null;
        this.namedCriteriaFolder = null;
    }

    public List<CreatableType> getCreatableTypes() {
        return this.creatableTypes == null ? (this.creatableTypes = new ArrayList<CreatableType>()) : this.creatableTypes;
    }

    public List<IDataControlChild> computeDataControlChildren(IDataControlObject parent, IStructure structure) {
        if (parent != null && structure != null) {
            List<IStructureChild> structureChildren;
            this.constructorStructure = parent instanceof CreatableTypeFolder;
            ArrayList<IDataControlChild> list = new ArrayList<IDataControlChild>();
            List<IStructureChild> list2 = structureChildren = this.constructorStructure ? StructureUtil.findChildren((IStructureObject)structure, StructureObjectType.CONSTRUCTOR) : structure.getChildren();
            if (!structureChildren.isEmpty()) {
                this.addChildren(list, parent, structureChildren);
            }
            if (!this.constructorStructure) {
                for (CreatableType creatableType : this.getCreatableTypes()) {
                    this.getConstructorFolder(list, parent).add(new CreatableTypeFolder((IDataControlObject)this.getConstructorFolder(list, parent), creatableType));
                }
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return new ArrayList<IDataControlChild>(0);
    }

    public List<IDataControlChild> computeDataControlChildren(IDataControlObject parent, IStructureChild structureChild) {
        if (parent != null && structureChild != null) {
            List referencedStructures;
            ArrayList structureChildren = structureChild.getChildren();
            if (structureChildren.isEmpty() && !(referencedStructures = structureChild.getReferencedStructures()).isEmpty()) {
                ArrayList list = new ArrayList();
                for (IStructure referencedStructure : referencedStructures) {
                    list.addAll(referencedStructure.getChildren());
                }
                if (!list.isEmpty()) {
                    structureChildren = list;
                }
            }
            ArrayList<IDataControlChild> list = new ArrayList<IDataControlChild>(structureChildren.size());
            if (!structureChildren.isEmpty()) {
                this.addChildren(list, parent, structureChildren);
                return list;
            }
        }
        return new ArrayList<IDataControlChild>(0);
    }

    private void addChildren(List<IDataControlChild> list, IDataControlObject parent, List<? extends IStructureChild> structureChildren) {
        for (IStructureChild iStructureChild : structureChildren) {
            if (iStructureChild.getKind() == IStructureChild.StructureChildKind.CONTAINER) {
                this.addChildren(list, parent, iStructureChild.getChildren());
                continue;
            }
            this.addChild(list, parent, iStructureChild);
        }
    }

    private void addChild(List<IDataControlChild> list, IDataControlObject parent, IStructureChild structureChild) {
        switch (StructureObjectType.getStructureObjectType((IStructureObject)structureChild)) {
            case CONSTRUCTOR: {
                if (!this.constructorStructure) break;
                IStructureChild constructorReturn = StructureUtil.findFirstChild((IStructureObject)structureChild, StructureObjectType.OPERATION_RETURN);
                for (IStructure referencedStructure : constructorReturn.getReferencedStructures()) {
                    List<IStructureChild> constructorAttributes;
                    if (this.structureConstructorAttributeMap == null) {
                        this.structureConstructorAttributeMap = new HashMap<IStructure, List<IStructureChild>>();
                    }
                    if ((constructorAttributes = this.structureConstructorAttributeMap.get(referencedStructure)) == null) {
                        constructorAttributes = StructureUtil.findChildren((IStructureObject)referencedStructure, StructureObjectType.ATTRIBUTE, StructureObjectType.ACCESSOR);
                        if (!constructorAttributes.isEmpty()) {
                            Iterator<IStructureChild> i = constructorAttributes.iterator();
                            while (i.hasNext()) {
                                if (!StructureUtil.isCollection(i.next())) continue;
                                i.remove();
                            }
                        }
                        this.structureConstructorAttributeMap.put(referencedStructure, constructorAttributes);
                    }
                    IDataControlStructureObject constructorChild = this.createChild(parent, structureChild);
                    list.add(constructorChild);
                    if (constructorAttributes.isEmpty()) {
                        constructorChild.setChildren(Collections.emptyList());
                        continue;
                    }
                    DataControlChildListFolder attributeFolder = new DataControlChildListFolder((IDataControlObject)constructorChild, Messages.attributes);
                    constructorChild.setChildren(Collections.singleton(attributeFolder));
                    for (IStructureChild constructorAttribute : constructorAttributes) {
                        IDataControlStructureObject constructorAttributeChild = this.createChild((IDataControlObject)attributeFolder, constructorAttribute);
                        constructorAttributeChild.setChildren(Collections.emptyList());
                        attributeFolder.add(constructorAttributeChild);
                    }
                }
                break;
            }
            case OPERATION: {
                if (structureChild.getKind() == IStructureChild.StructureChildKind.IMPLICIT && !INLINE_IMPLICIT_OPERATION_IDS.contains(structureChild.getId())) {
                    this.getOperationFolder(list, parent).add(this.createChild((IDataControlObject)this.getOperationFolder(list, parent), structureChild));
                    break;
                }
                list.add(this.createChild(parent, structureChild));
                break;
            }
            case CRITERIA: {
                IStructureChild parentStructureChild;
                IStructureChild iStructureChild = parentStructureChild = parent instanceof IDataControlChild ? ((IDataControlChild)parent).getStructureObject() : null;
                if (StructureObjectType.getStructureObjectType((IStructureObject)parentStructureChild) == StructureObjectType.OPERATION_RETURN) break;
                this.getNamedCriteriaFolder(list, parent).add(this.createChild((IDataControlObject)this.getNamedCriteriaFolder(list, parent), structureChild));
                break;
            }
            case PARAMETER: {
                IDataControlStructureObject parameterChild = this.createChild((IDataControlObject)this.getParameterFolder(list, parent), structureChild);
                this.getParameterFolder(list, parent).add(parameterChild);
                break;
            }
            default: {
                list.add(this.createChild(parent, structureChild));
            }
        }
    }

    private IDataControlStructureObject createChild(IDataControlObject parent, IStructureChild structureChild) {
        IDataControlStructureObject child = ExecutableFactory.eINSTANCE.createIDataControlStructureObject();
        child.setParent((IObject)parent);
        child.setStructureObject(structureChild);
        return child;
    }

    private DataControlChildListFolder getOperationFolder(List<IDataControlChild> list, IDataControlObject parent) {
        if (this.operationFolder == null) {
            this.operationFolder = new DataControlChildListFolder(parent, Messages.operations);
            this.operationFolder.setCompareCategory(-50);
            list.add(this.operationFolder);
        }
        assert (list.contains(this.operationFolder));
        assert (this.operationFolder.getParent() == parent);
        return this.operationFolder;
    }

    private DataControlChildListFolder getConstructorFolder(List<IDataControlChild> list, IDataControlObject parent) {
        if (this.constructorFolder == null) {
            this.constructorFolder = new DataControlChildListFolder(parent, Messages.constructors);
            list.add(this.constructorFolder);
        }
        assert (list.contains(this.constructorFolder));
        assert (this.constructorFolder.getParent() == parent);
        return this.constructorFolder;
    }

    private DataControlChildListFolder getNamedCriteriaFolder(List<IDataControlChild> list, IDataControlObject parent) {
        if (this.namedCriteriaFolder == null) {
            this.namedCriteriaFolder = new DataControlChildListFolder(parent, Messages.namedCriteria);
            this.namedCriteriaFolder.setCompareCategory(-100);
            list.add(this.namedCriteriaFolder);
        }
        assert (list.contains(this.namedCriteriaFolder));
        assert (this.namedCriteriaFolder.getParent() == parent);
        return this.namedCriteriaFolder;
    }

    private DataControlChildListFolder getParameterFolder(List<IDataControlChild> list, IDataControlObject parent) {
        if (this.parameterFolder == null) {
            this.parameterFolder = new DataControlChildListFolder(parent, Messages.parameters);
            list.add(this.parameterFolder);
        }
        assert (list.contains(this.parameterFolder));
        assert (this.parameterFolder.getParent() == parent);
        return this.parameterFolder;
    }

    static final class Messages
    extends NLS {
        public static String operations;
        public static String attributes;
        public static String constructors;
        public static String namedCriteria;
        public static String parameters;
        public static String folder;

        static {
            NLS.initializeMessages((String)DataControlObjectTreeBuilder.class.getName(), Messages.class);
        }

        Messages() {
        }
    }
}

