/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.builder.DataControlObjectFolder;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IDataControlStructureObject;

class DataControlChildListFolder
extends DataControlObjectFolder<List<? extends IDataControlChild>> {
    public DataControlChildListFolder(IDataControlObject parent, String label) {
        super(parent, new ObjectList(), label);
    }

    public void add(IDataControlChild dataControlChild) {
        if (dataControlChild.getParent() != this) {
            throw new IllegalArgumentException("This folder must be the parent of its data control child");
        }
        this.doGetChildren().add((Object)dataControlChild);
    }

    public void addAll(Collection<? extends IDataControlChild> dataControlChildren) {
        for (IDataControlChild iDataControlChild : dataControlChildren) {
            this.add(iDataControlChild);
        }
    }

    @Override
    protected ObjectList<IDataControlChild> doGetChildren() {
        return (ObjectList)this.getDecoratedObject();
    }

    @Override
    protected String getNonEncodedSegment() {
        List dataControlChildren = (List)this.getDecoratedObject();
        int[] hashCodes = new int[dataControlChildren.size()];
        int i = 0;
        while (i < hashCodes.length) {
            IDataControlChild child = (IDataControlChild)dataControlChildren.get(i);
            hashCodes[i] = child instanceof IDataControlStructureObject ? DTRTvUtil.getNonEncodedURISegment(((IDataControlStructureObject)child).getDecoratedObject()).hashCode() : (String.valueOf(child.getClass().getSimpleName()) + '_' + child.getId()).hashCode();
            ++i;
        }
        return String.valueOf(this.getId()) + "children" + Arrays.hashCode(hashCodes);
    }
}

