/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.command.IUpdateStructureCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.ISourceHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class UpdateStructureCommand
extends DataControlCommand
implements IUpdateStructureCommand {
    private List<ISourceHandler> handlers;

    public UpdateStructureCommand(IDataControlContext context) {
        super(context);
    }

    @Override
    public void dispose() {
        if (this.handlers != null) {
            this.handlers.clear();
            this.handlers = null;
        }
        super.dispose();
    }

    @Override
    public UpdateStructureCommand clone() {
        return new UpdateStructureCommand(this.getCommandStack()).setStructureSource(this.getStructureSource());
    }

    @Override
    public UpdateStructureCommand setStructureSource(IStructure.IStructureSource source) {
        return (UpdateStructureCommand)super.setStructureSource(source);
    }

    public String getLabel() {
        return Messages.updateStructure;
    }

    @Override
    protected void assertExecution() throws Exception {
        this.handlers = null;
        List<DataControlType> dataControlTypes = DataControlType.getTypes(this.getStructureSource());
        DTRTUtil.assertTrue((!dataControlTypes.isEmpty() ? 1 : 0) != 0, (String)Messages.unknownDataControlSource);
        this.handlers = new ArrayList<ISourceHandler>(dataControlTypes.size());
        for (DataControlType dataControlType : dataControlTypes) {
            ISourceHandler handler = dataControlType.createHandler(this.getStructureSource());
            DTRTUtil.assertTrue((handler != null ? 1 : 0) != 0, (String)Messages.unknownDataControlHandlerForSource);
            handler.assertExecution(this);
            this.handlers.add(handler);
        }
        super.assertExecution();
    }

    @Override
    protected List<? extends IObject> run(IProgressMonitor monitor) throws Exception {
        assert (this.handlers != null);
        assert (!this.handlers.isEmpty());
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)this.handlers.size());
        for (ISourceHandler handler : this.handlers) {
            handler.updateStructure(this, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        }
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return Collections.emptyList();
    }
}

