/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Collection;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.DataControlFactoryImpl;
import oracle.adf.model.adapter.generic.DataControlStructure;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.model.objects.Configuration;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfinternal.model.adapter.generic.DataControlStructureImpl;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.common.JRFVersion;
import oracle.eclipse.tools.adf.common.technology.ADFCommonTechnologyExtension;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.IStructureCommand;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.ISourceHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.UpdateStructureCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.BeanStructureBuilder;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class JavaHandler<I extends IDataControlSourceInfo>
implements ISourceHandler,
BeanDataControlProvider.IFilter {
    protected static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    private I sourceInfo;

    protected JavaHandler(I sourceInfo) {
        assert (sourceInfo != null);
        this.sourceInfo = sourceInfo;
    }

    @Override
    public void dispose() {
        this.sourceInfo = null;
    }

    public final I getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public void assertExecution(IStructureCommand command) throws Exception {
        DTRTUtil.assertTrue((this.getJavaProject() != null ? 1 : 0) != 0, (String)Messages.unknownJavavProject);
    }

    protected final void assertExecution(CreateDataControlCommand command, IType type) throws Exception {
        String validationErrorMessage = JavaHandler.validateTypeAsDataControl(type);
        DTRTUtil.assertTrue((validationErrorMessage == null ? 1 : 0) != 0, (String)validationErrorMessage);
    }

    public static String validateTypeAsDataControl(IType type) {
        try {
            if (type == null) {
                return Messages.unknownSourceType;
            }
            if (!type.isClass()) {
                return Messages.invalidType;
            }
            if (type.getDeclaringType() != null) {
                return Messages.cannotBeInnerClass;
            }
            if (type.isAnonymous()) {
                return Messages.cannotBeAnonType;
            }
            if (Flags.isAbstract((int)type.getFlags())) {
                return Messages.cannotBeAbstract;
            }
            boolean hasPublicDefaultConstructor = true;
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    if (method.getParameters().length == 0 && Flags.isPublic((int)method.getFlags())) {
                        hasPublicDefaultConstructor = true;
                        break;
                    }
                    hasPublicDefaultConstructor = false;
                }
                ++n2;
            }
            if (!hasPublicDefaultConstructor) {
                return Messages.missingDefaultPublicConstructor;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected final void handleDataControlId(CreateDataControlCommand command, IDataControlSourceInfo sourceInfo) {
        String id = command.getDataControlId();
        if (id == null) {
            command.setDataControlId(DTRTvContextUtil.computeUniqueId((IOEPEContext)command.getCommandStack(), IDataControl.class, sourceInfo.getBaseDataControlId(), command.getDataControlType()));
        } else {
            IStatus status = DTRTvContextUtil.isValidObjectId(IDataControl.class, id);
            DTRTUtil.assertTrue((boolean)status.isOK(), (String)NLS.bind((String)Messages.invalidDataControlId, (Object)status.getMessage()));
            try {
                DTRTUtil.assertTrue((DTRTObjectUtil.find((Collection)command.getCommandStack().getDataControls(null), (String)id) == null ? 1 : 0) != 0, (String)NLS.bind((String)Messages.existingDataControl, (Object)id));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected final IDataControl createDataControl(IType type, CreateDataControlCommand command, IProgressMonitor monitor) throws Exception {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)command.getCommandStack());
        DataControlStructure dataControlStructure = this.createDataControlStructure(manager.getTypeHelper(), type, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        assert (dataControlStructure != null);
        ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
        DataControl dataControl = this.createDataControl(command, this.createDefinition(dataControlStructure), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        assert (dataControl != null);
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        IObjectTranslator translator = OEPEContextImpl.getTranslator((IOEPEContext)command.getCommandStack());
        return (IDataControl)translator.fromADFObject((Object)dataControl, IDataControl.class);
    }

    protected final void updateStructure(IType type, UpdateStructureCommand command, IProgressMonitor monitor) throws Exception {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)command.getCommandStack());
        DataControlStructure dataControlStructure = this.createDataControlStructure(manager.getTypeHelper(), type, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        assert (dataControlStructure != null);
        ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
        BeanStructureBuilder.updateBeanStructure(manager, this.createDefinition(dataControlStructure));
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
    }

    private DataControlStructure createDataControlStructure(ITypeHelper typeHelper, IType type, IProgressMonitor monitor) throws Exception {
        StructureDefinition structureDefinition = BeanDataControlProvider.buildStructure(typeHelper, type, this);
        assert (structureDefinition != null);
        this.adjustStructureDefinition(typeHelper, structureDefinition);
        Node runtimeSettings = this.getRuntimeSettings(typeHelper);
        return new DataControlStructureImpl(type.getElementName(), runtimeSettings, structureDefinition);
    }

    protected void adjustStructureDefinition(ITypeHelper typeHelper, StructureDefinition structureDefinition) throws Exception {
    }

    protected abstract IJavaProject getJavaProject();

    protected abstract Node getRuntimeSettings(ITypeHelper var1) throws Exception;

    protected abstract AbstractDefinition createDefinition(DataControlStructure var1);

    protected final JpaProject getJPAProject() {
        IProject project;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null && (project = javaProject.getProject()) != null) {
            return (JpaProject)project.getAdapter(JpaProject.class);
        }
        return null;
    }

    private DataControl createDataControl(ICreateDataControlCommand command, AbstractDefinition definition, IProgressMonitor monitor) throws Exception {
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)command.getCommandStack());
        assert (manager.getProject().equals((Object)this.getJavaProject().getProject()));
        Configuration configuration = manager.getLocalConfiguration(true);
        DataControl dataControl = configuration.findDataControl(command.getDataControlId());
        if (dataControl != null) {
            throw new IllegalStateException(NLS.bind((String)Messages.existingDataControl, (Object)command.getDataControlId()));
        }
        dataControl = this.createDataControl(manager, configuration, definition, command.getDataControlId());
        assert (dataControl != null);
        return dataControl;
    }

    private DataControl createDataControl(IDTRTManager manager, Configuration configuration, AbstractDefinition definition, String id) throws Exception {
        IVersion version;
        JUDTAdapterDataControl dataControl = new JUDTAdapterDataControl();
        Element dataControlElement = configuration.getDocument().createElementNS(dataControl.getNameSpaceUrl(), dataControl.getXMLElementTag());
        dataControl.initializeFromElement(configuration.getTransactionManager(), dataControlElement);
        dataControl.setId(id);
        dataControl.initializeFromDef(definition);
        IProject project = this.getJavaProject().getProject();
        assert (project != null);
        boolean resetFactoryClass = true;
        ADFCommonTechnologyExtension techExt = new ADFCommonTechnologyExtension((Project)project.getAdapter(Project.class), null);
        JRFVersion jrfVersion = techExt.getJRFVersion();
        if (jrfVersion != null && (version = jrfVersion.getVersion()) != null && version.compareTo((Object)new JRFVersion("11.1.1.7.0").getVersion()) >= 0) {
            resetFactoryClass = false;
        }
        if (resetFactoryClass) {
            dataControl.setFactoryClass(DataControlFactoryImpl.class.getName());
        }
        if (definition.getCachingMode() == 0) {
            BeanStructureBuilder.build(manager, dataControl);
        }
        dataControl.setDefinitionClass(definition.getStructure().getFullName());
        configuration.addDataControl((DataControl)dataControl);
        return configuration.findDataControl(id);
    }

    protected final boolean isQueryByRangeMethod(String name, String returnType) {
        return !Void.TYPE.getName().equals(returnType) && "queryByRange".equals(name);
    }
}

