/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.ISourceHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateDataControlCommand
extends DataControlCommand
implements ICreateDataControlCommand {
    private String dataControlId;
    private DataControlType dataControlType;
    private ISourceHandler handler;

    public CreateDataControlCommand(IDataControlContext context) {
        super(context);
    }

    @Override
    public void dispose() {
        this.dataControlId = null;
        this.dataControlType = null;
        this.handler = null;
        super.dispose();
    }

    @Override
    public CreateDataControlCommand clone() {
        return new CreateDataControlCommand(this.getCommandStack()).setStructureSource(this.getStructureSource()).setDataControlId(this.getDataControlId());
    }

    @Override
    public CreateDataControlCommand setStructureSource(IStructure.IStructureSource source) {
        return (CreateDataControlCommand)super.setStructureSource(source);
    }

    public CreateDataControlCommand setStructureSource(IStructure.IStructureSource source, String dataControlId) {
        super.setStructureSource(source);
        this.dataControlId = dataControlId;
        return this;
    }

    public CreateDataControlCommand setDataControlType(IDescribable type) {
        this.checkExecuted();
        this.dataControlType = (DataControlType)type;
        return this;
    }

    public DataControlType getDataControlType() {
        return this.dataControlType;
    }

    public CreateDataControlCommand setDataControlId(String dataControlId) {
        this.dataControlId = dataControlId;
        return this;
    }

    public String getDataControlId() {
        return this.dataControlId;
    }

    public String getLabel() {
        return Messages.createDataControl;
    }

    @Override
    protected void assertExecution() throws Exception {
        this.handler = null;
        DTRTUtil.assertTrue((this.getDataControlType() != null ? 1 : 0) != 0, (String)Messages.dataControlTypeNotSet);
        this.handler = this.getDataControlType().createHandler(this.getStructureSource());
        DTRTUtil.assertTrue((this.handler != null ? 1 : 0) != 0, (String)Messages.unknownDataControlSource);
        this.handler.assertExecution(this);
        super.assertExecution();
    }

    @Override
    protected List<? extends IObject> run(IProgressMonitor monitor) throws Exception {
        return Collections.singletonList(this.handler.createDataControl(this, monitor));
    }
}

