/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateTaskFlowActivityPageDefinitionCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DataControlProviderExecutableContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.CreateTaskFlowActivityPageDefinitionCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.impl.PageDefinitionImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.BoundSourceUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.Cache;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

final class TaskFlowContext
extends DataControlProviderExecutableContext
implements ITaskFlowContext {
    private Cache<ActivityKey, Pair<PageDefinition, IPageDefinition>> pageDefinitionCache;
    private ITaskFlowContext.ITaskFlowProxy taskFlow;

    TaskFlowContext() {
    }

    @Override
    protected void doDispose() {
        if (this.pageDefinitionCache != null) {
            for (Pair pair : this.pageDefinitionCache.values()) {
                ((IPageDefinition)pair.getSecond()).dispose();
            }
            this.pageDefinitionCache.clear();
            this.pageDefinitionCache = null;
        }
        this.taskFlow = null;
        super.doDispose();
    }

    @Override
    protected boolean doReset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!this.pageDefinitionCache.isEmpty()) {
            for (Pair pair : this.pageDefinitionCache.values()) {
                ((IPageDefinition)pair.getSecond()).dispose();
            }
            this.pageDefinitionCache.clear();
            return super.doReset(monitor);
        }
        return false;
    }

    public TaskFlowContext initialize(IProject earProject, ITaskFlowContext.ITaskFlowProxy taskFlow, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!this.isInitialized()) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)5);
            try {
                this.taskFlow = taskFlow;
                this.initializeManager(earProject, taskFlow.getTaskFlowFile().getProject());
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
                this.pageDefinitionCache = new Cache(false);
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return (TaskFlowContext)this.initialize((OEPEContextImpl)this);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.throwNotInitializedException(e);
            }
        }
        return this;
    }

    public IProject getEARProject() {
        return this.getManager() != null ? this.getManager().getEARProject() : null;
    }

    public ITaskFlowContext.ITaskFlowProxy getTaskFlow() {
        return this.taskFlow;
    }

    public boolean isValidBoundSourceActivity(Object activity) {
        try {
            this.checkBoundSourceActivity(activity);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IPageDefinition getPageDefinition(Object activity) throws IllegalStateException {
        this.checkInitialized();
        this.checkBoundSourceActivity(activity);
        Pair<PageDefinition, IPageDefinition> pair = this.getOrCreatePair(activity);
        return pair != null ? (IPageDefinition)pair.getSecond() : null;
    }

    public List<? extends IPageDefinition> getPageDefinitions() throws IllegalStateException {
        this.checkInitialized();
        List activities = this.taskFlow.getActivities();
        ArrayList<IPageDefinition> pageDefinitions = new ArrayList<IPageDefinition>();
        for (Object activity : activities) {
            Pair<PageDefinition, IPageDefinition> pair;
            if (!this.isValidBoundSourceActivity(activity) || (pair = this.getOrCreatePair(activity)) == null || pair.getSecond() == null) continue;
            pageDefinitions.add((IPageDefinition)pair.getSecond());
        }
        return pageDefinitions.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(pageDefinitions);
    }

    private Pair<PageDefinition, IPageDefinition> getOrCreatePair(Object activity) {
        ActivityKey activityKey = ActivityKey.create(this.taskFlow, activity);
        Pair pair = (Pair)this.pageDefinitionCache.get((Object)activityKey);
        if (pair == null) {
            PageDefinition adfPageDefinition = this.getADFPageDefinition(activity, false);
            IPageDefinition pageDefinition = this.getPageDefinition(adfPageDefinition);
            if (pageDefinition != null) {
                pair = new Pair((Object)adfPageDefinition, (Object)pageDefinition);
                this.pageDefinitionCache.set((Object)activityKey, (Object)pair);
            }
        } else if (!this.getManager().isManagedElement(pair.getFirst())) {
            this.pageDefinitionCache.unset((Object)activityKey);
            pair = null;
        }
        return pair;
    }

    private void checkBoundSourceActivity(Object activity) {
        String id = this.getTaskFlow().getActivityId(activity);
        if (id == null) {
            throw new IllegalArgumentException(Messages.noId);
        }
        String type = this.getTaskFlow().getActivityType(activity);
        if (type == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.noType, (Object)id));
        }
        if (!BoundSourceUtil.isBindableSource((String)type)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.unsupportedType, (Object)id));
        }
    }

    private PageDefinition getADFPageDefinition(Object activity, boolean create) {
        try {
            this.getManager().setBoundSource(BoundSourceUtil.createTaskFlowBoundSource((ITaskFlowContext.ITaskFlowProxy)this.taskFlow, (Object)activity));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        PageDefinition adfPageDefinition = this.getManager().getPageDefinition(create);
        if (adfPageDefinition != null) {
            this.getManager().registerUnknownElementObjectFactories(adfPageDefinition);
        }
        return adfPageDefinition;
    }

    private IPageDefinition getPageDefinition(PageDefinition adfPageDefinition) {
        if (adfPageDefinition != null) {
            IPageDefinition pageDefinition = (IPageDefinition)this.getTranslator().fromADFObject((Object)adfPageDefinition, IPageDefinition.class);
            if (pageDefinition instanceof PageDefinitionImpl) {
                ((PageDefinitionImpl)pageDefinition).setManager(this.getManager());
            }
            return pageDefinition;
        }
        return null;
    }

    public IFileMarker getAccessibleDeclaration(IDataControlObject dataControlObject) {
        List<? extends IFileMarker> markers = super.getAccessibleDeclarations((IObject)dataControlObject);
        return markers.isEmpty() ? null : markers.get(0);
    }

    protected <T extends ICommand> T doCreateCommand(Class<T> commandType) {
        this.checkCommandCreation();
        CreateTaskFlowActivityPageDefinitionCommand command = commandType == ICreateTaskFlowActivityPageDefinitionCommand.class ? new CreateTaskFlowActivityPageDefinitionCommand(this) : null;
        return (T)(command != null ? (ICommand)commandType.cast((Object)command) : null);
    }

    public Collection<? extends IStructure> getLoadedStructures() {
        return DTRTvContextUtil.getLoadedStructures(this);
    }

    @Override
    public void resetStructures(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.pageDefinitionCache != null) {
            for (Pair pair : this.pageDefinitionCache.values()) {
                IPageDefinition pageDefinition = (IPageDefinition)pair.getSecond();
                if (!(pageDefinition instanceof oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition)) continue;
                ((oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition)pageDefinition).clearDataControlCache();
            }
        }
        super.resetStructures(monitor);
    }

    private static class ActivityKey {
        private final String id;
        private final String type;

        public static ActivityKey create(ITaskFlowContext.ITaskFlowProxy proxy, Object activity) {
            return new ActivityKey(proxy.getActivityId(activity), proxy.getActivityType(activity));
        }

        public ActivityKey(String id, String type) {
            assert (id != null);
            assert (type != null);
            this.id = id;
            this.type = type;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ActivityKey other = (ActivityKey)obj;
            return DTRTUtil.equals((Object)this.id, (Object)other.id) && DTRTUtil.equals((Object)this.type, (Object)other.type);
        }
    }

    private static class Messages
    extends NLS {
        public static String noId;
        public static String noType;
        public static String unsupportedType;

        static {
            NLS.initializeMessages((String)TaskFlowContext.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

