/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common;

import java.io.InputStream;
import java.net.URL;

public final class ClassUtils {
    public static Class forName(String className) throws ClassNotFoundException {
        Class<?> cls = null;
        if (className != null) {
            cls = Class.forName(className, true, ClassUtils.getClassLoader());
        }
        return cls;
    }

    public static Class forName(String className, Class referenceClass) throws ClassNotFoundException {
        Class<?> cls = null;
        if (className != null) {
            cls = Class.forName(className, true, ClassUtils.getClassLoader(referenceClass));
        }
        return cls;
    }

    public static ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(ClassUtils.class);
    }

    public static ClassLoader getClassLoader(Class referenceClass) {
        ClassLoader loader = ClassUtils.class.getClassLoader();
        if (loader == null && referenceClass != null) {
            loader = referenceClass.getClassLoader();
        }
        return loader;
    }

    public static URL getResource(ClassLoader loader, String resourceName) {
        return loader.getResource(resourceName);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resourceName) {
        return loader.getResourceAsStream(resourceName);
    }

    public static ClassLoader getParentClassLoader(ClassLoader cl) {
        ClassLoader parentCl = cl.getParent();
        return parentCl;
    }

    public static boolean isAncestor(ClassLoader clsLoader, ClassLoader parentClsLoader) {
        ClassLoader childClsLoader = clsLoader;
        do {
            if (parentClsLoader != (childClsLoader = childClsLoader.getParent())) continue;
            return true;
        } while (childClsLoader != null);
        return false;
    }
}

