/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.syslib.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.coherence.facets.CoherenceFacet;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Version;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.w3c.dom.Element;

public final class CoherenceClasspathContainer
implements IClasspathContainer {
    public static final String CONTAINER_ID = "oracle.eclipse.tools.coherence.lib.omw";
    public static final IPath CONTAINER_PATH = new Path("oracle.eclipse.tools.coherence.lib.omw");
    private static final IClasspathEntry[] EMPTY_CLASSPATH_ENTRY = new IClasspathEntry[0];
    private static final String LIB = "lib";
    private static final String JAR = ".jar";
    private static final String[] COHERENCE_PATH = new String[]{"coherence-rest", "jersey-core-", "jersey-server-"};
    private static boolean initialized = false;
    private static ContainersRefresherThread containersRefresherThread = null;
    private final IPath containerPath;
    private final IClasspathEntry[] entries;

    private CoherenceClasspathContainer(IPath containerPath, IClasspathEntry[] entries) {
        this.containerPath = containerPath;
        this.entries = entries;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    public String getDescription() {
        return Resources.containerLabel;
    }

    public int getKind() {
        return 2;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CoherenceClasspathContainer)) {
            return false;
        }
        return Arrays.equals(this.entries, ((CoherenceClasspathContainer)obj).entries);
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    private static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            RuntimeLifecycleListener.register();
            ResourceChangeListener.register();
            containersRefresherThread = new ContainersRefresherThread();
            containersRefresherThread.start();
        }
    }

    private static ContainersRefresherThread getContainersRefresherThread() {
        return containersRefresherThread;
    }

    private static boolean isOnClasspath(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            IClasspathEntry[] cp;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = cp = javaProject.getRawClasspath();
            int n = cp.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (CoherenceClasspathContainer.isCoherenceContainer(cpe)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isCoherenceContainer(IClasspathEntry cpe) {
        IPath path = cpe.getPath();
        return path.equals((Object)CONTAINER_PATH);
    }

    private static void refreshContainer(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            CoherenceClasspathContainer.refreshContainer(JavaCore.create((IProject)project));
        }
    }

    private static void refreshContainer(IJavaProject project) throws CoreException {
        CoherenceClasspathContainer newContainer;
        IClasspathContainer cont;
        CoherenceClasspathContainer existingContainer;
        IClasspathEntry[] cp = project.getRawClasspath();
        IPath containerPath = null;
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (CoherenceClasspathContainer.isCoherenceContainer(cpe)) {
                containerPath = cpe.getPath();
                break;
            }
            ++n2;
        }
        if (containerPath != null && !(existingContainer = (CoherenceClasspathContainer)(cont = JavaCore.getClasspathContainer(containerPath, (IJavaProject)project))).equals(newContainer = CoherenceClasspathContainer.createContainer(project, containerPath))) {
            IJavaProject[] projectsArray = new IJavaProject[]{project};
            IClasspathContainer[] containersArray = new IClasspathContainer[]{newContainer};
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])projectsArray, (IClasspathContainer[])containersArray, null);
        }
    }

    public static IClasspathEntry[] getClasspathEntry(IJavaProject project, String facetVersion) {
        File home;
        String coherenceHome;
        WebLogicServerInstall wlsInstall = WebLogicServerInstall.getWebLogicServerInstall((IProject)project.getProject());
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        if (wlsInstall != null && (coherenceHome = CoherenceClasspathContainer.findCoherenceHome(home = wlsInstall.getMiddlewareHomeLocation(), facetVersion)) != null) {
            File coherenceJar = new File(coherenceHome, "lib/coherence.jar");
            IClasspathEntry cpe = JavaProjectUtil.newLibraryEntry((IPath)new Path(coherenceJar.getAbsolutePath()), null, null);
            cpEntries.add(cpe);
            String[] stringArray = COHERENCE_PATH;
            int n = COHERENCE_PATH.length;
            int n2 = 0;
            while (n2 < n) {
                String relPath = stringArray[n2];
                File relJar = CoherenceClasspathContainer.findLibFile(coherenceHome, relPath);
                if (relJar != null && relJar.exists()) {
                    IClasspathEntry restEntry = JavaProjectUtil.newLibraryEntry((IPath)new Path(relJar.getAbsolutePath()), null, null);
                    cpEntries.add(restEntry);
                }
                ++n2;
            }
        }
        return cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
    }

    private static File findLibFile(String parent, final String path) {
        File parentFile = new File(parent, LIB);
        File[] files = parentFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.startsWith(path) && arg1.endsWith(CoherenceClasspathContainer.JAR);
            }
        });
        if (files.length == 1) {
            return files[0];
        }
        if (files.length > 1) {
            Arrays.sort(files, 0, files.length, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Version v1 = CoherenceClasspathContainer.getVersion((File)arg0);
                    Version v2 = CoherenceClasspathContainer.getVersion((File)arg1);
                    if (v1 != null && v2 != null) {
                        return v2.compareTo(v1);
                    }
                    return 0;
                }
            });
            return files[0];
        }
        return null;
    }

    private static Version getVersion(File file) {
        int lastdash;
        String name = file.getName();
        int lastdot = name.lastIndexOf(46);
        if (lastdot > (lastdash = name.lastIndexOf(45)) && lastdash > 0) {
            return new Version(name.substring(lastdash + 1, lastdot));
        }
        return null;
    }

    private static CoherenceClasspathContainer createContainer(IJavaProject project, IPath containerPath) throws CoreException {
        IProjectFacetVersion facetVersion = CoherenceFacet.getProjectFacet(project.getProject());
        IClasspathEntry[] cpEntriesArray = null;
        cpEntriesArray = facetVersion != null ? CoherenceClasspathContainer.getClasspathEntry(project, facetVersion.getVersionString()) : EMPTY_CLASSPATH_ENTRY;
        return new CoherenceClasspathContainer(containerPath, cpEntriesArray);
    }

    public static String findCoherenceHome(File home, String version) {
        version = version.equals("3.7") ? "3.7.0" : version;
        File registryFile = new File(home, "registry.xml");
        if (registryFile != null && registryFile.exists()) {
            Element root = DomUtil.root((File)registryFile);
            HashMap<String, String> map = new HashMap<String, String>();
            CoherenceClasspathContainer.gatherCoherenceHome(root, map);
            String coherenceVersion = null;
            String coherenceHome = null;
            for (Map.Entry entry : map.entrySet()) {
                String v = (String)entry.getKey();
                if (!v.startsWith(version) || coherenceVersion != null && coherenceVersion.compareTo(v) >= 0) continue;
                coherenceVersion = v;
                coherenceHome = (String)entry.getValue();
            }
            if (coherenceHome != null) {
                return coherenceHome;
            }
        } else {
            Element root;
            Element versionElement;
            String v;
            File coherence = new File(home, "oracle_common/coherence");
            File productXml = new File(coherence, "product.xml");
            if (!productXml.exists()) {
                coherence = new File(home, "/coherence");
                productXml = new File(coherence, "product.xml");
            }
            if (productXml.exists() && (v = (versionElement = DomUtil.element((Element)(root = DomUtil.root((File)productXml)), (String)"version")).getAttribute("value")) != null && v.startsWith(version)) {
                return coherence.getAbsolutePath();
            }
        }
        return null;
    }

    public static File findCoherenceJar(File home, String version) {
        String coherenceHome = CoherenceClasspathContainer.findCoherenceHome(home, version);
        if (coherenceHome != null) {
            return new File(coherenceHome, "lib/coherence.jar");
        }
        return null;
    }

    private static void gatherCoherenceHome(Element root, Map<String, String> map) {
        for (Element e : DomUtil.elements((Element)root)) {
            if ("component".equals(e.getNodeName()) && "Oracle Coherence".equals(e.getAttribute("name"))) {
                String version = e.getAttribute("version");
                String installDir = e.getAttribute("InstallDir");
                map.put(version, installDir);
            }
            CoherenceClasspathContainer.gatherCoherenceHome(e, map);
        }
    }

    private static final class ContainersRefresherThread
    extends Thread {
        private final LinkedList<IProject> projects = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getProjectFromQueue() {
            LinkedList<IProject> linkedList = this.projects;
            synchronized (linkedList) {
                block6: {
                    if (!this.projects.isEmpty()) break block6;
                    try {
                        this.projects.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return this.projects.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectToQueue(IProject project) {
            LinkedList<IProject> linkedList = this.projects;
            synchronized (linkedList) {
                this.projects.addLast(project);
                this.projects.notify();
            }
        }

        @Override
        public void run() {
            IProject project;
            while ((project = this.getProjectFromQueue()) != null) {
                try {
                    IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor arg0) throws CoreException {
                            CoherenceClasspathContainer.refreshContainer(project);
                        }
                    };
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wsr, (ISchedulingRule)ws.getRoot(), 0, null);
                    continue;
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)e);
                    continue;
                }
                break;
            }
            return;
        }
    }

    public static final class Initializer
    extends ClasspathContainerInitializer {
        public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
            CoherenceClasspathContainer.initialize();
            CoherenceClasspathContainer container = CoherenceClasspathContainer.createContainer(project, containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private static final class ResourceChangeListener
    implements IResourceChangeListener {
        private final List<IPath> triggerFiles = new ArrayList<IPath>();

        public static void register() {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
        }

        private ResourceChangeListener() {
            this.triggerFiles.add((IPath)new Path(".settings/org.eclipse.wst.common.project.facet.core.xml"));
            this.triggerFiles.add(CONTAINER_PATH);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta subdelta = iResourceDeltaArray[n2];
                IProject project = (IProject)subdelta.getResource();
                boolean relevant = false;
                for (IPath p : this.triggerFiles) {
                    if (subdelta.findMember(p) == null) continue;
                    try {
                        if (!CoherenceClasspathContainer.isOnClasspath(project)) break;
                        relevant = true;
                    }
                    catch (CoreException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)e);
                    }
                    break;
                }
                if (relevant) {
                    CoherenceClasspathContainer.getContainersRefresherThread().addProjectToQueue(project);
                }
                ++n2;
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String containerLabel;

        static {
            Resources.initializeMessages((String)CoherenceClasspathContainer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class RuntimeLifecycleListener
    implements IRuntimeLifecycleListener {
        private RuntimeLifecycleListener() {
        }

        public static void register() {
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new RuntimeLifecycleListener());
        }

        public void runtimeAdded(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        public void runtimeChanged(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        public void runtimeRemoved(IRuntime runtime) {
            this.handleEvent(runtime);
        }

        private void handleEvent(IRuntime runtime) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime r;
                    IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
                    if (fproj != null && (r = fproj.getPrimaryRuntime()) != null && r.getName().equals(runtime.getId())) {
                        CoherenceClasspathContainer.getContainersRefresherThread().addProjectToQueue(project);
                    }
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)e);
                }
                ++n2;
            }
        }
    }
}

