/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.modules;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.coherence.modules.GarDeployable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jee.internal.deployables.JEEDeployableFactory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class GarModuleFactoryDelegate
extends JEEDeployableFactory {
    private Map<IModule, ModuleDelegate> garModuleDelegates = new HashMap<IModule, ModuleDelegate>();

    protected IModule[] createModules(IProject project) {
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
            for (IProjectFacetVersion fv : fp.getProjectFacets()) {
                if (!fv.getProjectFacet().getId().equals("oracle.coherence.gar")) continue;
                GarDeployable deployable = new GarDeployable(project);
                String type = fv.getProjectFacet().getId();
                String version = fv.getVersionString();
                IModule newModule = this.createModule(project.getName(), project.getName(), type, version, project);
                deployable.initialize(newModule);
                this.garModuleDelegates.put(newModule, (ModuleDelegate)deployable);
                return new IModule[]{deployable.getModule()};
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        if (module == null) {
            return null;
        }
        ModuleDelegate md = this.garModuleDelegates.get(module);
        if (md == null) {
            this.createModules(module.getProject());
            md = this.garModuleDelegates.get(module);
        }
        return md;
    }
}

