/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.launchConfig;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.JavaLaunchDelegate;

public class CoherenceLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    public static final String COHERENCE_SYSTEM_PROPERTIES = "coherence.system.properties";
    public static final String COHERENCE_VALUES = "coherence.values";

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmArguments = super.getVMArguments(configuration);
        HashMap<String, String> argumentMap = new HashMap<String, String>();
        Map systemProperties = configuration.getAttribute(COHERENCE_SYSTEM_PROPERTIES, null);
        Map values = configuration.getAttribute(COHERENCE_VALUES, null);
        if (systemProperties != null && values != null) {
            for (Map.Entry entry : systemProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (!values.containsKey(key)) continue;
                String systemProperty = (String)entry.getValue();
                String value = (String)values.get(key);
                if (systemProperty == null || value == null) continue;
                int index = vmArguments.indexOf("-D" + systemProperty);
                if (index >= 0) {
                    vmArguments = this.replaceString(vmArguments, value, index + 3 + systemProperty.length());
                    continue;
                }
                argumentMap.put(systemProperty, value);
            }
        }
        StringBuffer buf = new StringBuffer(vmArguments);
        for (Map.Entry entry : argumentMap.entrySet()) {
            buf.append(" -D");
            buf.append((String)entry.getKey());
            buf.append("=");
            this.appendValue(buf, (String)entry.getValue());
        }
        return buf.toString();
    }

    private String replaceString(String str, String value, int index) {
        StringBuffer buf = new StringBuffer();
        buf.append(str.substring(0, index));
        this.appendValue(buf, value);
        int endIndex = str.indexOf(32, index);
        if (endIndex > 0) {
            buf.append(str.substring(endIndex));
        }
        return buf.toString();
    }

    private void appendValue(StringBuffer buf, String value) {
        boolean hasSpace;
        boolean bl = hasSpace = value.indexOf(32) > 0;
        if (hasSpace) {
            buf.append("\"");
        }
        buf.append(value);
        if (hasSpace) {
            buf.append("\"");
        }
    }
}

