/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.internal;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.coherence.facets.CoherenceFacet;
import oracle.eclipse.tools.coherence.internal.CoherencePlugin;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;
import org.osgi.framework.Bundle;

public class CoherenceURIResolverExtension
implements URIResolverExtension {
    private static final String COHRENCE_VERSION_STR = "<!--coherence-version:";
    private static final String COHRENCE_VERSION_STR_END = "-->";
    private static final List<String> systemIds = CoherenceURIResolverExtension.initializeSystemIds();

    private static List<String> initializeSystemIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("cache-config.dtd");
        list.add("coherence.dtd");
        list.add("pof-config.dtd");
        list.add("coherence-cache-config.xsd");
        list.add("coherence-cache-config-base.xsd");
        list.add("coherence-config-base.xsd");
        list.add("coherence-operational-config.xsd");
        list.add("coherence-operational-config-base.xsd");
        return list;
    }

    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        if (file != null && systemId != null) {
            IPath path;
            if (systemIds.contains(systemId)) {
                IProject project = file.getProject();
                URI uri = this.resolve(project, systemId);
                if (uri != null) {
                    return uri.toString();
                }
            } else if (systemId.equals("coherence-override.dtd") && (path = this.getCoherenceOverridePath(file)) != null) {
                URL url = FileLocator.find((Bundle)CoherencePlugin.getPluginBundle(), (IPath)path, null);
                return url.toString();
            }
        }
        return null;
    }

    private IPath getCoherenceOverridePath(IFile file) {
        String version = this.getCoherenceVersion(file);
        if (version != null) {
            if (version.startsWith("3.5")) {
                return new Path("descriptor.schemas/dtd/3.5/coherence-override.dtd");
            }
            if (version.startsWith("3.6")) {
                return new Path("descriptor.schemas/dtd/3.6/coherence-override.dtd");
            }
        }
        return null;
    }

    private String getCoherenceVersion(IFile file) {
        try {
            int endIndex;
            String content = FileUtil.readFile((InputStream)file.getContents());
            int index = content.indexOf(COHRENCE_VERSION_STR);
            if (index > 0 && (endIndex = content.indexOf(COHRENCE_VERSION_STR_END, index)) > index) {
                return content.substring(index + COHRENCE_VERSION_STR.length(), endIndex);
            }
        }
        catch (Exception e) {
            LoggingService.logException((String)"oracle.eclipse.tools.coherence", (Throwable)e);
        }
        IProject proj = file.getProject();
        IProjectFacetVersion version = CoherenceFacet.getProjectFacet(proj);
        if (version != null) {
            return version.getVersionString();
        }
        return null;
    }

    public URI resolve(IProject project, String systemId) {
        IJavaProject jproj = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] iClasspathEntryArray = jproj.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = entry.getPath();
                if (path.lastSegment().endsWith("coherence.jar")) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = root.findMember(path);
                    File f = resource == null ? path.toFile() : resource.getLocation().toFile();
                    Path entryPath = new Path(systemId);
                    return URIUtil.toJarURI((URI)f.toURI(), (IPath)entryPath);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            LoggingService.logError((String)"oracle.eclipse.tools.coherence", (String)Resources.error);
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String error;

        static {
            Resources.initializeMessages((String)CoherenceURIResolverExtension.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

