/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.facets.internal;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.coherence.descriptors.CoherenceDescriptorsFactory;
import oracle.eclipse.tools.coherence.descriptors.application.ICoherenceApplication;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class GarFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    static final String NEW_LINE = System.getProperty("line.separator");

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel model = (IDataModel)cfg;
            WtpUtils.addNatures((IProject)project);
            IPath srcPath = null;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        srcPath = entry.getPath();
                        break;
                    }
                    ++n2;
                }
            }
            if (srcPath != null) {
                try {
                    IPath filePath = srcPath.append("META-INF/coherence-application.xml");
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                    ICoherenceApplication coherenceApplication = CoherenceDescriptorsFactory.getCoherenceApplication(file);
                    ((XmlResource)coherenceApplication.adapt(XmlResource.class)).getXmlElement(true);
                    IPath cacheConfigPath = srcPath.append("/coherence-cache-config.xml");
                    IFile cacheConfigFile = ResourcesPlugin.getWorkspace().getRoot().getFile(cacheConfigPath);
                    if (cacheConfigFile.exists()) {
                        coherenceApplication.getCacheConfiguration().setCacheConfigurationRef("/coherence-cache-config.xml");
                    }
                    IPath pofConfigPath = srcPath.append("/pof-config.xml");
                    IFile pofConfigFile = ResourcesPlugin.getWorkspace().getRoot().getFile(pofConfigPath);
                    if (pofConfigFile.exists()) {
                        coherenceApplication.getPofConfiguration().setPofConfigurationRef("/pof-config.xml");
                    }
                    coherenceApplication.resource().save();
                }
                catch (ResourceStoreException e) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
                }
            }
            IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
            c.create(0, null);
            IVirtualFolder jsrc = c.getRootFolder();
            IJavaProject jproj = JavaCore.create((IProject)project);
            IClasspathEntry[] cp = jproj.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3) {
                    IPath path = cpe.getPath().removeFirstSegments(1);
                    if (path.isEmpty()) {
                        path = new Path("/");
                    }
                    jsrc.createLink(path, 0, null);
                }
                ++i;
            }
            IVirtualFolder root = c.getRootFolder();
            Object container = null;
            container = root.getProjectRelativePath().segmentCount() == 0 ? project : project.getFolder(root.getProjectRelativePath());
            try {
                if (container != null) {
                    this.createManifest(project, (IContainer)container, monitor);
                }
            }
            catch (InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
            }
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            if (model.getBooleanProperty("IJ2EEModuleFacetInstallDataModelProperties.INSTALL_EAR_LIBRARY")) {
                Path earLibContainer = new Path("org.eclipse.jst.j2ee.internal.module.container");
                GarFacetInstallDelegate.addToClasspath((IJavaProject)jproj, (IClasspathEntry)JavaCore.newContainerEntry((IPath)earLibContainer));
            }
            IFolder libsFolder = project.getFolder("lib");
            libsFolder.create(true, true, monitor);
            IVirtualFolder libs = c.getRootFolder().getFolder("lib");
            libs.createLink((IPath)new Path("/lib"), 0, monitor);
            Path garLibContainer = new Path("oracle.eclipse.tools.coherence.gar.libs.container");
            IClasspathEntry libCPEntry = JavaCore.newContainerEntry((IPath)garLibContainer, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, null, (boolean)true);
            GarFacetInstallDelegate.addToClasspath((IJavaProject)jproj, (IClasspathEntry)libCPEntry);
            try {
                ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
            }
            catch (ExecutionException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

