/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.facets.internal;

import java.io.File;
import java.io.IOException;
import oracle.eclipse.tools.coherence.CoherenceVersion;
import oracle.eclipse.tools.coherence.descriptors.PofConfigInfo;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.CacheConfigFactory;
import oracle.eclipse.tools.coherence.descriptors.override.CoherenceOverrideFactory;
import oracle.eclipse.tools.coherence.descriptors.override.ICoherenceOverride;
import oracle.eclipse.tools.coherence.internal.CoherencePlugin;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CoherenceFacetVersionChangeDelegate
implements IDelegate {
    private static final String POF_CONFIG = "<pof-config";
    private static final String END = ">";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)1);
        try {
            boolean is37;
            LibraryFacetInstallConfig cfg = (LibraryFacetInstallConfig)config;
            cfg.getLibraryInstallDelegate().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            ICoherenceOverride descriptor = CoherenceOverrideFactory.getCoherenceOverride(project);
            Version versionEx = new Version(fv.getVersionString());
            descriptor.setVersion(versionEx);
            try {
                descriptor.resource().save();
                descriptor.refresh();
            }
            catch (ResourceStoreException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
            }
            IPath srcPath = null;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        srcPath = entry.getPath();
                        break;
                    }
                    ++n2;
                }
            }
            ICoherenceCacheConfig cacheConfig = CacheConfigFactory.getCoherenceCacheConfig(project);
            cacheConfig.setVersion(versionEx);
            try {
                cacheConfig.resource().save();
                cacheConfig.refresh();
            }
            catch (ResourceStoreException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
            }
            boolean bl = is37 = versionEx.compareTo(CoherenceVersion.VERSION_3_7) >= 0;
            if (srcPath != null) {
                IPath pofConfig = srcPath.append("pof-config.xml");
                IFile pofConfigFile = ResourcesPlugin.getWorkspace().getRoot().getFile(pofConfig);
                if (pofConfigFile.exists()) {
                    File f = pofConfigFile.getLocation().toFile();
                    try {
                        String content = FileUtil.readTextFile((File)f);
                        if (is37) {
                            int startConfig;
                            if (content.indexOf("http://xmlns.oracle.com/coherence/coherence-pof-config") < 0 && (startConfig = content.indexOf(POF_CONFIG)) > 0) {
                                StringBuffer buf = new StringBuffer();
                                buf.append(PofConfigInfo.getHeader(versionEx));
                                buf.append(content.substring(startConfig + POF_CONFIG.length() + 1, content.length()));
                                FileUtil.writeTextFile((File)f, (String)buf.toString());
                                pofConfigFile.refreshLocal(0, monitor);
                            }
                        } else if (content.indexOf("<!DOCTYPE") < 0) {
                            int startConfig = content.indexOf(POF_CONFIG);
                            int endConfig = content.indexOf(END, startConfig);
                            if (startConfig > 0 && endConfig > 0) {
                                StringBuffer buf = new StringBuffer();
                                buf.append(PofConfigInfo.getHeader(versionEx));
                                buf.append(content.substring(endConfig + 1, content.length()));
                                FileUtil.writeTextFile((File)f, (String)buf.toString());
                                pofConfigFile.refreshLocal(0, monitor);
                            }
                        }
                    }
                    catch (IOException e) {
                        CoherencePlugin.log(e);
                    }
                }
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }
}

