/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.facets.internal;

import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.CompoundOperationExecutor;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetUninstallConfig;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CoherenceFacetUninstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)2);
        try {
            LibraryFacetUninstallConfig cfg = (LibraryFacetUninstallConfig)config;
            cfg.getLibraryUninstallDelegate().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            CompoundOperation op = new CompoundOperation(fv.getProjectFacet().getLabel());
            CoherenceFacetUninstallDelegate.addDeleteFileOp((ICompoundOperation)op, project, "tangosol-coherence-override.xml");
            CoherenceFacetUninstallDelegate.addDeleteFileOp((ICompoundOperation)op, project, "coherence-cache-config.xml");
            CoherenceFacetUninstallDelegate.addDeleteFileOp((ICompoundOperation)op, project, "pof-config.xml");
            if (!op.getOperationList().isEmpty()) {
                CompoundOperationExecutor.executeWithPrompt((IProgressMonitor)new NullProgressMonitor(), (ICompoundOperation)op);
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static void addDeleteFileOp(ICompoundOperation op, IProject project, String path) throws CoreException {
        IFile f = CoherenceFacetUninstallDelegate.findOnJavaSourcePath(project, path);
        if (f != null) {
            op.add((IOperation)new DeleteFileOperation(f, true));
        }
    }

    private static IFile findOnJavaSourcePath(IProject project, String path) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (file = project.getFolder(entry.getPath().removeFirstSegments(1)).getFile(path)).isAccessible()) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }
}

