/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.facets.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import oracle.eclipse.tools.coherence.CoherenceVersion;
import oracle.eclipse.tools.coherence.descriptors.PofConfigInfo;
import oracle.eclipse.tools.coherence.descriptors.override.CoherenceOverrideFactory;
import oracle.eclipse.tools.coherence.descriptors.override.ICoherenceOverride;
import oracle.eclipse.tools.coherence.facets.internal.CoherenceFacetInstallConfig;
import oracle.eclipse.tools.coherence.syslib.internal.CoherenceClasspathContainer;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CoherenceFacetInstallDelegate
implements IDelegate {
    static final String NEW_LINE = System.getProperty("line.separator");

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)1);
        try {
            try {
                Boolean isCreatePOFConfig;
                Boolean isCreateOperationalConfig;
                CoherenceFacetInstallConfig cfg = (CoherenceFacetInstallConfig)((Object)config);
                cfg.getLibraryInstallDelegate().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                IPath srcPath = null;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject != null) {
                    IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3) {
                            srcPath = entry.getPath();
                            break;
                        }
                        ++n2;
                    }
                }
                if ((isCreateOperationalConfig = (Boolean)cfg.getProperty("PROP_CREATE_OPERATIONAL_CONFIG")).booleanValue()) {
                    IPath filePath = srcPath.append("tangosol-coherence-override.xml");
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                    ICoherenceOverride override = CoherenceOverrideFactory.getCoherenceOverride(file);
                    override.setVersion(fv.getVersionString());
                    override.resource().save();
                }
                Version versionEx = new Version(fv.getVersionString());
                Boolean isCreateCacheConfig = (Boolean)cfg.getProperty("PROP_CREATE_CACHE_CONFIG");
                if (isCreateCacheConfig.booleanValue()) {
                    IPath filePath = srcPath.append("coherence-cache-config.xml");
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                    String text = this.getCacheConfigXml(project, versionEx);
                    InputStream source = this.createXMLDocument(text);
                    if (!file.exists()) {
                        file.create(source, 1, monitor);
                    }
                }
                if ((isCreatePOFConfig = (Boolean)cfg.getProperty("PROP_CREATE_POF_CONFIG")).booleanValue()) {
                    IPath filePath = srcPath.append("pof-config.xml");
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                    String text = PofConfigInfo.getContent(CoherenceVersion.major(versionEx));
                    InputStream source = this.createXMLDocument(text);
                    if (!file.exists()) {
                        file.create(source, 1, monitor);
                    }
                }
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
            }
            catch (ResourceStoreException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.coherence", 0, e.getMessage(), (Throwable)e));
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private InputStream createXMLDocument(String content) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
        writer.println(content);
        writer.flush();
        outputStream.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    /*
     * Exception decompiling
     */
    private String getCacheConfigXml(IProject project, Version versionEx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getCoherenceJar(IProject project, Version versionEx) {
        IJavaProject jproj = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = jproj.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = entry.getPath();
                if (path.lastSegment().endsWith("coherence.jar")) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = root.findMember(path);
                    if (resource == null) {
                        return path.toFile();
                    }
                    return resource.getLocation().toFile();
                }
                ++n2;
            }
            IClasspathEntry[] iClasspathEntryArray2 = entries = CoherenceClasspathContainer.getClasspathEntry(jproj, versionEx.toString());
            int n3 = entries.length;
            n = 0;
            while (n < n3) {
                IClasspathEntry entry = iClasspathEntryArray2[n];
                IPath path = entry.getPath();
                if (path.lastSegment().endsWith("coherence.jar")) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = root.findMember(path);
                    if (resource == null) {
                        return path.toFile();
                    }
                    return resource.getLocation().toFile();
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)((Object)e));
        }
        return null;
    }
}

