/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.Set;
import oracle.eclipse.tools.coherence.descriptors.override.CoherenceOverrideService;
import oracle.eclipse.tools.coherence.descriptors.override.IClusterConfig;
import oracle.eclipse.tools.coherence.descriptors.override.IClusterSocketProvider;
import oracle.eclipse.tools.coherence.descriptors.override.ICoherenceOverride;
import oracle.eclipse.tools.common.util.DomUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.w3c.dom.Element;

public class SocketProviderValuesProvider
extends PossibleValuesService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SocketProviderValuesProvider.this.broadcast();
            }
        };
        ((ICoherenceOverride)this.context(ICoherenceOverride.class)).attach(this.listener, "/ClusterConfig/SocketProviders/Id");
    }

    public void dispose() {
        super.dispose();
        ((ICoherenceOverride)this.context(ICoherenceOverride.class)).detach(this.listener, "/ClusterConfig/SocketProviders/Id");
    }

    protected void fillPossibleValues(Set<String> values) {
        org.eclipse.sapphire.Element descriptor = ((org.eclipse.sapphire.Element)this.context(org.eclipse.sapphire.Element.class)).root();
        IProject project = (IProject)descriptor.adapt(IProject.class);
        Element baseParent = CoherenceOverrideService.getElement(project, "cluster-config/socket-providers");
        if (baseParent != null) {
            for (Element baseElement : DomUtil.elements((Element)baseParent)) {
                values.add(baseElement.getAttribute("id"));
            }
        }
        if (descriptor instanceof ICoherenceOverride) {
            ICoherenceOverride override = (ICoherenceOverride)descriptor;
            IClusterConfig clusterConfig = override.getClusterConfig();
            for (IClusterSocketProvider filter : clusterConfig.getSocketProviders()) {
                String name = filter.getId().text();
                if (name == null || name.length() <= 0 || values.contains(name)) continue;
                values.add(name);
            }
        }
    }
}

