/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import oracle.eclipse.tools.coherence.descriptors.override.ISocketAddress;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemInitParamController;
import oracle.eclipse.tools.coherence.descriptors.override.internal.SocketAddressResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;

public class SocketAddressesListController
extends ListItemInitParamController {
    private static final String PARENT_PATH = "cluster-config/unicast-listener/well-known-addresses";
    private static final String ELEMENT_PATH = "well-known-addresses";
    private static final String PATH = "socket-address";
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(ISocketAddress.TYPE);
    private static final XmlPath ELEMENT_XML_PATH = new XmlPath("well-known-addresses", (XmlNamespaceResolver)NAMESPACE_RESOLVER);

    public SocketAddressesListController() {
        super(PATH);
    }

    @Override
    protected String getParentPath() {
        return PARENT_PATH;
    }

    @Override
    protected String getElementPath() {
        return ELEMENT_PATH;
    }

    @Override
    protected XmlPath getElementXmlPath() {
        return ELEMENT_XML_PATH;
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    @Override
    protected Resource resource(Object obj) {
        ListItem item = (ListItem)obj;
        XmlResource parentResource = (XmlResource)this.property().element().resource();
        return new SocketAddressResource(parentResource, item);
    }

    @Override
    public ElementType type(Resource resource) {
        return ISocketAddress.TYPE;
    }

    @Override
    protected void swap(Resource a, Resource b) {
        SocketAddressResource saA = (SocketAddressResource)a;
        SocketAddressResource saB = (SocketAddressResource)b;
        if (saA.getXmlElement() != null || saB.getXmlElement() != null) {
            ListItem listItemA = saA.getListItem();
            ListItem listItemB = saB.getListItem();
            this.removeListItemCache(listItemA);
            this.removeListItemCache(listItemB);
            String addressA = saA.binding(ISocketAddress.PROP_ADDRESS).read();
            String portA = saA.binding(ISocketAddress.PROP_PORT).read();
            String addressB = saB.binding(ISocketAddress.PROP_ADDRESS).read();
            String portB = saB.binding(ISocketAddress.PROP_PORT).read();
            saA.binding(ISocketAddress.PROP_ADDRESS).write(addressB);
            saA.binding(ISocketAddress.PROP_PORT).write(portB);
            saB.binding(ISocketAddress.PROP_ADDRESS).write(addressA);
            saB.binding(ISocketAddress.PROP_PORT).write(portA);
            Element elementSaved = listItemB.getBaseElement();
            listItemB.setBaseElement(listItemA.getBaseElement());
            listItemA.setBaseElement(elementSaved);
            XmlElement xmlElementSaved = listItemB.getXmlElement();
            listItemB.setXmlElement(listItemA.getXmlElement());
            listItemA.setXmlElement(xmlElementSaved);
            this.resetListItemMerge(listItemA, listItemA);
            this.resetListItemMerge(listItemB, listItemB);
        }
    }
}

