/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.override.ISerializer;
import oracle.eclipse.tools.coherence.descriptors.override.ISerializerGeneric;
import oracle.eclipse.tools.coherence.descriptors.override.ISerializerJava;
import oracle.eclipse.tools.coherence.descriptors.override.ISerializerPof;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemsController;
import oracle.eclipse.tools.coherence.descriptors.override.internal.SerializerGenericResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.SerializerJavaResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.SerializerPofResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;

public class SerializersListController
extends ListItemsController {
    static final String PARENT_PATH = "cluster-config/serializers";
    private static final String ELEMENT_PATH = "serializers";
    private static final String PATH = "serializer";
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(ISerializer.TYPE);
    private static final XmlPath ELEMENT_XML_PATH = new XmlPath("serializers", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    public static final Map<ElementType, String> TYPE_TO_ID;
    private List<String> ids;

    static {
        HashMap<ElementType, String> map = new HashMap<ElementType, String>();
        map.put(ISerializerJava.TYPE, "java");
        map.put(ISerializerPof.TYPE, "pof");
        TYPE_TO_ID = Collections.unmodifiableMap(map);
    }

    public SerializersListController() {
        super(PATH);
    }

    protected Resource resource(Object obj) {
        ListItem item = (ListItem)obj;
        XmlResource parentResource = (XmlResource)this.property().element().resource();
        if (item.getBaseElement() != null) {
            Element elem = item.getBaseElement();
            String id = elem.getAttribute("id");
            if ("java".equals(id)) {
                return new SerializerJavaResource(parentResource, item);
            }
            if ("pof".equals(id)) {
                return new SerializerPofResource(parentResource, item);
            }
        }
        return new SerializerGenericResource(parentResource, item);
    }

    public ElementType type(Resource resource) {
        if (resource instanceof SerializerJavaResource) {
            return ISerializerJava.TYPE;
        }
        if (resource instanceof SerializerPofResource) {
            return ISerializerPof.TYPE;
        }
        return ISerializerGeneric.TYPE;
    }

    @Override
    protected String getParentPath() {
        return PARENT_PATH;
    }

    @Override
    protected String getElementPath() {
        return ELEMENT_PATH;
    }

    @Override
    protected XmlPath getElementXmlPath() {
        return ELEMENT_XML_PATH;
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    @Override
    protected String typeToId(ElementType type) {
        return TYPE_TO_ID.get(type);
    }

    @Override
    protected String getMaxId() {
        return null;
    }

    @Override
    protected List<String> getIds() {
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
            List<Element> list = this.getBaseElements();
            for (Element baseElement : list) {
                this.ids.add(baseElement.getAttribute("id"));
            }
        }
        return this.ids;
    }
}

