/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OverrideDomUtil {
    public static final String ID = "id";
    public static final String PARAM_NAME = "param-name";

    public static String getText(Element el, String path) {
        Element elem = OverrideDomUtil.getChildElement(el, path);
        if (elem != null) {
            String text = DomUtil.text((Node)elem);
            return text == null ? null : text.trim();
        }
        return null;
    }

    public static void setText(XmlElement el, String path, String text) {
        XmlElement child = OverrideDomUtil.getChildElement(el, path, true);
        if (child != null) {
            child.setText(text);
        }
    }

    public static Element getChildElement(Element el, String path) {
        Element elem = el;
        for (String token : OverrideDomUtil.splitPath(path)) {
            int index = token.indexOf(40);
            String id = null;
            if (index > 0) {
                int endIndex = token.indexOf(41);
                id = token.substring(index + 1, endIndex);
                token = token.substring(0, index);
            }
            if ((elem = OverrideDomUtil.element(elem, token, id)) == null) break;
        }
        return elem;
    }

    public static XmlElement getChildElement(XmlElement el, String path, boolean createIfNecessary) {
        XmlElement child = el;
        for (String token : OverrideDomUtil.splitPath(path)) {
            int index = token.indexOf(40);
            String id = null;
            if (index > 0) {
                int endIndex = token.indexOf(41);
                id = token.substring(index + 1, endIndex);
                token = token.substring(0, index);
            }
            if ((child = OverrideDomUtil.getChildElement(child, token, id, createIfNecessary)) != null) continue;
            return null;
        }
        return child;
    }

    private static List<String> splitPath(String path) {
        ArrayList<String> parts = new ArrayList<String>();
        String initPart = null;
        for (String token : StringUtil.split((String)path, (char)'/')) {
            int startIndex = token.indexOf(40);
            int endIndex = token.indexOf(41);
            if (startIndex > 0 && endIndex > 0 || startIndex < 0 && endIndex < 0) {
                parts.add(token);
                continue;
            }
            if (startIndex > 0) {
                initPart = token;
                continue;
            }
            if (endIndex <= 0 || initPart == null) continue;
            StringBuffer buf = new StringBuffer();
            buf.append(initPart);
            buf.append('/');
            buf.append(token);
            parts.add(buf.toString());
            initPart = null;
        }
        return parts;
    }

    private static XmlElement getChildElement(XmlElement el, String name, String id, boolean createIfNecessary) {
        if (id == null) {
            return el.getChildElement(name, createIfNecessary);
        }
        for (XmlElement element : el.getChildElements(name)) {
            XmlElement paramElem;
            String paramValue;
            if (id.equals(element.getAttributeText(ID))) {
                return element;
            }
            int index = id.indexOf(",");
            if (index <= 0 || !(paramValue = id.substring(index + 1)).equals(OverrideDomUtil.getElementText(paramElem = element.getChildElement(PARAM_NAME, false)))) continue;
            return element;
        }
        if (createIfNecessary) {
            XmlElement child = OverrideDomUtil.insertChildElement(el, name, id);
            child.setAttributeText(ID, OverrideDomUtil.getMaxId(el, name, id), true);
            return child;
        }
        return null;
    }

    private static String getElementText(XmlElement elem) {
        if (elem != null && elem.getText() != null) {
            return elem.getText().trim();
        }
        return null;
    }

    private static String getMaxId(XmlElement el, String name, String id) {
        int maxId = 0;
        int index = id.indexOf(",");
        if (index < 0) {
            return id;
        }
        maxId = Integer.parseInt(id.substring(0, index));
        for (XmlElement element : el.getChildElements(name)) {
            String elementId = element.getAttributeText(ID);
            if (elementId == null || elementId.length() <= 0) continue;
            try {
                maxId = Math.max(maxId, Integer.parseInt(elementId) + 1);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Integer.toString(maxId);
    }

    private static Element element(Element el, String name, String id) {
        NodeList nodes = el.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && DomUtil.basename((String)node.getNodeName()).equals(name)) {
                if (id != null) {
                    if (id.equals(((Element)node).getAttribute(ID))) {
                        return (Element)node;
                    }
                    int index = id.indexOf(",");
                    if (index >= 0) {
                        String paramValue = id.substring(index + 1);
                        Element paramElem = DomUtil.element((Element)((Element)node), (String)PARAM_NAME);
                        if (paramElem != null && paramValue.equals(DomUtil.text((Node)paramElem).trim())) {
                            return (Element)node;
                        }
                    }
                } else {
                    return (Element)node;
                }
            }
            ++i;
        }
        return null;
    }

    public static XmlElement insertChildElement(XmlElement parent, String path, String id) {
        return OverrideDomUtil.insertChildElement(parent, path, id, null);
    }

    public static XmlElement insertChildElement(XmlElement parent, String path, String id, List<String> idList) {
        String namespace = parent.getDomNode().getNamespaceURI();
        QName name = new QName(namespace, path);
        Document document = parent.getDomNode().getOwnerDocument();
        NodeList nodes = parent.getDomNode().getChildNodes();
        Node refChild = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                Attr attr = ((Element)node).getAttributeNode(ID);
                String id2 = "";
                if (attr != null) {
                    id2 = attr.getValue();
                }
                if (idList == null) {
                    if (OverrideDomUtil.compare(id, id2) < 0) {
                        refChild = node;
                        break;
                    }
                } else if (OverrideDomUtil.insertBefore(id, id2, idList)) {
                    refChild = node;
                    break;
                }
            }
            ++i;
        }
        assert (namespace == null || namespace.length() == 0);
        Element element = document.createElementNS(null, name.getLocalPart());
        parent.getDomNode().insertBefore(element, refChild);
        XmlElement wrappedElement = new XmlElement(parent, element);
        if (parent.getDomNode().getNodeType() == 1 && parent.getDomNode().getChildNodes().getLength() >= 1) {
            parent.format();
        } else {
            wrappedElement.format();
        }
        return wrappedElement;
    }

    private static int compare(String str1, String str2) {
        if (str1 != null && str2 != null) {
            try {
                Integer int1 = Integer.valueOf(str1);
                Integer int2 = Integer.valueOf(str2);
                return int1.compareTo(int2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    private static boolean insertBefore(String str1, String str2, List<String> idList) {
        boolean found = false;
        for (String id : idList) {
            if (found) {
                return true;
            }
            if (id.equals(str1)) {
                found = true;
                continue;
            }
            if (!id.equals(str2)) continue;
            return false;
        }
        return found;
    }
}

