/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.override.IMBean;
import oracle.eclipse.tools.coherence.descriptors.override.IMBeanDiscovery;
import oracle.eclipse.tools.coherence.descriptors.override.IMBeanGeneric;
import oracle.eclipse.tools.coherence.descriptors.override.IMBeanJmx;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemsController;
import oracle.eclipse.tools.coherence.descriptors.override.internal.MBeanDiscoveryResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.MBeanGenericResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.MBeanJmxResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;

public class MBeansListController
extends ListItemsController {
    public static final String PARENT_PATH = "management-config/mbeans";
    private static final String ELEMENT_PATH = "mbeans";
    private static final String PATH = "mbean";
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(IMBean.TYPE);
    private static final XmlPath ELEMENT_XML_PATH = new XmlPath("mbeans", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    public static final Map<ElementType, String> TYPE_TO_ID;

    static {
        HashMap<ElementType, String> map = new HashMap<ElementType, String>();
        map.put(IMBeanJmx.TYPE, "1");
        map.put(IMBeanDiscovery.TYPE, "2");
        TYPE_TO_ID = Collections.unmodifiableMap(map);
    }

    public MBeansListController() {
        super(PATH);
    }

    protected Resource resource(Object obj) {
        ListItem item = (ListItem)obj;
        XmlResource parentResource = (XmlResource)this.property().element().resource();
        if (item.getBaseElement() != null) {
            Element elem = item.getBaseElement();
            String id = elem.getAttribute("id");
            if ("1".equals(id)) {
                return new MBeanJmxResource(parentResource, item);
            }
            if ("2".equals(id)) {
                return new MBeanDiscoveryResource(parentResource, item);
            }
        }
        return new MBeanGenericResource(parentResource, item);
    }

    public ElementType type(Resource resource) {
        if (resource instanceof MBeanJmxResource) {
            return IMBeanJmx.TYPE;
        }
        if (resource instanceof MBeanDiscoveryResource) {
            return IMBeanDiscovery.TYPE;
        }
        return IMBeanGeneric.TYPE;
    }

    @Override
    protected String getParentPath() {
        return PARENT_PATH;
    }

    @Override
    protected String getElementPath() {
        return ELEMENT_PATH;
    }

    @Override
    protected XmlPath getElementXmlPath() {
        return ELEMENT_XML_PATH;
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    @Override
    protected String typeToId(ElementType type) {
        return TYPE_TO_ID.get(type);
    }
}

