/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.coherence.descriptors.override.IConfigurableCacheFactoryConfig;
import oracle.eclipse.tools.coherence.descriptors.override.IListItemInitParam;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemInitParamResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemsController;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.w3c.dom.Element;

public class ListItemInitParamController
extends ListItemsController {
    private static final String ELEMENT_PATH = "init-params";
    private static final String PATH = "init-param";
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(IConfigurableCacheFactoryConfig.TYPE);
    private static final XmlPath ELEMENT_XML_PATH = new XmlPath("init-params", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private String parentPath;

    public ListItemInitParamController() {
        super(PATH);
    }

    public ListItemInitParamController(String path) {
        super(path);
    }

    public void init(Property property) {
        String[] params;
        super.init(property);
        CustomXmlListBinding annotation = (CustomXmlListBinding)property.definition().getAnnotation(CustomXmlListBinding.class);
        if (annotation != null && (params = annotation.params()).length > 0) {
            this.parentPath = params[0];
        }
    }

    @Override
    protected String getParentPath() {
        return this.parentPath;
    }

    @Override
    protected String getElementPath() {
        return ELEMENT_PATH;
    }

    @Override
    protected XmlPath getElementXmlPath() {
        return ELEMENT_XML_PATH;
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    @Override
    protected String typeToId(ElementType type) {
        return null;
    }

    @Override
    protected List<?> readUnderlyingList() {
        ArrayList<ListItem> mergeList = new ArrayList<ListItem>();
        List<Element> list = this.getBaseElements();
        for (Element merge : list) {
            mergeList.add(new ListItem(merge));
        }
        XmlElement parent = this.getParentXmlElement(false);
        if (parent != null) {
            for (XmlElement element : parent.getChildElements()) {
                String elementName = element.getDomNode().getLocalName();
                if (!this.xmlElementNames.contains(elementName)) continue;
                ListItem item = this.findListItem(element, mergeList);
                if (item != null) {
                    item.setXmlElement(element);
                    continue;
                }
                mergeList.add(new ListItem(element));
            }
        }
        ArrayList<ListItem> underlyingList = new ArrayList<ListItem>();
        for (ListItem key : mergeList) {
            underlyingList.add(this.findListItemMerge(key));
        }
        return underlyingList;
    }

    private ListItem findListItem(XmlElement element, List<ListItem> mergeList) {
        String id = element.getAttributeText("id");
        for (ListItem item : mergeList) {
            if (!id.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    protected Resource resource(Object obj) {
        ListItem item = (ListItem)obj;
        XmlResource parentResource = (XmlResource)this.property().element().resource();
        return new ListItemInitParamResource(parentResource, item);
    }

    public ElementType type(Resource resource) {
        return IListItemInitParam.TYPE;
    }

    @Override
    protected void swap(Resource a, Resource b) {
        ListItemInitParamResource liA = (ListItemInitParamResource)a;
        ListItemInitParamResource liB = (ListItemInitParamResource)b;
        if (liA.getXmlElement() != null || liB.getXmlElement() != null) {
            ListItem listItemA = liA.getListItem();
            ListItem listItemB = liB.getListItem();
            this.removeListItemCache(listItemA);
            this.removeListItemCache(listItemB);
            String descriptionA = liA.binding(IListItemInitParam.PROP_DESCRIPTION).read();
            String paramNameA = liA.binding(IListItemInitParam.PROP_PARAM_NAME).read();
            String paramTypeA = liA.binding(IListItemInitParam.PROP_PARAM_TYPE).read();
            String paramValueA = liA.binding(IListItemInitParam.PROP_PARAM_VALUE).read();
            String descriptionB = liB.binding(IListItemInitParam.PROP_DESCRIPTION).read();
            String paramNameB = liB.binding(IListItemInitParam.PROP_PARAM_NAME).read();
            String paramTypeB = liB.binding(IListItemInitParam.PROP_PARAM_TYPE).read();
            String paramValueB = liB.binding(IListItemInitParam.PROP_PARAM_VALUE).read();
            liA.binding(IListItemInitParam.PROP_DESCRIPTION).write(descriptionB);
            liA.binding(IListItemInitParam.PROP_PARAM_NAME).write(paramNameB);
            liA.binding(IListItemInitParam.PROP_PARAM_TYPE).write(paramTypeB);
            liA.binding(IListItemInitParam.PROP_PARAM_VALUE).write(paramValueB);
            liB.binding(IListItemInitParam.PROP_DESCRIPTION).write(descriptionA);
            liB.binding(IListItemInitParam.PROP_PARAM_NAME).write(paramNameA);
            liB.binding(IListItemInitParam.PROP_PARAM_TYPE).write(paramTypeA);
            liB.binding(IListItemInitParam.PROP_PARAM_VALUE).write(paramValueA);
            Element elementSaved = listItemB.getBaseElement();
            listItemB.setBaseElement(listItemA.getBaseElement());
            listItemA.setBaseElement(elementSaved);
            XmlElement xmlElementSaved = listItemB.getXmlElement();
            listItemB.setXmlElement(listItemA.getXmlElement());
            listItemA.setXmlElement(xmlElementSaved);
            this.resetListItemMerge(listItemA, listItemA);
            this.resetListItemMerge(listItemB, listItemB);
        }
    }
}

