/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberWithUnit;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDomUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListItemHelper {
    private static final String PATH_INIT_PARAM = "init-params/init-param({0},{1})";
    private static final String PATH_INIT_PARAM_NAME = "init-params/init-param({0},{1})/param-name";
    private static final String PATH_INIT_PARAM_VALUE = "init-params/init-param({0},{1})/param-value";
    private static final String MAX_INDEX = "100";

    public static final void doRemove(org.eclipse.sapphire.Element modelElement, ListItem item) {
        XmlElement element = item.getXmlElement();
        if (element != null) {
            element.remove();
            item.setXmlElement(null);
            modelElement.refresh();
        }
    }

    public static final String readInitParamPathNumberWithUnit(ListItem item, String paramName, boolean isNumber) {
        String value = ListItemHelper.readInitParamPath(item, paramName);
        NumberWithUnit nu = NumberWithUnit.parse(value);
        if (isNumber) {
            return nu.getNumber();
        }
        return nu.getUnit();
    }

    private static final boolean isValidNumber(String value) {
        if (value == null) {
            return false;
        }
        BigDecimal number = BigDecimal.ZERO;
        try {
            number = new BigDecimal(value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return number.compareTo(BigDecimal.ZERO) > 0;
    }

    public static final void writeInitParamPathNumberWithUnit(org.eclipse.sapphire.Element modelElement, ListItem item, String text, String paramName, String parentPath, NumberWithUnit defaultNu, boolean isNumber) {
        String value = text;
        if (!isNumber || isNumber && ListItemHelper.isValidNumber(text)) {
            String oldValue = ListItemHelper.readInitParamPath(item, paramName);
            NumberWithUnit nu = NumberWithUnit.parse(oldValue);
            if (isNumber) {
                nu.setNumber(text);
            } else {
                nu.setUnit(text);
            }
            if (nu.getNumber() == null || nu.getUnit() == null) {
                nu.addDefault(defaultNu);
            }
            value = nu.toString();
        }
        ListItemHelper.writeInitParamPath(modelElement, item, value, paramName, parentPath);
    }

    public static final String readInitParamPath(ListItem item, String paramName) {
        String path = NLS.bind((String)PATH_INIT_PARAM_VALUE, (Object)"", (Object)paramName);
        return ListItemHelper.readPath(item, path);
    }

    public static final void writeInitParamPath(org.eclipse.sapphire.Element modelElement, ListItem item, String text, String paramName, String parentPath) {
        if (text == null || text.length() == 0) {
            XmlElement child;
            String path = NLS.bind((String)PATH_INIT_PARAM, (Object)MAX_INDEX, (Object)paramName);
            XmlElement xmlElement = ListItemHelper.getXmlElement(modelElement, item, parentPath, false);
            if (xmlElement != null && (child = OverrideDomUtil.getChildElement(xmlElement, path, false)) != null) {
                child.remove();
            }
        } else {
            String pathName = NLS.bind((String)PATH_INIT_PARAM_NAME, (Object)MAX_INDEX, (Object)paramName);
            String pathValue = NLS.bind((String)PATH_INIT_PARAM_VALUE, (Object)MAX_INDEX, (Object)paramName);
            if (ListItemHelper.readPath(item, pathName) == null) {
                ListItemHelper.writePath(modelElement, item, paramName, pathName, parentPath);
            }
            ListItemHelper.writePath(modelElement, item, text, pathValue, parentPath);
        }
    }

    public static final String readPath(ListItem item, String path) {
        XmlElement element = item.getXmlElement();
        if (element != null) {
            return OverrideDomUtil.getText(element.getDomNode(), path);
        }
        return null;
    }

    public static final String readPathNumberWithUnit(ListItem item, String path, boolean isNumber) {
        String value = ListItemHelper.readPath(item, path);
        if (value != null) {
            NumberWithUnit nu = NumberWithUnit.parse(value);
            if (isNumber) {
                return nu.getNumber();
            }
            return nu.getUnit();
        }
        return null;
    }

    public static final void writePath(org.eclipse.sapphire.Element modelElement, ListItem item, String text, String path, String parentPath) {
        if (text == null || text.length() == 0) {
            XmlElement xmlElement = ListItemHelper.getXmlElement(modelElement, item, parentPath, false);
            if (xmlElement != null) {
                XmlElement child = OverrideDomUtil.getChildElement(xmlElement, path, false);
                XmlElement parent = null;
                if (child != null) {
                    child.remove();
                    parent = child.getParent();
                }
                while (parent != null && !parent.equals((Object)xmlElement) && ListItemHelper.isEmpty(parent.getDomNode())) {
                    XmlElement empty = parent;
                    parent = parent.getParent();
                    empty.remove();
                }
            }
        } else {
            String attr;
            String systemProperty;
            Element pathBaseElement;
            Element baseElement;
            XmlElement child = ListItemHelper.getChildXmlElement(modelElement, item, path, parentPath, true);
            if (child != null) {
                child.setText(text);
            }
            if ((baseElement = item.getBaseElement()) != null && (pathBaseElement = OverrideDomUtil.getChildElement(baseElement, path)) != null && (systemProperty = pathBaseElement.getAttribute("system-property")) != null && systemProperty.length() > 0 && ((attr = child.getDomNode().getAttribute("system-property")) == null || attr.length() == 0)) {
                child.getDomNode().setAttribute("system-property", systemProperty);
            }
        }
    }

    public static final void writePathNumberWithUnit(org.eclipse.sapphire.Element modelElement, ListItem item, String text, String path, String parentPath, NumberWithUnit defaultNu, boolean isNumber) {
        String value = text;
        if (!isNumber || isNumber && ListItemHelper.isValidNumber(text)) {
            String oldValue = ListItemHelper.readPath(item, path);
            NumberWithUnit nu = NumberWithUnit.parse(oldValue);
            if (isNumber) {
                nu.setNumber(text);
            } else {
                nu.setUnit(text);
            }
            if (nu.getNumber() == null || nu.getUnit() == null) {
                nu.addDefault(defaultNu);
            }
            value = nu.toString();
        }
        ListItemHelper.writePath(modelElement, item, value, path, parentPath);
    }

    public static final XmlElement getXmlElement(org.eclipse.sapphire.Element modelElement, ListItem item, String parentPath, boolean createIfNecessary) {
        XmlElement element = item.getXmlElement();
        if (element == null) {
            element = ((XmlResource)modelElement.parent().element().resource()).getXmlElement(createIfNecessary);
            if (element != null) {
                element = OverrideDomUtil.getChildElement(element, parentPath, createIfNecessary);
            }
            item.setXmlElement(element);
        }
        return element;
    }

    public static final XmlElement getInitParamChildXmlElement(org.eclipse.sapphire.Element modelElement, ListItem item, String paramName, String parentPath, boolean createIfNecessary) {
        String pathValue = NLS.bind((String)PATH_INIT_PARAM_VALUE, (Object)100, (Object)paramName);
        return ListItemHelper.getChildXmlElement(modelElement, item, pathValue, parentPath, createIfNecessary);
    }

    public static final XmlElement getChildXmlElement(org.eclipse.sapphire.Element modelElement, ListItem item, String path, String parentPath, boolean createIfNecessary) {
        XmlElement xmlElement = ListItemHelper.getXmlElement(modelElement, item, parentPath, createIfNecessary);
        if (xmlElement != null) {
            return OverrideDomUtil.getChildElement(xmlElement, path, createIfNecessary);
        }
        return xmlElement;
    }

    private static final boolean isEmpty(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (child.getNodeType() != 3 || child.getNodeValue().trim().length() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

