/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.LeaseGranularity;
import oracle.eclipse.tools.coherence.descriptors.override.IService;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceTimeout;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

@Label(standard="replicated cache")
public interface IServiceReplicatedCache
extends IService,
IServiceTimeout {
    public static final ElementType TYPE = new ElementType(IServiceReplicatedCache.class);
    @NamedValues(arbitraryValueLabel="standard lease (msec)", defaultArbitraryValue="20000", namedValues={@NamedValues.NamedValue(value="0", label="lease never expire")})
    @Type(base=Long.class)
    @Label(standard="standard lease")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(1)/param-value")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the duration of the standard lease in milliseconds. Once a lease has aged past this number of milliseconds, the lock will automatically be released. Set this value to zero to specify a lease that never expires. The purpose of this setting is to avoid deadlocks or blocks caused by stuck threads; the value should be set higher than the longest expected lock duration (e.g. higher than a transaction timeout). It's also recommended to set this value higher then packet-delivery/timeout-milliseconds value.")
    public static final ValueProperty PROP_STANDARD_LEASE = new ValueProperty(TYPE, "StandardLease");
    @Type(base=LeaseGranularity.class)
    @Label(standard="lease granularity")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(2)/param-value")})
    @Documentation(content="Specifies the lease ownership granularity.[pbr/]Legal values are: [ul][li]thread: locks are held by a thread that obtained them and can only be released by that thread.[/li][li]member: locks are held by a cluster node and any thread running on the cluster node that obtained the lock can release it.[/li][/ul]")
    public static final ValueProperty PROP_LEASE_GRANULARITY = new ValueProperty(TYPE, "LeaseGranularity");
    @Type(base=Boolean.class)
    @Label(standard="mobile issues")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(3)/param-value")})
    @Documentation(content="Specifies whether or not the lease issues should be transfered to the most recent lock holders.")
    public static final ValueProperty PROP_MOBILE_ISSUES = new ValueProperty(TYPE, "MobileIssues");
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(4)/param-value")})
    @Documentation(content="The default client request timeout for the replicated cache service")
    public static final ValueProperty PROP_REQUEST_TIMEOUT = new ValueProperty(TYPE, IServiceTimeout.PROP_REQUEST_TIMEOUT);
    public static final ValueProperty PROP_REQUEST_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTimeout.PROP_REQUEST_TIMEOUT_UNIT);
    @Label(standard="serializer")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(5)/param-value")})
    public static final ValueProperty PROP_SERIALIZER = new ValueProperty(TYPE, "Serializer");
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(6)/param-value")})
    @Documentation(content="Specifies the guardian timeout value to use for guarding the service and any dependant threads. An explicitly specified timeout of 0 will prevent the service (and any dependant threads) from being guarded.")
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT = new ValueProperty(TYPE, IServiceTimeout.PROP_GUARDIAN_TIMEOUT);
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTimeout.PROP_GUARDIAN_TIMEOUT_UNIT);
    @Label(standard="service failure policy")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(7)/param-value")})
    @Since(value="3.6")
    public static final ValueProperty PROP_SERVICE_FAILURE_POLICY = new ValueProperty(TYPE, "ServiceFailurePolicy");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="member listener class")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(8)/param-value")})
    @Since(value="3.6")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.MemberListener"})
    @MustExist
    public static final ValueProperty PROP_MEMBER_LISTENER_CLASS_NAME = new ValueProperty(TYPE, "MemberListenerClassName");
    @Type(base=Integer.class)
    @Label(standard="service priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(9)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_SERVICE_PRIORITY = new ValueProperty(TYPE, "ServicePriority");
    @Type(base=Integer.class)
    @Label(standard="event dispatcher priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(10)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY = new ValueProperty(TYPE, "EventDispatcherPriority");
    @Label(standard="reliable transport")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(11)/param-value")})
    @Since(value="12.1.2")
    public static final ValueProperty PROP_RELIABLE_TRANSPORT = new ValueProperty(TYPE, "ReliableTransport");

    public Value<Long> getStandardLease();

    public void setStandardLease(String var1);

    public void setStandardLease(Long var1);

    public Value<LeaseGranularity> getLeaseGranularity();

    public void setLeaseGranularity(String var1);

    public void setLeaseGranularity(LeaseGranularity var1);

    public Value<Boolean> getMobileIssues();

    public void setMobileIssues(String var1);

    public void setMobileIssues(Boolean var1);

    public Value<String> getSerializer();

    public void setSerializer(String var1);

    public Value<String> getServiceFailurePolicy();

    public void setServiceFailurePolicy(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getMemberListenerClassName();

    public void setMemberListenerClassName(String var1);

    public void setMemberListenerClassName(JavaTypeName var1);

    public Value<Integer> getServicePriority();

    public void setServicePriority(String var1);

    public void setServicePriority(Integer var1);

    public Value<Integer> getEventDispatcherPriority();

    public void setEventDispatcherPriority(String var1);

    public void setEventDispatcherPriority(Integer var1);

    public Value<String> getReliableTransport();

    public void setReliableTransport(String var1);
}

