/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.BackupStorageType;
import oracle.eclipse.tools.coherence.descriptors.LeaseGranularity;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.PrimeNumberValidator;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.LocalStorage;
import oracle.eclipse.tools.coherence.descriptors.override.IService;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceTaskTimeout;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceTimeout;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;

@Label(standard="distributed cache")
public interface IServiceDistributedCache
extends IService,
IServiceTimeout,
IServiceTaskTimeout {
    public static final ElementType TYPE = new ElementType(IServiceDistributedCache.class);
    @NamedValues(arbitraryValueLabel="standard lease (msec)", defaultArbitraryValue="20000", namedValues={@NamedValues.NamedValue(value="0", label="lease never expire")})
    @Type(base=Long.class)
    @Label(standard="standard lease (msec)")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(1)/param-value")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the duration of the standard lease in milliseconds. Once a lease has aged past this number of milliseconds, the lock will automatically be released. Set this value to zero to specify a lease that never expires.")
    public static final ValueProperty PROP_STANDARD_LEASE = new ValueProperty(TYPE, "StandardLease");
    @Type(base=LeaseGranularity.class)
    @Label(standard="lease granularity")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(2)/param-value")})
    @Documentation(content="Specifies the lease ownership granularity.[pbr/]Legal values are: [ul][li]thread: locks are held by a thread that obtained them and can only be released by that thread.[/li][li]member: locks are held by a cluster node and any thread running on the cluster node that obtained the lock can release it.[/li][/ul]")
    public static final ValueProperty PROP_LEASE_GRANULARITY = new ValueProperty(TYPE, "LeaseGranularity");
    @Type(base=Integer.class)
    @Label(standard="partition count")
    @Services(value={@Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(3)/param-value")}), @Service(impl=PrimeNumberValidator.class)})
    @NumericRange(min="0")
    @Documentation(content="Specifies the number of partitions that a partitioned (distributed) cache will be \"chopped up\" into. Each member running the partitioned cache service that has the local-storage option set to true will manage a \"fair\" (balanced) number of partitions.[pbr/]The number of partitions should be a prime number and sufficiently large such that a given partition is expected to be no larger than 50MB in size.[pbr/]Good defaults for example service storage sizes are provided below: [pbr/][code]service storage   parition-count[br/]100M                   257[br/]1G                        509[br/]10G                      2039[br/]50G                      4093[br/]100G                    8191[/code]")
    public static final ValueProperty PROP_PARTITION_COUNT = new ValueProperty(TYPE, "PartitionCount");
    @Type(base=LocalStorage.class)
    @Label(standard="local storage")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(4)/param-value")})
    @Documentation(content="Specifies whether or not this member of the DistributedCache service enables the local storage. [pbr/]Normally this value should be left unspecified within the configuration file, and instead set on a per-process basis using the tangosol.coherence.distributed.localstorage  system property. This allows cache clients and servers to use the same configuration descriptor.")
    public static final ValueProperty PROP_LOCAL_STORAGE = new ValueProperty(TYPE, "LocalStorage");
    @Type(base=Integer.class)
    @Label(standard="transfer threshold")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(5)/param-value")})
    @NumericRange(min="1")
    @Documentation(content="Specifies the threshold for the primary buckets distribution in kilo-bytes. When a new node joins the distributed cache service or when a member of the service leaves, the remaining nodes perform a task of bucket ownership re-destribution. During this process, the existing data gets re-balanced along with the ownership information. This parameter indicates a preferred message size for data transfer communications. Setting this value lower will make the distribution process take longer, but will reduce network bandwidth utilization during this activity.")
    public static final ValueProperty PROP_TRANSFER_THRESHOLD = new ValueProperty(TYPE, "TransferThreshold");
    @Type(base=Integer.class)
    @Label(standard="backup count")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(6)/param-value")})
    @NumericRange(min="0", max="256")
    @Documentation(content="Specifies the number of members of the DistributedCache service that hold the backup data for each unit of storage in the cache.[pbr/]Value of 0 means that in the case of abnormal termination, some portion of the data in the cache will be lost. Value of N means that if up to N cluster nodes terminate at once, the cache data will be preserved.[pbr/]To maintain the distributed cache of size M, the total memory usage in the cluster does not depend on the number of cluster nodes and will be in the order of M*(N+1).[pbr/]Recommended values are 0, 1 or 2.")
    public static final ValueProperty PROP_BACKUP_COUNT = new ValueProperty(TYPE, "BackupCount");
    @Type(base=BackupStorageType.class)
    @Label(standard="backup storage type")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(7)/param-value")})
    @Documentation(content="Specifies the type of the storage used to hold the backup data.[pbr/]Legal values are: [ul][li]on-heap: The corresponding implementations class is java.util.HashMap.[/li][li]off-heap: The corresponding implementations class is com.tangosol.util.nio.BinaryMap using com.tangosol.util.nio.DirectBufferManager. Only available with JDK 1.4 and later.[/li][li]file-mapped: The corresponding implementations class is com.tangosol.util.nio.BinaryMap using com.tangosol.util.nio.MappedBufferManager. Only available with JDK 1.4 and later.[/li][li]custom: The corresponding implementations class is the class specified by the backup-storage/class element.[/li][li]scheme: The corresponding implementations class is the map returned by the ConfigurableCacheFactory for the scheme referred to by the backup-storage/scheme-name element.[/li][/ul]")
    public static final ValueProperty PROP_BACKUP_STORAGE_TYPE = new ValueProperty(TYPE, "BackupStorageType");
    @Type(base=Integer.class)
    @Label(standard="thread count")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(8)/param-value")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the number of daemon threads used by the distributed cache service.[pbr/]If zero, all relevant tasks are performed on the service thread.")
    public static final ValueProperty PROP_THREAD_COUNT = new ValueProperty(TYPE, "ThreadCount");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="key associator class")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(9)/param-value")})
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.partition.KeyAssociator"})
    @MustExist
    @Documentation(content="Specifies the name of a class that implements the com.tangosol.net.partition.KeyAssociator interface. This implementation must have a zero-parameter public constructor.")
    public static final ValueProperty PROP_KEY_ASSOCIATOR_CLASS_NAME = new ValueProperty(TYPE, "KeyAssociatorClassName");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="key partitioning class")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(10)/param-value")})
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.partition.KeyPartitioningStrategy"})
    @MustExist
    @Documentation(content="Specifies the name of a class that implements the com.tangosol.net.partition.KeyPartitioningStrategy interface. This implementation must have a zero-parameter public constructor.")
    public static final ValueProperty PROP_KEY_PARTITIONING_CLASS_NAME = new ValueProperty(TYPE, "KeyPartitioningClassName");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="partition listener class")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(11)/param-value")})
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.partition.PartitionListener"})
    @MustExist
    @Documentation(content="Specifies the name of a class that implements the com.tangosol.net.partition.PartitionListener interface. This implementation must have a zero-parameter public constructor.")
    public static final ValueProperty PROP_PARTITION_LISTENER_CLASS_NAME = new ValueProperty(TYPE, "PartitionListenerClassName");
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(12)/param-value")})
    @Enablement(expr="${ ThreadCount > 0 }")
    @Documentation(content="Specifies the amount of time in milliseconds that a task can execute before it is considered \"hung\". Note: a posted task that has not yet started is never considered as hung. This attribute is applied only if the Thread pool is used (the \"thread-count\" value is positive).")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_HUNG_THRESHOLD);
    @Enablement(expr="${ ThreadCount > 0 }")
    public static final ValueProperty PROP_TASK_HUNG_THRESHOLD_UNIT = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_HUNG_THRESHOLD_UNIT);
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(13)/param-value")})
    @Enablement(expr="${ ThreadCount > 0 }")
    @Documentation(content="Specifies the default timeout value in milliseconds for tasks that can be timed-out (e.g. implement the com.tangosol.net.PriorityTask interface), but don't explicitly specify the task execution timeout value. The task execution time is measured on the server side and does not include the time spent waiting in a service backlog queue before being started. This attribute is applied only if the thread pool is used (the \"thread-count\" value is positive).")
    public static final ValueProperty PROP_TASK_TIMEOUT = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_TIMEOUT);
    @Enablement(expr="${ ThreadCount > 0 }")
    public static final ValueProperty PROP_TASK_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTaskTimeout.PROP_TASK_TIMEOUT_UNIT);
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(14)/param-value")})
    @Documentation(content="Specifies the maximum amount of time a client will wait for a response before abandoning the original request. The request time is measured on the client side as the time elapsed from the moment a request is sent for execution to the corresponding server node(s) and includes the following: [ol][li]The time it takes to deliver the request to an executing node (server).[/li][li]The interval between the time the task is received and placed into a service queue until the execution starts.[/li][li]The task execution time.[/li][li]The time it takes to deliver a result back to the client.[/li][/ol]")
    public static final ValueProperty PROP_REQUEST_TIMEOUT = new ValueProperty(TYPE, IServiceTimeout.PROP_REQUEST_TIMEOUT);
    public static final ValueProperty PROP_REQUEST_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTimeout.PROP_REQUEST_TIMEOUT_UNIT);
    @Label(standard="serializer")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(15)/param-value")})
    public static final ValueProperty PROP_SERIALIZER = new ValueProperty(TYPE, "Serializer");
    @Type(base=Integer.class)
    @Label(standard="backup count after writebehind")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(16)/param-value")})
    @NumericRange(min="0")
    public static final ValueProperty PROP_BACKUP_COUNT_AFTER_WRITEBEHIND = new ValueProperty(TYPE, "BackupCountAfterWritebehind");
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(17)/param-value")})
    @Documentation(content="Specifies the guardian timeout value to use for guarding the service and any dependant threads. An explicitly specified timeout of 0 will prevent the service (and any dependant threads) from being guarded.")
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT = new ValueProperty(TYPE, IServiceTimeout.PROP_GUARDIAN_TIMEOUT);
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_UNIT = new ValueProperty(TYPE, IServiceTimeout.PROP_GUARDIAN_TIMEOUT_UNIT);
    @Label(standard="service failure policy")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(18)/param-value")})
    @Since(value="3.6")
    public static final ValueProperty PROP_SERVICE_FAILURE_POLICY = new ValueProperty(TYPE, "ServiceFailurePolicy");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="member listener class")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(19)/param-value")})
    @Since(value="3.6")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.MemberListener"})
    @MustExist
    public static final ValueProperty PROP_MEMBER_LISTENER_CLASS_NAME = new ValueProperty(TYPE, "MemberListenerClassName");
    @Label(standard="partitioned quorum policy scheme")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(20)/param-value")})
    @Since(value="3.6")
    public static final ValueProperty PROP_PARTITIONED_QUORUM_POLICY_SCHEME = new ValueProperty(TYPE, "PartitionedQuorumPolicyScheme");
    @Label(standard="partition assignment strategy")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(21)/param-value")})
    @Since(value="3.7")
    public static final ValueProperty PROP_PARTITION_ASSIGNMENT_STRATEGY = new ValueProperty(TYPE, "PartitionAssignmentStrategy");
    @Label(standard="compressor")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(22)/param-value")})
    @Since(value="3.7")
    public static final ValueProperty PROP_COMPRESSOR = new ValueProperty(TYPE, "Compressor");
    @Type(base=BigDecimal.class)
    @Label(standard="backup storage initial size")
    @DefaultValue(text="1")
    @NumericRange(min="1")
    @Enablement(expr="${ BackupStorageType == 'off-heap' || BackupStorageType == 'file-mapped' }")
    @Documentation(content="Only applicable with the off-heap and file-mapped types.[pbr/]Specifies the initial buffer size in bytes.")
    public static final ValueProperty PROP_BACKUP_STORAGE_INITIAL_SIZE = new ValueProperty(TYPE, "BackupStorageInitialSize");
    @Type(base=SizeUnit.class)
    @DefaultValue(text="MB")
    @Enablement(expr="${ BackupStorageType == 'off-heap' || BackupStorageType == 'file-mapped' }")
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="BackupStorageInitialSize")})
    public static final ValueProperty PROP_BACKUP_STORAGE_INITIAL_SIZE_UNIT = new ValueProperty(TYPE, "BackupStorageInitialSizeUnit");
    @Type(base=BigDecimal.class)
    @Label(standard="backup storage maximum size")
    @DefaultValue(text="1024")
    @NumericRange(min="1")
    @Enablement(expr="${ BackupStorageType == 'off-heap' || BackupStorageType == 'file-mapped' }")
    @Documentation(content="Only applicable with the off-heap and file-mapped types.[pbr/]Specifies the maximum buffer size in bytes.")
    public static final ValueProperty PROP_BACKUP_STORAGE_MAXIMUM_SIZE = new ValueProperty(TYPE, "BackupStorageMaximumSize");
    @Type(base=SizeUnit.class)
    @DefaultValue(text="MB")
    @Enablement(expr="${ BackupStorageType == 'off-heap' || BackupStorageType == 'file-mapped' }")
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="BackupStorageMaximumSize")})
    public static final ValueProperty PROP_BACKUP_STORAGE_MAXIMUM_SIZE_UNIT = new ValueProperty(TYPE, "BackupStorageMaximumSizeUnit");
    @Type(base=Path.class)
    @Label(standard="backup storage directory")
    @Enablement(expr="${ BackupStorageType == 'file-mapped' }")
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @AbsolutePath
    @Documentation(content="Only applicable with the file-mapped type.[pbr/]Specifies the pathname for the directory that the disk persistence manager (com.tangosol.util.nio.MappedBufferManager) will use as \"root\" to store files in. If not specified or specifies a non-existent directory, a temporary file in the default location is used.[pbr/]Default value is the default temporary directory designated by the Java runtime.")
    public static final ValueProperty PROP_BACKUP_STORAGE_DIRECTORY = new ValueProperty(TYPE, "BackupStorageDirectory");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="backup storage class")
    @Enablement(expr="${ BackupStorageType == 'custom' }")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.run.xml.XmlConfigurable"})
    @MustExist
    @Documentation(content="Only applicable with the custom type.[pbr/]Specifies a class name for the custom storage implementation. If the class implements com.tangosol.run.xml.XmlConfigurable interface then upon construction the setConfig method is called passing the entire backup-storage element.")
    public static final ValueProperty PROP_BACKUP_STORAGE_CLASS_NAME = new ValueProperty(TYPE, "BackupStorageClassName");
    @Label(standard="backup storage scheme name")
    @Enablement(expr="${ BackupStorageType == 'scheme' }")
    @Documentation(content="Only applicable with the scheme type.[pbr/]Specifies a scheme name for the ConfigurableCacheFactory.")
    public static final ValueProperty PROP_BACKUP_STORAGE_SCHEME_NAME = new ValueProperty(TYPE, "BackupStorageSchemeName");
    @Type(base=Integer.class)
    @Label(standard="service priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(23)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_SERVICE_PRIORITY = new ValueProperty(TYPE, "ServicePriority");
    @Type(base=Integer.class)
    @Label(standard="event dispatcher priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(24)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY = new ValueProperty(TYPE, "EventDispatcherPriority");
    @Type(base=Integer.class)
    @Label(standard="worker priority")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(25)/param-value")})
    @NumericRange(min="1", max="10")
    @Since(value="12.1.2")
    public static final ValueProperty PROP_WORKER_PRIORITY = new ValueProperty(TYPE, "WorkerPriority");
    @Label(standard="reliable transport")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(26)/param-value")})
    @Since(value="12.1.2")
    public static final ValueProperty PROP_RELIABLE_TRANSPORT = new ValueProperty(TYPE, "ReliableTransport");
    @Type(base=Boolean.class)
    @Label(standard="async backup")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(27)/param-value")})
    @Since(value="12.1.2")
    public static final ValueProperty PROP_ASYNC_BACKUP = new ValueProperty(TYPE, "AsyncBackup");

    public Value<Long> getStandardLease();

    public void setStandardLease(String var1);

    public void setStandardLease(Long var1);

    public Value<LeaseGranularity> getLeaseGranularity();

    public void setLeaseGranularity(String var1);

    public void setLeaseGranularity(LeaseGranularity var1);

    public Value<Integer> getPartitionCount();

    public void setPartitionCount(String var1);

    public void setPartitionCount(Integer var1);

    public Value<LocalStorage> getLocalStorage();

    public void setLocalStorage(String var1);

    public void setLocalStorage(LocalStorage var1);

    public Value<Integer> getTransferThreshold();

    public void setTransferThreshold(String var1);

    public void setTransferThreshold(Integer var1);

    public Value<Integer> getBackupCount();

    public void setBackupCount(String var1);

    public void setBackupCount(Integer var1);

    public Value<BackupStorageType> getBackupStorageType();

    public void setBackupStorageType(String var1);

    public void setBackupStorageType(BackupStorageType var1);

    public Value<Integer> getThreadCount();

    public void setThreadCount(String var1);

    public void setThreadCount(Integer var1);

    public ReferenceValue<JavaTypeName, JavaType> getKeyAssociatorClassName();

    public void setKeyAssociatorClassName(String var1);

    public void setKeyAssociatorClassName(JavaTypeName var1);

    public ReferenceValue<JavaTypeName, JavaType> getKeyPartitioningClassName();

    public void setKeyPartitioningClassName(String var1);

    public void setKeyPartitioningClassName(JavaTypeName var1);

    public ReferenceValue<JavaTypeName, JavaType> getPartitionListenerClassName();

    public void setPartitionListenerClassName(String var1);

    public void setPartitionListenerClassName(JavaTypeName var1);

    public Value<String> getSerializer();

    public void setSerializer(String var1);

    public Value<Integer> getBackupCountAfterWritebehind();

    public void setBackupCountAfterWritebehind(String var1);

    public void setBackupCountAfterWritebehind(Integer var1);

    public Value<String> getServiceFailurePolicy();

    public void setServiceFailurePolicy(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getMemberListenerClassName();

    public void setMemberListenerClassName(String var1);

    public void setMemberListenerClassName(JavaTypeName var1);

    public Value<String> getPartitionedQuorumPolicyScheme();

    public void setPartitionedQuorumPolicyScheme(String var1);

    public Value<String> getPartitionAssignmentStrategy();

    public void setPartitionAssignmentStrategy(String var1);

    public Value<String> getCompressor();

    public void setCompressor(String var1);

    public Value<BigDecimal> getBackupStorageInitialSize();

    public void setBackupStorageInitialSize(String var1);

    public void setBackupStorageInitialSize(BigDecimal var1);

    public Value<SizeUnit> getBackupStorageInitialSizeUnit();

    public void setBackupStorageInitialSizeUnit(String var1);

    public void setBackupStorageInitialSizeUnit(SizeUnit var1);

    public Value<BigDecimal> getBackupStorageMaximumSize();

    public void setBackupStorageMaximumSize(String var1);

    public void setBackupStorageMaximumSize(BigDecimal var1);

    public Value<SizeUnit> getBackupStorageMaximumSizeUnit();

    public void setBackupStorageMaximumSizeUnit(String var1);

    public void setBackupStorageMaximumSizeUnit(SizeUnit var1);

    public Value<Path> getBackupStorageDirectory();

    public void setBackupStorageDirectory(String var1);

    public void setBackupStorageDirectory(Path var1);

    public ReferenceValue<JavaTypeName, JavaType> getBackupStorageClassName();

    public void setBackupStorageClassName(String var1);

    public void setBackupStorageClassName(JavaTypeName var1);

    public Value<String> getBackupStorageSchemeName();

    public void setBackupStorageSchemeName(String var1);

    public Value<Integer> getServicePriority();

    public void setServicePriority(String var1);

    public void setServicePriority(Integer var1);

    public Value<Integer> getEventDispatcherPriority();

    public void setEventDispatcherPriority(String var1);

    public void setEventDispatcherPriority(Integer var1);

    public Value<Integer> getWorkerPriority();

    public void setWorkerPriority(String var1);

    public void setWorkerPriority(Integer var1);

    public Value<String> getReliableTransport();

    public void setReliableTransport(String var1);

    public Value<Boolean> getAsyncBackup();

    public void setAsyncBackup(String var1);

    public void setAsyncBackup(Boolean var1);
}

