/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.IListItemInitParam;
import oracle.eclipse.tools.coherence.descriptors.override.ISerializer;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideMethodValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.UniqueSerializerValidator;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

@Label(standard="custom serializer")
public interface ISerializerGeneric
extends ISerializer {
    public static final ElementType TYPE = new ElementType(ISerializerGeneric.class);
    @Required
    @Service(impl=UniqueSerializerValidator.class)
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, ISerializer.PROP_ID);
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="class")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"class-name"})
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="class-name")})
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.io.Serializer"})
    @MustExist
    @Since(value="3.6")
    @Documentation(content="Specify an implementation for a serializer.")
    @Validation(rule="${ VersionMatches( Root.Version, '3.6)' ) || ( VersionMatches( Root.Version, '[3.6' ) && ( ClassName != null || ClassFactoryName != null ) ) }", message="Class or factory must be specified")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, "ClassName");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="factory")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"class-factory-name"})
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="class-factory-name")})
    @MustExist
    @Since(value="3.6")
    @Validation(rule="${ VersionMatches( Root.Version, '3.6)' ) || ( VersionMatches( Root.Version, '[3.6' ) && ( ClassName != null || ClassFactoryName != null ) ) }", message="Class or factory must be specified")
    public static final ValueProperty PROP_CLASS_FACTORY_NAME = new ValueProperty(TYPE, "ClassFactoryName");
    @Label(standard="method")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"method-name"})
    @Services(value={@Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="method-name")}), @Service(impl=OverrideMethodValuesProvider.class)})
    @Enablement(expr="${ ClassFactoryName != null }")
    @Since(value="3.6")
    public static final ValueProperty PROP_METHOD_NAME = new ValueProperty(TYPE, "MethodName");
    @Type(base=IListItemInitParam.class)
    @Label(standard="parameters")
    @Since(value="3.6")
    public static final ListProperty PROP_INIT_PARAMS = new ListProperty(TYPE, "InitParams");

    public ReferenceValue<JavaTypeName, JavaType> getClassName();

    public void setClassName(String var1);

    public void setClassName(JavaTypeName var1);

    public ReferenceValue<JavaTypeName, JavaType> getClassFactoryName();

    public void setClassFactoryName(String var1);

    public void setClassFactoryName(JavaTypeName var1);

    public Value<String> getMethodName();

    public void setMethodName(String var1);

    public ElementList<IListItemInitParam> getInitParams();
}

