/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.IAuthorizer;
import oracle.eclipse.tools.coherence.descriptors.override.ISecurityAccessControllerInitParam;
import oracle.eclipse.tools.coherence.descriptors.override.ISecurityCallbackHandler;
import oracle.eclipse.tools.coherence.descriptors.override.ISecurityIdentityAsserter;
import oracle.eclipse.tools.coherence.descriptors.override.ISecurityIdentityTransformer;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.SecurityAccessControllerInitParamListController;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ISecurityConfig
extends Element {
    public static final ElementType TYPE = new ElementType(ISecurityConfig.class);
    @Type(base=Boolean.class)
    @Label(standard="enable security features")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"enabled"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="security-config/enabled")})
    @Documentation(content="Specifies whether the security features are enabled. All other configuration elements in the security-config group will be verified for validity and used if and only if the value of this element is true.")
    public static final ValueProperty PROP_ENABLED = new ValueProperty(TYPE, "Enabled");
    @Label(standard="login module")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"login-module-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="security-config/login-module-name")})
    @Documentation(content="Specifies the name of the JAAS LoginModule that should be used to authenticate the caller. This name should match a module in a configuration file will be used by the JAAS (for example specified via the -Djava.security.auth.login.config Java command line attribute).")
    public static final ValueProperty PROP_LOGIN_MODULE_NAME = new ValueProperty(TYPE, "LoginModuleName");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="class")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"access-controller/class-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="security-config/access-controller//class-name")})
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.security.AccessController"})
    @MustExist
    @Documentation(content="Specifies the name of a Java class that implements com.tangosol.net.security.AccessController interface, which will be used by the Coherence Security Framework to check access rights for clustered resources and encrypt/decrypt node-to-node communications regarding those rights.")
    public static final ValueProperty PROP_ACCESS_CONTROLLER_CLASS_NAME = new ValueProperty(TYPE, "AccessControllerClassName");
    @Type(base=ISecurityAccessControllerInitParam.class)
    @CustomXmlListBinding(impl=SecurityAccessControllerInitParamListController.class)
    @FixedOrderList
    @Label(standard="parameters")
    public static final ListProperty PROP_ACCESS_CONTROLLER_INIT_PARAMS = new ListProperty(TYPE, "AccessControllerInitParams");
    @XmlBinding(path="callback-handler")
    @Type(base=ISecurityCallbackHandler.class)
    public static final ImpliedElementProperty PROP_CALLBACK_HANDLER = new ImpliedElementProperty(TYPE, "CallbackHandler");
    @XmlBinding(path="identity-asserter")
    @Type(base=ISecurityIdentityAsserter.class)
    @Since(value="3.6")
    public static final ElementProperty PROP_IDENTITY_ASSERTER = new ElementProperty(TYPE, "IdentityAsserter");
    @XmlBinding(path="identity-transformer")
    @Type(base=ISecurityIdentityTransformer.class)
    @Since(value="3.6")
    public static final ElementProperty PROP_IDENTITY_TRANSFORMER = new ElementProperty(TYPE, "IdentityTransformer");
    @Type(base=Boolean.class)
    @Label(standard="subject scope")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"subject-scope"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="security-config/subject-scope"), @Service.Param(name="default", value="false")})
    @Since(value="3.6")
    @Documentation(content="Specifies whether the remote cache or service reference is shared by subject. The setting of \"true\" means that remote references are not globally shared; each subject will get a different reference.")
    public static final ValueProperty PROP_SUBJECT_SCOPE = new ValueProperty(TYPE, "SubjectScope");
    @XmlBinding(path="authorizer")
    @Type(base=IAuthorizer.class)
    @Since(value="12.1.2")
    public static final ElementProperty PROP_AUTHORIZER = new ElementProperty(TYPE, "Authorizer");

    public Value<Boolean> getEnabled();

    public void setEnabled(String var1);

    public void setEnabled(Boolean var1);

    public Value<String> getLoginModuleName();

    public void setLoginModuleName(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getAccessControllerClassName();

    public void setAccessControllerClassName(String var1);

    public void setAccessControllerClassName(JavaTypeName var1);

    public ElementList<ISecurityAccessControllerInitParam> getAccessControllerInitParams();

    public ISecurityCallbackHandler getCallbackHandler();

    public ElementHandle<ISecurityIdentityAsserter> getIdentityAsserter();

    public ElementHandle<ISecurityIdentityTransformer> getIdentityTransformer();

    public Value<Boolean> getSubjectScope();

    public void setSubjectScope(String var1);

    public void setSubjectScope(Boolean var1);

    public ElementHandle<IAuthorizer> getAuthorizer();
}

