/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizePercentUnit;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.SizeValidator;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.PercentValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface IRamjournalManager
extends Element {
    public static final ElementType TYPE = new ElementType(IRamjournalManager.class);
    @Label(standard="minimum load factor")
    @Type(base=Double.class)
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"minimum-load-factor"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/minimum-load-factor")})
    @NumericRange(min="0.01", max="0.99")
    @Since(value="3.7")
    @Documentation(content="The factor of live data below which a Journal file is eligible for compaction (garbage collection).")
    public static final ValueProperty PROP_MINIMUM_LOAD_FACTOR = new ValueProperty(TYPE, "MinimumLoadFactor");
    @Label(standard="maximum value size")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-value-size", "true", "16KB"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/maximum-value-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16KB")}), @Service(impl=SizeValidator.class, params={@Service.Param(name="unitProp", value="MaximumValueSizeUnit"), @Service.Param(name="min", value=""), @Service.Param(name="max", value="4MB")})})
    @NumericRange(min="0")
    @Since(value="3.7")
    @Documentation(content="Specifies the maximum size, in bytes, of binary values that are to be stored in the RAM journal. The value cannot exceed 4MB.[pbr/]When a flash journal is used to back up a RAM journal, binary values that exceed the maximum value size are automatically delegated to the flash journal.")
    public static final ValueProperty PROP_MAXIMUM_VALUE_SIZE = new ValueProperty(TYPE, "MaximumValueSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-value-size", "false", "16KB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/maximum-value-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16KB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumValueSize")})})
    public static final ValueProperty PROP_MAXIMUM_VALUE_SIZE_UNIT = new ValueProperty(TYPE, "MaximumValueSizeUnit");
    @Label(standard="maximum file size")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-file-size", "true", "2GB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/maximum-file-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="2GB")})
    @NumericRange(min="0")
    @Since(value="3.7")
    @Documentation(content="The maximum file size for any file.")
    public static final ValueProperty PROP_MAXIMUM_FILE_SIZE = new ValueProperty(TYPE, "MaximumFileSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-file-size", "false", "2GB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/maximum-file-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="2GB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumFileSize")})})
    public static final ValueProperty PROP_MAXIMUM_FILE_SIZE_UNIT = new ValueProperty(TYPE, "MaximumFileSizeUnit");
    @Label(standard="maximum size")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-size", "true", "25%"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/maximum-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="25%")}), @Service(impl=PercentValidator.class, params={@Service.Param(name="unitProp", value="MaximumSizeUnit")})})
    @Since(value="3.7")
    @Documentation(content="Specifies the maximum amount of RAM that is used by the journal. The value can either be specified as a percentage of the maximum available heap or as a specific amount of memory. If the value contains a percentage sign (%), it is interpreted as a percentage of the maximum JVM heap (the JVM max heap is typically specified by the -Xmx argument on the java command line). If specified as a specific amount of memory, the value must be between 16MB and 64GB. The default value is 25%. That is, the RAM journal resource manager uses a maximum of 25% of the available JVM heap. A RAM journal is always backed up by a flash journal and all data in excess of the maximum RAM size is automatically delegated to the flash journal.")
    public static final ValueProperty PROP_MAXIMUM_SIZE = new ValueProperty(TYPE, "MaximumSize");
    @Type(base=SizePercentUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"maximum-size", "false", "25%"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/maximum-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="25%")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumSize")})})
    public static final ValueProperty PROP_MAXIMUM_SIZE_UNIT = new ValueProperty(TYPE, "MaximumSizeUnit");
    @Label(standard="off heap")
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"off-heap"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/journaling-config/ramjournal-manager/off-heap")})
    @Since(value="3.7")
    @Documentation(content="Boolean indicating whether to use in VM byte buffer or of-heap NIO buffers.")
    public static final ValueProperty PROP_OFF_HEAP = new ValueProperty(TYPE, "OffHeap");

    public Value<Double> getMinimumLoadFactor();

    public void setMinimumLoadFactor(String var1);

    public void setMinimumLoadFactor(Double var1);

    public Value<BigDecimal> getMaximumValueSize();

    public void setMaximumValueSize(String var1);

    public void setMaximumValueSize(BigDecimal var1);

    public Value<SizeUnit> getMaximumValueSizeUnit();

    public void setMaximumValueSizeUnit(String var1);

    public void setMaximumValueSizeUnit(SizeUnit var1);

    public Value<BigDecimal> getMaximumFileSize();

    public void setMaximumFileSize(String var1);

    public void setMaximumFileSize(BigDecimal var1);

    public Value<SizeUnit> getMaximumFileSizeUnit();

    public void setMaximumFileSizeUnit(String var1);

    public void setMaximumFileSizeUnit(SizeUnit var1);

    public Value<BigDecimal> getMaximumSize();

    public void setMaximumSize(String var1);

    public void setMaximumSize(BigDecimal var1);

    public Value<SizePercentUnit> getMaximumSizeUnit();

    public void setMaximumSizeUnit(String var1);

    public void setMaximumSizeUnit(SizePercentUnit var1);

    public Value<Boolean> getOffHeap();

    public void setOffHeap(String var1);

    public void setOffHeap(Boolean var1);
}

