/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.override.IPacketDelivery;
import oracle.eclipse.tools.coherence.descriptors.override.PacketBufferChoice;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.PacketBufferTypeCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IPacketPublisher
extends Element {
    public static final ElementType TYPE = new ElementType(IPacketPublisher.class);
    @Type(base=IPacketDelivery.class)
    @XmlBinding(path="packet-delivery")
    public static final ImpliedElementProperty PROP_PACKET_DELIVERY = new ImpliedElementProperty(TYPE, "PacketDelivery");
    @Type(base=Integer.class)
    @Label(standard="maximum length")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-size/maximum-length"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-size/maximum-length")})
    @NumericRange(min="512")
    @Documentation(content="Specifies the packet size in bytes which all cluster members can safely support.[pbr/]This value must be the same for all members in the cluster. A low value can artificially limit the maximum size of the cluster.[pbr/]This value should be at least 512, and defaults to 64KB.")
    public static final ValueProperty PROP_PACKET_SIZE_MAXIMUM_LENGTH = new ValueProperty(TYPE, "PacketSizeMaximumLength");
    @Type(base=Integer.class)
    @Label(standard="preferred length")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-size/preferred-length"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-size/preferred-length")})
    @NumericRange(min="512")
    @Documentation(content="Specifies the preferred size, in bytes, of the DatagramPacket objects that will be sent and received on the unicast and multicast sockets.[pbr/]This value can be larger or smaller then the maximum-length value, and need not be the same for all cluster members. The ideal value is one which will fit within the network MTU, leaving enough space for either the UDP or TCP packet headers, which are 32, and 52 bytes respectively.[pbr/]This value should be at least 512, and default to a value based on the local nodes MTU. An MTU of 1500 is assumed if the MTU cannot be obtained.")
    public static final ValueProperty PROP_PACKET_SIZE_PREFERRED_LENGTH = new ValueProperty(TYPE, "PacketSizePreferredLength");
    @Type(base=Integer.class)
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-pool/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-pool/maximum-packets")})
    @NumericRange(min="1", max="10000")
    @VersionCompatibility(value="3.5]")
    @Documentation(content="The maximum number of reusable packets to be utilized by the services responsible for publishing and receiving. The pools are intially small, and will grow on demand up to the specified limits.")
    public static final ValueProperty PROP_PACKET_POOL_MAXIMUM_PACKETS = new ValueProperty(TYPE, "PacketPoolMaximumPackets");
    @Type(base=BigDecimal.class)
    @Label(standard="size")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-pool/size", "true", "16MB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-pool/size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")})
    @NumericRange(min="1")
    @VersionCompatibility(value="[3.6-12.1.2)")
    public static final ValueProperty PROP_PACKET_POOL_SIZE = new ValueProperty(TYPE, "PacketPoolSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-pool/size", "false", "16MB"})
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-pool/size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="PacketPoolSize")})})
    public static final ValueProperty PROP_PACKET_POOL_SIZE_UNIT = new ValueProperty(TYPE, "PacketPoolSizeUnit");
    @Type(base=Integer.class)
    @Label(standard="ACK delay (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"notification-queueing/ack-delay-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/notification-queueing/ack-delay-milliseconds")})
    @NumericRange(min="0", max="60000")
    @Documentation(content="Specifies the maximum number of milliseconds that the packet publisher will delay before sending an ACK packet. The ACK packet may be transmitted earlier if number of batched acknowledgments fills the ACK packet.[pbr/]This value should be substantially lower then the remote node's packet-delivery resend timeout, to allow ample time for the ACK to be received and processed by the remote node before the resend timeout expires.")
    public static final ValueProperty PROP_ACK_DELAY = new ValueProperty(TYPE, "AckDelay");
    @Type(base=Integer.class)
    @Label(standard="NACK delay (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"notification-queueing/nack-delay-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/notification-queueing/nack-delay-milliseconds")})
    @NumericRange(min="0", max="60000")
    @Documentation(content="Specifies the number of milliseconds that the packet publisher will delay before sending a NACK packet.")
    public static final ValueProperty PROP_NACK_DELAY = new ValueProperty(TYPE, "NackDelay");
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="maximum packets", defaultArbitraryValue="16", namedValues={@NamedValues.NamedValue(value="0", label="no limit")})
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"burst-mode/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/burst-mode/maximum-packets")})
    @NumericRange(min="0", max="65535")
    @VersionCompatibility(value="3.5]")
    @Documentation(content="Specifies the maximum number of packets that the will be sent in a row without pausing. Zero indicates no limit. By setting this value relatively low, Coherence is forced to hold back when sending a large number of packets, which may reduce collisions in some instances or allow incoming traffic to be more quickly processed.")
    public static final ValueProperty PROP_BURST_MODE_MAXIMUM_PACKETS = new ValueProperty(TYPE, "BurstModeMaximumPackets");
    @Type(base=Integer.class)
    @Label(standard="pause (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"burst-mode/pause-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/burst-mode/pause-milliseconds")})
    @NumericRange(min="0", max="60000")
    @VersionCompatibility(value="3.5]")
    @Documentation(content="Specifies the minimum number of milliseconds to delay between long bursts of packets. By increasing this value, Coherence is forced to hold back when sending a large number of packets, which may reduce collisions in some instances or allow incoming traffic to be more quickly processed.")
    public static final ValueProperty PROP_BURST_MODE_PAUSE_MILLISECONDS = new ValueProperty(TYPE, "BurstModePauseMilliseconds");
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="maximum packets", defaultArbitraryValue="8192", namedValues={@NamedValues.NamedValue(value="0", label="no limit")})
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"traffic-jam/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/traffic-jam/maximum-packets")})
    @NumericRange(min="0", max="65535")
    @Documentation(content="Specifies the maximum number of pending packets that the Publisher will tolerate before determining that it is clogged and must slow down client requests (requests from local non-system threads). Zero means no limit. This property prevents most unexpected out-of-memory conditions by limiting the size of the resend queue.")
    public static final ValueProperty PROP_TRAFFIC_JAM_MAXIMUM_PACKETS = new ValueProperty(TYPE, "TrafficJamMaximumPackets");
    @Type(base=Integer.class)
    @Label(standard="pause (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"traffic-jam/pause-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/traffic-jam/pause-milliseconds")})
    @NumericRange(min="0", max="60000")
    @Documentation(content="Number of milliseconds that the Publisher will pause a client thread that is trying to send a message when the Publisher is clogged. The Publisher will not allow the message to go through until the clog is gone, and will repeatedly sleep the thread for the duration specified by this property.")
    public static final ValueProperty PROP_TRAFFIC_JAM_PAUSE_MILLISECONDS = new ValueProperty(TYPE, "TrafficJamPauseMilliseconds");
    @Type(base=PacketBufferChoice.class)
    @Label(standard="packet buffer")
    @DefaultValue(text="NONE")
    @CustomXmlValueBinding(impl=PacketBufferTypeCustomBinding.class)
    public static final ValueProperty PROP_PACKET_BUFFER_CHOICE = new ValueProperty(TYPE, "PacketBufferChoice");
    @Type(base=Integer.class)
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-buffer/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-buffer/maximum-packets"), @Service.Param(name="default", value="32")})
    @NumericRange(min="1")
    @Documentation(content="Specifies the number of packets of maximum size that the datagram socket will be asked to size itself to buffer.")
    public static final ValueProperty PROP_PACKET_BUFFER_MAXIMUM_PACKETS = new ValueProperty(TYPE, "PacketBufferMaximumPackets");
    @Type(base=BigDecimal.class)
    @Label(standard="size")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-buffer/size", "true", "16MB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-buffer/size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")})
    @NumericRange(min="1")
    @Since(value="3.7")
    public static final ValueProperty PROP_PACKET_BUFFER_SIZE = new ValueProperty(TYPE, "PacketBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-buffer/size", "false", "16MB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-buffer/size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="PacketBufferSize")})})
    public static final ValueProperty PROP_PACKET_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "PacketBufferSizeUnit");
    @Type(base=Integer.class)
    @Label(standard="priority")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"priority"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/priority")})
    @NumericRange(min="1", max="10")
    @Documentation(content="Specifies a priority of the packet publisher execution thread.")
    public static final ValueProperty PROP_PRIORITY = new ValueProperty(TYPE, "Priority");
    @Type(base=Boolean.class)
    @Label(standard="enable TCMP clustering")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"enabled"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/enabled")})
    @Documentation(content="Specifies if TCMP clustering is enabled. For Coherence editions which support both Coherence Extend and Coherence TCMP based clustering, this feature allows TCMP to be disabled to ensure that a node only connects via the Extend protocol.")
    public static final ValueProperty PROP_ENABLED = new ValueProperty(TYPE, "Enabled");

    public IPacketDelivery getPacketDelivery();

    public Value<Integer> getPacketSizeMaximumLength();

    public void setPacketSizeMaximumLength(String var1);

    public void setPacketSizeMaximumLength(Integer var1);

    public Value<Integer> getPacketSizePreferredLength();

    public void setPacketSizePreferredLength(String var1);

    public void setPacketSizePreferredLength(Integer var1);

    public Value<Integer> getPacketPoolMaximumPackets();

    public void setPacketPoolMaximumPackets(String var1);

    public void setPacketPoolMaximumPackets(Integer var1);

    public Value<BigDecimal> getPacketPoolSize();

    public void setPacketPoolSize(String var1);

    public void setPacketPoolSize(BigDecimal var1);

    public Value<SizeUnit> getPacketPoolSizeUnit();

    public void setPacketPoolSizeUnit(String var1);

    public void setPacketPoolSizeUnit(SizeUnit var1);

    public Value<Integer> getAckDelay();

    public void setAckDelay(String var1);

    public void setAckDelay(Integer var1);

    public Value<Integer> getNackDelay();

    public void setNackDelay(String var1);

    public void setNackDelay(Integer var1);

    public Value<Integer> getBurstModeMaximumPackets();

    public void setBurstModeMaximumPackets(String var1);

    public void setBurstModeMaximumPackets(Integer var1);

    public Value<Integer> getBurstModePauseMilliseconds();

    public void setBurstModePauseMilliseconds(String var1);

    public void setBurstModePauseMilliseconds(Integer var1);

    public Value<Integer> getTrafficJamMaximumPackets();

    public void setTrafficJamMaximumPackets(String var1);

    public void setTrafficJamMaximumPackets(Integer var1);

    public Value<Integer> getTrafficJamPauseMilliseconds();

    public void setTrafficJamPauseMilliseconds(String var1);

    public void setTrafficJamPauseMilliseconds(Integer var1);

    public Value<PacketBufferChoice> getPacketBufferChoice();

    public void setPacketBufferChoice(String var1);

    public void setPacketBufferChoice(PacketBufferChoice var1);

    public Value<Integer> getPacketBufferMaximumPackets();

    public void setPacketBufferMaximumPackets(String var1);

    public void setPacketBufferMaximumPackets(Integer var1);

    public Value<BigDecimal> getPacketBufferSize();

    public void setPacketBufferSize(String var1);

    public void setPacketBufferSize(BigDecimal var1);

    public Value<SizeUnit> getPacketBufferSizeUnit();

    public void setPacketBufferSizeUnit(String var1);

    public void setPacketBufferSizeUnit(SizeUnit var1);

    public Value<Integer> getPriority();

    public void setPriority(String var1);

    public void setPriority(Integer var1);

    public Value<Boolean> getEnabled();

    public void setEnabled(String var1);

    public void setEnabled(Boolean var1);
}

