/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.override.AllRefreshUnit;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface IPacketDelivery
extends Element {
    public static final ElementType TYPE = new ElementType(IPacketDelivery.class);
    @Type(base=Integer.class)
    @Label(standard="resend (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"resend-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/resend-milliseconds")})
    @NumericRange(min="10", max="1000")
    @Documentation(content="For packets which require confirmation, specifies the minimum amount of time in milliseconds to wait for a corresponding ACK packet, before resending a packet.")
    public static final ValueProperty PROP_RESEND = new ValueProperty(TYPE, "Resend");
    @Type(base=Integer.class)
    @Label(standard="timeout (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"timeout-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/timeout-milliseconds")})
    @NumericRange(min="1000", max="1000000")
    @Documentation(content="For packets which require confirmation, specifies the maximum amount of time, in milliseconds, that a packet will be resent. After this timeout expires Coherence will make a determination if the recipient is to be considered \"dead\". This determination takes additional data into account, such as if other nodes are still able to communicate with the recipient.")
    public static final ValueProperty PROP_TIMEOUT = new ValueProperty(TYPE, "Timeout");
    @Type(base=Integer.class)
    @Label(standard="heartbeat (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"heartbeat-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/heartbeat-milliseconds")})
    @NumericRange(min="100", max="60000")
    @Documentation(content="Specifies the interval between heartbeats. Each member issues a unicast heartbeat, and the most senior member issues the cluster heartbeat, which is a broadcast message. The heartbeat is used by the tcp-ring-listener as part of fast death detection.")
    public static final ValueProperty PROP_HEARTBEAT = new ValueProperty(TYPE, "Heartbeat");
    @Type(base=Boolean.class)
    @Label(standard="enable flow control")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"flow-control/enabled"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/flow-control/enabled")})
    @Documentation(content="Specifies if flow control is enabled.")
    public static final ValueProperty PROP_FLOW_CONTROL_ENABLED = new ValueProperty(TYPE, "FlowControlEnabled");
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="maximum packets", defaultArbitraryValue="16", namedValues={@NamedValues.NamedValue(value="0", label="disable pause detection")})
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"flow-control/pause-detection/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/flow-control/pause-detection/maximum-packets")})
    @NumericRange(min="0")
    @Documentation(content="The maximum number of packets that will be resent to an unresponsive cluster node before assuming that the node is paused. Specifying a value of 0 will disable pause detection.")
    public static final ValueProperty PROP_FLOW_CONTROL_MAXIMUM_PACKETS = new ValueProperty(TYPE, "FlowControlMaximumPackets");
    @Type(base=Integer.class)
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"flow-control/outstanding-packets/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/flow-control/outstanding-packets/maximum-packets")})
    @NumericRange(min="256")
    @Validation(rule="${ FlowControlOutstandingMinimumPackets <= FlowControlOutstandingMaximumPackets }", message="Must be greater than or equal to minimum packets.")
    @Fact(statement="Must be greater than or equal to minimum packets.")
    @Documentation(content="The maximum number of unconfirmed packets that will be sent to a cluster node before packets addressed to that node will be deferred.")
    public static final ValueProperty PROP_FLOW_CONTROL_OUTSTANDING_MAXIMUM_PACKETS = new ValueProperty(TYPE, "FlowControlOutstandingMaximumPackets");
    @Type(base=Integer.class)
    @Label(standard="minimum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"flow-control/outstanding-packets/minimum-packets"})
    @NumericRange(min="16")
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/flow-control/outstanding-packets/minimum-packets")})
    @Validation(rule="${ FlowControlOutstandingMinimumPackets <= FlowControlOutstandingMaximumPackets }", message="Must be less than or equal to maximum packets.")
    @Fact(statement="Must be less than or equal to maximum packets.")
    @Documentation(content="The lower bound on the range for the number of unconfirmed packets that will be sent to a cluster node before packets addressed to that node will be deferred.")
    public static final ValueProperty PROP_FLOW_CONTROL_OUTSTANDING_MINIMUM_PACKETS = new ValueProperty(TYPE, "FlowControlOutstandingMinimumPackets");
    @Type(base=BigDecimal.class)
    @Label(standard="maximum deferral time")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-bundling/maximum-deferral-time", "true", "1us"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/packet-bundling/maximum-deferral-time"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="1us")})
    @NumericRange(min="0")
    @Documentation(content="The maximum amount of time to defer a packet while waiting for additional packets to bundle. A value of zero will result in the algorithm not waiting, and only bundling the readily accessible packets. A value greater than zero will cause some transmission deferral while waiting for additional packets to become available. This value is typically set below 250 microseconds to avoid a detrimental throughput impact. If the units are not specified, nanoseconds are assumed.")
    public static final ValueProperty PROP_PACKET_BUNDLING_MAXIMUM_DEFERRAL_TIME = new ValueProperty(TYPE, "PacketBundlingMaximumDeferralTime");
    @Type(base=AllRefreshUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-bundling/maximum-deferral-time", "false", "1us"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/packet-bundling/maximum-deferral-time"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="1us")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="PacketBundlingMaximumDeferralTime")})})
    public static final ValueProperty PROP_PACKET_BUNDLING_MAXIMUM_DEFERRAL_TIME_UNIT = new ValueProperty(TYPE, "PacketBundlingMaximumDeferralTimeUnit");
    @Type(base=Double.class)
    @Label(standard="aggression factor")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-bundling/aggression-factor"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-publisher/packet-delivery/packet-bundling/aggression-factor")})
    @NumericRange(min="0", max="1000")
    @Documentation(content="Specifies the aggressiveness of the packet deferral algorithm. Where as the maximum-deferral-time element defines the upper limit on the deferral time, the aggression-factor influences the average deferral time. The higher the aggression value, the longer the Publisher may wait for additional packets. The factor may be expressed as a real number, and often times values between 0.0 and 1.0 will be allow for high packet utilization while keeping latency to a minimum.")
    public static final ValueProperty PROP_PACKET_BUNDLING_AGGRESSION_FACTOR = new ValueProperty(TYPE, "PacketBundlingAggressionFactor");

    public Value<Integer> getResend();

    public void setResend(String var1);

    public void setResend(Integer var1);

    public Value<Integer> getTimeout();

    public void setTimeout(String var1);

    public void setTimeout(Integer var1);

    public Value<Integer> getHeartbeat();

    public void setHeartbeat(String var1);

    public void setHeartbeat(Integer var1);

    public Value<Boolean> getFlowControlEnabled();

    public void setFlowControlEnabled(String var1);

    public void setFlowControlEnabled(Boolean var1);

    public Value<Integer> getFlowControlMaximumPackets();

    public void setFlowControlMaximumPackets(String var1);

    public void setFlowControlMaximumPackets(Integer var1);

    public Value<Integer> getFlowControlOutstandingMaximumPackets();

    public void setFlowControlOutstandingMaximumPackets(String var1);

    public void setFlowControlOutstandingMaximumPackets(Integer var1);

    public Value<Integer> getFlowControlOutstandingMinimumPackets();

    public void setFlowControlOutstandingMinimumPackets(String var1);

    public void setFlowControlOutstandingMinimumPackets(Integer var1);

    public Value<BigDecimal> getPacketBundlingMaximumDeferralTime();

    public void setPacketBundlingMaximumDeferralTime(String var1);

    public void setPacketBundlingMaximumDeferralTime(BigDecimal var1);

    public Value<AllRefreshUnit> getPacketBundlingMaximumDeferralTimeUnit();

    public void setPacketBundlingMaximumDeferralTimeUnit(String var1);

    public void setPacketBundlingMaximumDeferralTimeUnit(AllRefreshUnit var1);

    public Value<Double> getPacketBundlingAggressionFactor();

    public void setPacketBundlingAggressionFactor(String var1);

    public void setPacketBundlingAggressionFactor(Double var1);
}

