/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.override.IFilterName;
import oracle.eclipse.tools.coherence.descriptors.override.internal.FilterValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IOutgoingMessageHandler
extends Element {
    public static final ElementType TYPE = new ElementType(IOutgoingMessageHandler.class);
    @Type(base=Integer.class)
    @Label(standard="segments")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"message-pool/segments"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/outgoing-message-handler/message-pool/segments")})
    @NumericRange(min="0")
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Documentation(content="The number of segments used by the message pool. Each segment will store buffers of a specific size. The size difference between two segments are specified by the growth factor.")
    public static final ValueProperty PROP_SEGMENTS = new ValueProperty(TYPE, "Segments");
    @Type(base=BigDecimal.class)
    @Label(standard="segment size")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"message-pool/segment-size", "true", "16MB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/outgoing-message-handler/message-pool/segment-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")})
    @NumericRange(min="0")
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Documentation(content="The maximum size of a single pool segment. The maximum size of the entire pool is the number of segments times the maximum size of a segment.")
    public static final ValueProperty PROP_SEGMENT_SIZE = new ValueProperty(TYPE, "SegmentSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"message-pool/segment-size", "false", "16MB"})
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/outgoing-message-handler/message-pool/segment-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="SegmentSize")})})
    public static final ValueProperty PROP_SEGMENT_SIZE_UNIT = new ValueProperty(TYPE, "SegmentSizeUnit");
    @Type(base=BigDecimal.class)
    @Label(standard="min buffer size")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"message-pool/min-buffer-size", "true", "1KB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/outgoing-message-handler/message-pool/min-buffer-size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="1KB")})
    @NumericRange(min="0")
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Documentation(content="The smallest available buffer size as in bytes. This value must be a multiple of 1024, and the smallest possible buffer is hence 1024 bytes.")
    public static final ValueProperty PROP_MIN_BUFFER_SIZE = new ValueProperty(TYPE, "MinBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"message-pool/min-buffer-size", "false", "1KB"})
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/outgoing-message-handler/message-pool/min-buffer-size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="1KB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MinBufferSize")})})
    public static final ValueProperty PROP_MIN_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "MinBufferSizeUnit");
    @Type(base=Integer.class)
    @Label(standard="growth factor")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"message-pool/growth-factor"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/outgoing-message-handler/message-pool/growth-factor")})
    @VersionCompatibility(value="[3.6-12.1.2)")
    @Documentation(content="The growth factor indicates the rate of growth between successive segments.")
    public static final ValueProperty PROP_GROWTH_FACTOR = new ValueProperty(TYPE, "GrowthFactor");
    @Type(base=IFilterName.class)
    @XmlListBinding(path="use-filters", mappings={@XmlListBinding.Mapping(element="filter-name", type=IFilterName.class)})
    @Label(standard="use filters")
    @Service(impl=FilterValuesProvider.class)
    @Documentation(content="Contains the list of filter names to be used by this outgoing message handler.")
    public static final ListProperty PROP_USE_FILTERS = new ListProperty(TYPE, "UseFilters");

    public Value<Integer> getSegments();

    public void setSegments(String var1);

    public void setSegments(Integer var1);

    public Value<BigDecimal> getSegmentSize();

    public void setSegmentSize(String var1);

    public void setSegmentSize(BigDecimal var1);

    public Value<SizeUnit> getSegmentSizeUnit();

    public void setSegmentSizeUnit(String var1);

    public void setSegmentSizeUnit(SizeUnit var1);

    public Value<BigDecimal> getMinBufferSize();

    public void setMinBufferSize(String var1);

    public void setMinBufferSize(BigDecimal var1);

    public Value<SizeUnit> getMinBufferSizeUnit();

    public void setMinBufferSizeUnit(String var1);

    public void setMinBufferSizeUnit(SizeUnit var1);

    public Value<Integer> getGrowthFactor();

    public void setGrowthFactor(String var1);

    public void setGrowthFactor(Integer var1);

    public ElementList<IFilterName> getUseFilters();
}

