/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.IPAddressValidationService;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.override.PacketBufferChoice;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.PacketBufferTypeCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface IMulticastListener
extends Element {
    public static final ElementType TYPE = new ElementType(IMulticastListener.class);
    @Label(standard="interface")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"interface"})
    @Services(value={@Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/interface")}), @Service(impl=IPAddressValidationService.class)})
    @Documentation(content="Specifies the IP address that a multicast Socket will be bound to. By default the interface of the unicast-listener IP address is used for the multicast Socket; this option allows the interface to be specified. Setting this address to \"0.0.0.0\" will allow the OS to use the unicast routing table to select the interface automatically.[pbr/]Note: Regarding networking, the term \"interface\" is often used to mean \"NIC\".[pbr/]WARNING: With rare exception, use of this particular option is strongly discouraged, as it can lead to a condition known as \"partial failure\". Partial failure occurs when some portion of the cluster communication is working and other cluster communication has failed. Partial failure can occur when using this option, because the interface (and thus network) used for multicast traffic can be different from the interface (and thus network) used for unicast (UDP/IP) and TCP-ring (TCP/IP) traffic. If one interface (or network) fails, some communication can continue to succeed, while other communication will fail, which may cause failover to take longer to occur. Since clustering handles node (and thus interface) failure, it is preferableto have all communication fail together, and thus the use of this option isstrongly discouraged.")
    public static final ValueProperty PROP_INTERFACE_VALUE = new ValueProperty(TYPE, "InterfaceValue");
    @Label(standard="address")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"address"})
    @Services(value={@Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/address")}), @Service(impl=IPAddressValidationService.class)})
    @Documentation(content="Specifies the multicast IP address that a Socket will listen or publish on.")
    public static final ValueProperty PROP_ADDRESS = new ValueProperty(TYPE, "Address");
    @Type(base=Integer.class)
    @Label(standard="port")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"port"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/port")})
    @NumericRange(min="1", max="65535")
    @Documentation(content="Specifies the port that the Socket will listen or publish on.")
    public static final ValueProperty PROP_PORT = new ValueProperty(TYPE, "Port");
    @Type(base=Integer.class)
    @Label(standard="time to live")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"time-to-live"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/time-to-live")})
    @NumericRange(min="0", max="255")
    @Documentation(content="Specifies the time-to-live setting for the multicast. This determines the maximum number of \"hops\" a packet may traverse, where a hop is measured as a traversal from one network segment to another via a router.[pbr/]For production use, this value should be set to the lowest integer value that works. On a single server cluster, it should work at 0; on a simple switched backbone, it should work at 1; on an advanced backbone with intelligent switching, it may require a value of 2 or more. Setting the value too high can use unnecessary bandwidth on other LAN segments and can even cause the OS or network devices to disable multicast traffic. While a value of 0 is meant to keep packets from leaving the originating machine, some OSs do not implement this correctly, and the packets may in fact be transmitted on the network.")
    public static final ValueProperty PROP_TIME_TO_LIVE = new ValueProperty(TYPE, "TimeToLive");
    @Type(base=PacketBufferChoice.class)
    @Label(standard="packet buffer")
    @DefaultValue(text="NONE")
    @CustomXmlValueBinding(impl=PacketBufferTypeCustomBinding.class)
    public static final ValueProperty PROP_PACKET_BUFFER_CHOICE = new ValueProperty(TYPE, "PacketBufferChoice");
    @Type(base=Integer.class)
    @Label(standard="maximum packets")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-buffer/maximum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/packet-buffer/maximum-packets"), @Service.Param(name="default", value="64")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the number of packets of maximum size that the datagram socket will be asked to size itself to buffer.")
    public static final ValueProperty PROP_PACKET_BUFFER_MAXIMUM_PACKETS = new ValueProperty(TYPE, "PacketBufferMaximumPackets");
    @Type(base=BigDecimal.class)
    @Label(standard="packet buffer size")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-buffer/size", "true", "16MB"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/packet-buffer/size"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="16MB")})
    @NumericRange(min="1")
    @Since(value="3.7")
    public static final ValueProperty PROP_PACKET_BUFFER_SIZE = new ValueProperty(TYPE, "PacketBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"packet-buffer/size", "false", "16MB"})
    @Since(value="3.7")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/packet-buffer/size"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="16MB")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="PacketBufferSize")})})
    public static final ValueProperty PROP_PACKET_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "PacketBufferSizeUnit");
    @Type(base=Integer.class)
    @Label(standard="priority")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"priority"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/priority")})
    @NumericRange(min="1", max="10")
    @Documentation(content="Specifies a priority of the multicast listener execution thread.")
    public static final ValueProperty PROP_PRIORITY = new ValueProperty(TYPE, "Priority");
    @Type(base=Integer.class)
    @Label(standard="join timeout (msec)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"join-timeout-milliseconds"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/join-timeout-milliseconds")})
    @NumericRange(min="1", max="1000000")
    @Documentation(content="Specifies the number of milliseconds that a new member will wait without finding any evidence of a cluster before starting its own cluster and electing itself as the senior cluster member.")
    public static final ValueProperty PROP_JOIN_TIMEOUT_MILLISECONDS = new ValueProperty(TYPE, "JoinTimeoutMilliseconds");
    @Type(base=Integer.class)
    @Label(standard="multicast threshold (percent)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"multicast-threshold-percent"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/multicast-listener/multicast-threshold-percent")})
    @NumericRange(min="1", max="100")
    @Documentation(content="Specifies the threshold percentage value used to determine whether a packet will be sent via unicast or multicast. It is a percentage value and is in the range of 1% to 100%. In a cluster of \"n\" nodes, a particular node sending a packet to a set of other (i.e. not counting self) destination nodes of size \"d\" (in the range of 0 to n-1), the packet will be sent multicast if and only if the following both hold true:[pbr/]1. The packet is being sent over the network to more than one other node, i.e. (d > 1).[br/]2. The number of nodes is greater than the threshold,i.e. (d > (n-1) * (threshold/100)).[pbr/]Setting this value to 1 will allow the implementation to use multicast for basically all multi-point traffic. Setting it to 100 will force the implementation to use unicast for all multi-point traffic except for explicit broadcast traffic (e.g. cluster heartbeat and discovery) because the 100% threshold will never be exceeded. With the setting of 25 the implementation will send the packet using unicast if it is destined for less than one-fourth of all nodes, and send it using multicast if it is destined for the one-fourth or more of all nodes.[pbr/]Note: This element is only used if the well-known-addresses element is empty.")
    public static final ValueProperty PROP_MULTICAST_THRESHOLD_PERCENT = new ValueProperty(TYPE, "MulticastThresholdPercent");

    public Value<String> getInterfaceValue();

    public void setInterfaceValue(String var1);

    public Value<String> getAddress();

    public void setAddress(String var1);

    public Value<Integer> getPort();

    public void setPort(String var1);

    public void setPort(Integer var1);

    public Value<Integer> getTimeToLive();

    public void setTimeToLive(String var1);

    public void setTimeToLive(Integer var1);

    public Value<PacketBufferChoice> getPacketBufferChoice();

    public void setPacketBufferChoice(String var1);

    public void setPacketBufferChoice(PacketBufferChoice var1);

    public Value<Integer> getPacketBufferMaximumPackets();

    public void setPacketBufferMaximumPackets(String var1);

    public void setPacketBufferMaximumPackets(Integer var1);

    public Value<BigDecimal> getPacketBufferSize();

    public void setPacketBufferSize(String var1);

    public void setPacketBufferSize(BigDecimal var1);

    public Value<SizeUnit> getPacketBufferSizeUnit();

    public void setPacketBufferSizeUnit(String var1);

    public void setPacketBufferSizeUnit(SizeUnit var1);

    public Value<Integer> getPriority();

    public void setPriority(String var1);

    public void setPriority(Integer var1);

    public Value<Integer> getJoinTimeoutMilliseconds();

    public void setJoinTimeoutMilliseconds(String var1);

    public void setJoinTimeoutMilliseconds(Integer var1);

    public Value<Integer> getMulticastThresholdPercent();

    public void setMulticastThresholdPercent(String var1);

    public void setMulticastThresholdPercent(Integer var1);
}

