/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface IMemberIdentity
extends Element {
    public static final ElementType TYPE = new ElementType(IMemberIdentity.class);
    @Label(standard="cluster name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"cluster-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/cluster-name")})
    @Documentation(content="Specifies the name of the cluster. In order to join the cluster all members must specify the same cluster name.[pbr/]It is strongly suggested that cluster-name be specified for production systems, thus preventing accidental cluster discovery among applications.")
    public static final ValueProperty PROP_CLUSTER_NAME = new ValueProperty(TYPE, "ClusterName");
    @Label(standard="site name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"site-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/site-name")})
    @Documentation(content="Specifies the name of the geographic site that the member is hosted at. For WAN clustering, this value identifies the datacenter within which the member is located, and can be used as the basis for intelligent routing, load balancing and disaster recovery planning (i.e. the explicit backing up of data on separate geographic sites). The name is also useful for displaying management information (e.g. JMX) and interpreting log entries. Coherence currently does not make use of this element in making decisions about data backup location.")
    public static final ValueProperty PROP_SITE_NAME = new ValueProperty(TYPE, "SiteName");
    @Label(standard="rack name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"rack-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/rack-name")})
    @Documentation(content="Specifies the name of the location within a geographic site that the member is hosted at. This is often a cage, rack or bladeframe identifier, and can be used as the basis for intelligent routing, load balancing and disaster recovery planning (i.e. the explicit backing up of data on separate bladeframes). The name is also useful for displaying management information (e.g. JMX) and interpreting log entries. Coherence currently does not make use of this element in making decisions about data backup location.")
    public static final ValueProperty PROP_RACK_NAME = new ValueProperty(TYPE, "RackName");
    @Label(standard="machine name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"machine-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/machine-name")})
    @Documentation(content="Specifies the name of the physical server that the member is hosted on. This is often the same name as the server identifies itself as (e.g. its HOSTNAME, or its name as it appears in a DNS entry). If provided, the machine-name is used as the basis for creating a machine-id, which in turn is used to guarantee that data are backed up on different physical machines to prevent single points of failure (SPOFs). The name is also useful for displaying management information (e.g. JMX) and interpreting log entries.")
    public static final ValueProperty PROP_MACHINE_NAME = new ValueProperty(TYPE, "MachineName");
    @Label(standard="process name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"process-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/process-name")})
    @Documentation(content="Specifies the name of the process (JVM) that the member is hosted on. This name makes it possible to easily differentiate among multiple JVMs running on the same machine. The name is also useful for displaying management information (e.g. JMX) and interpreting log entries.")
    public static final ValueProperty PROP_PROCESS_NAME = new ValueProperty(TYPE, "ProcessName");
    @Label(standard="member name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"member-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/member-name")})
    @Documentation(content="Specifies the name of the member itself. This name makes it possible to easily differentiate among members, such as when multiple members run on the same machine (or even within the same JVM).The name is also useful for displaying management information (e.g. JMX) and interpreting log entries.")
    public static final ValueProperty PROP_MEMBER_NAME = new ValueProperty(TYPE, "MemberName");
    @Label(standard="role name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"role-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/role-name")})
    @Documentation(content="Specifies the name of the member role. This name allows an application to organize members into specialized roles, such as cache servers and cache clients. The name is also useful for displaying management information (e.g. JMX) and interpreting log entries.")
    public static final ValueProperty PROP_ROLE_NAME = new ValueProperty(TYPE, "RoleName");
    @Type(base=Integer.class)
    @Label(standard="priority")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"priority"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/member-identity/priority")})
    @NumericRange(min="1", max="10")
    @Documentation(content="Specifies a priority of the corresponding member.[pbr/]The priority is used as the basis for determining tie-breakers between members. If a condition occurs in which one of two members will be ejected from the cluster, and in the rare case that it is not possible to objectively determine which of the two is at fault and should be ejected, then the member with the lower priority will be ejected.")
    public static final ValueProperty PROP_PRIORITY = new ValueProperty(TYPE, "Priority");

    public Value<String> getClusterName();

    public void setClusterName(String var1);

    public Value<String> getSiteName();

    public void setSiteName(String var1);

    public Value<String> getRackName();

    public void setRackName(String var1);

    public Value<String> getMachineName();

    public void setMachineName(String var1);

    public Value<String> getProcessName();

    public void setProcessName(String var1);

    public Value<String> getMemberName();

    public void setMemberName(String var1);

    public Value<String> getRoleName();

    public void setRoleName(String var1);

    public Value<Integer> getPriority();

    public void setPriority(String var1);

    public void setPriority(Integer var1);
}

