/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ManagementOption;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.RefreshOption;
import oracle.eclipse.tools.coherence.descriptors.override.IMBean;
import oracle.eclipse.tools.coherence.descriptors.override.IMbeanFilter;
import oracle.eclipse.tools.coherence.descriptors.override.IServerFactory;
import oracle.eclipse.tools.coherence.descriptors.override.MBeanPossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.override.internal.MBeansListController;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IManagementConfig
extends Element {
    public static final ElementType TYPE = new ElementType(IManagementConfig.class);
    @Type(base=ManagementOption.class)
    @Label(standard="management")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"managed-nodes"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/managed-nodes")})
    @Documentation(content="Specifies whether or not a cluster node's JVM has an [in-process] MBeanServer and if so, whether or not this node allows management of other nodes' managed objects.[pbr/]Legal values are:[ul][li]none: No MBeanServer is instantiated.[/li][li]local-only: Manage only MBeans which are local to the cluster node (i.e. within the same JVM).[/li][li]remote-only: Manage MBeans on other remotely manageable cluster nodes. Requires Coherence Enterprise Edition or higher.[/li][li]all: Manage both local and remotely manageable cluster nodes. Requires Coherence Enterprise Edition or higher.[/li][/ul]")
    public static final ValueProperty PROP_MANAGEMENT = new ValueProperty(TYPE, "Management");
    @Type(base=Boolean.class)
    @Label(standard="remote management")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"allow-remote-management"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/allow-remote-management")})
    @Documentation(content="Specifies whether or not this cluster node exposes its managed objects to remote MBeanServer(s).")
    public static final ValueProperty PROP_REMOTE_MANAGEMENT = new ValueProperty(TYPE, "RemoteManagement");
    @Type(base=RefreshOption.class)
    @Label(standard="refresh policy")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"refresh-policy"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/refresh-policy")})
    @Documentation(content="Specifies the refresh policy for the MBean.[pbr/]Legal values are: refresh-ahead, refresh-behind or refresh-expired.")
    public static final ValueProperty PROP_REFRESH_POLICY = new ValueProperty(TYPE, "RefreshPolicy");
    @Type(base=BigDecimal.class)
    @Label(standard="refresh expiry")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"refresh-expiry", "true", "1s"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/refresh-expiry"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="1s")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the minimum time interval between the remote retrieval of management information from remote nodes.")
    public static final ValueProperty PROP_REFRESH_EXPIRY = new ValueProperty(TYPE, "RefreshExpiry");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"refresh-expiry", "false", "1s"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/refresh-expiry"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="1s")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="RefreshExpiry")})})
    public static final ValueProperty PROP_REFRESH_EXPIRY_UNIT = new ValueProperty(TYPE, "RefreshExpiryUnit");
    @Type(base=BigDecimal.class)
    @Label(standard="refresh timeout")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"refresh-timeout", "true", "250ms"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/refresh-timeout"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="250ms")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the duration which the management node will wait for a response from a remote node when refreshing MBean information. This value must be less than the refresh-expiry interval.")
    public static final ValueProperty PROP_REFRESH_TIMEOUT = new ValueProperty(TYPE, "RefreshTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"refresh-timeout", "false", "250ms"})
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/refresh-timeout"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="250ms")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="RefreshTimeout")})})
    public static final ValueProperty PROP_REFRESH_TIMEOUT_UNIT = new ValueProperty(TYPE, "RefreshTimeoutUnit");
    @Type(base=Boolean.class)
    @Label(standard="read only")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"read-only"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/read-only")})
    @Documentation(content="Specifies whether or not the managed objects exposed by this cluster node allow operations that modify run-time attributes.")
    public static final ValueProperty PROP_READ_ONLY = new ValueProperty(TYPE, "ReadOnly");
    @Label(standard="default domain")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"default-domain-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/default-domain-name")})
    @Documentation(content="Specifies the name of the JMX domain used to register MBeans exposed by the Coherence Management Framework.")
    public static final ValueProperty PROP_DEFAULT_DOMAIN_NAME = new ValueProperty(TYPE, "DefaultDomainName");
    @Label(standard="service")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"service-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/service-name")})
    @Enablement(expr="${ RemoteManagement }")
    @Documentation(content="Specifies the name of the Invocation Service used for remote management.")
    public static final ValueProperty PROP_SERVICE_NAME = new ValueProperty(TYPE, "ServiceName");
    @Label(standard="MBeans")
    @Type(base=IMBean.class)
    @Service(impl=MBeanPossibleTypesService.class)
    @CustomXmlListBinding(impl=MBeansListController.class)
    public static final ListProperty PROP_MBEANS = new ListProperty(TYPE, "Mbeans");
    @Label(standard="configuration")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"reporter/configuration"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/reporter/configuration")})
    @Documentation(content="The XML file containing the Reporter configuration settings. (list of reports, the report frequency, etc).")
    public static final ValueProperty PROP_REPORTER_CONFIGURATION = new ValueProperty(TYPE, "ReporterConfiguration");
    @Type(base=Boolean.class)
    @Label(standard="autostart")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"reporter/autostart"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/reporter/autostart")})
    @Documentation(content="Flag to automatically start the reporter when the node is started.")
    public static final ValueProperty PROP_REPORTER_AUTOSTART = new ValueProperty(TYPE, "ReporterAutostart");
    @Type(base=Boolean.class)
    @Label(standard="distributed")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"reporter/distributed"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/reporter/distributed")})
    @Documentation(content="Determines if the reporter is running in a central model (false) or on every node in the cluster (true).")
    public static final ValueProperty PROP_REPORTER_DISTRIBUTED = new ValueProperty(TYPE, "ReporterDistributed");
    @Label(standard="time zone")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"reporter/timezone"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/reporter/timezone")})
    @Since(value="3.7.1")
    @Documentation(content="Specifies the time zone that should be used for date display.")
    public static final ValueProperty PROP_REPORTER_TIMEZONE = new ValueProperty(TYPE, "ReporterTimezone");
    @Label(standard="time format")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"reporter/timeformat"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/reporter/timeformat")})
    @Since(value="3.7.1")
    @Documentation(content="Specifies the format used for date display. This should be a string that can be parsed by java.text.SimpleDateFormat. Default value is \"EEE MMM dd HH:mm:ss zzz yyyy\".")
    public static final ValueProperty PROP_REPORTER_TIMEFORMAT = new ValueProperty(TYPE, "ReporterTimeformat");
    @Type(base=IMbeanFilter.class)
    @XmlBinding(path="mbean-filter")
    public static final ImpliedElementProperty PROP_MBEAN_FILTER = new ImpliedElementProperty(TYPE, "MbeanFilter");
    @Type(base=IServerFactory.class)
    @XmlBinding(path="server-factory")
    public static final ImpliedElementProperty PROP_SERVER_FACTORY = new ImpliedElementProperty(TYPE, "ServerFactory");
    @Type(base=Boolean.class)
    @Label(standard="MBean name extended")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"extended-mbean-name"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="management-config/extended-mbean-name")})
    @Since(value="12.1.2")
    @Documentation(content="Specifies whether or not global MBean names that are identified with a \"nodeId\" attribute are additionally extended to also identify the corresponding member name (if specified).[pbr/]For example: Coherence:type=Service,name=DistributedCache,member=Client1,nodeId=7")
    public static final ValueProperty PROP_EXTENDED_MBEAN_NAME = new ValueProperty(TYPE, "ExtendedMbeanName");

    public Value<ManagementOption> getManagement();

    public void setManagement(String var1);

    public void setManagement(ManagementOption var1);

    public Value<Boolean> getRemoteManagement();

    public void setRemoteManagement(String var1);

    public void setRemoteManagement(Boolean var1);

    public Value<RefreshOption> getRefreshPolicy();

    public void setRefreshPolicy(String var1);

    public void setRefreshPolicy(RefreshOption var1);

    public Value<BigDecimal> getRefreshExpiry();

    public void setRefreshExpiry(String var1);

    public void setRefreshExpiry(BigDecimal var1);

    public Value<TimeUnit> getRefreshExpiryUnit();

    public void setRefreshExpiryUnit(String var1);

    public void setRefreshExpiryUnit(TimeUnit var1);

    public Value<BigDecimal> getRefreshTimeout();

    public void setRefreshTimeout(String var1);

    public void setRefreshTimeout(BigDecimal var1);

    public Value<TimeUnit> getRefreshTimeoutUnit();

    public void setRefreshTimeoutUnit(String var1);

    public void setRefreshTimeoutUnit(TimeUnit var1);

    public Value<Boolean> getReadOnly();

    public void setReadOnly(String var1);

    public void setReadOnly(Boolean var1);

    public Value<String> getDefaultDomainName();

    public void setDefaultDomainName(String var1);

    public Value<String> getServiceName();

    public void setServiceName(String var1);

    public ElementList<IMBean> getMbeans();

    public Value<String> getReporterConfiguration();

    public void setReporterConfiguration(String var1);

    public Value<Boolean> getReporterAutostart();

    public void setReporterAutostart(String var1);

    public void setReporterAutostart(Boolean var1);

    public Value<Boolean> getReporterDistributed();

    public void setReporterDistributed(String var1);

    public void setReporterDistributed(Boolean var1);

    public Value<String> getReporterTimezone();

    public void setReporterTimezone(String var1);

    public Value<String> getReporterTimeformat();

    public void setReporterTimeformat(String var1);

    public IMbeanFilter getMbeanFilter();

    public IServerFactory getServerFactory();

    public Value<Boolean> getExtendedMbeanName();

    public void setExtendedMbeanName(String var1);

    public void setExtendedMbeanName(Boolean var1);
}

